/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.report.model.LogEntry;
import org.polarsys.kitalpha.report.model.ReportElementFactory;
import org.polarsys.kitalpha.report.model.ReportList;
import org.polarsys.kitalpha.report.model.Severity;
import org.polarsys.kitalpha.report.registry.ReportRegistry;

public abstract class AbstractReportFactory {
    private final String listId;

    public AbstractReportFactory(String listId) {
        this.listId = listId;
    }

    protected LogEntry log(Severity severity, String message, EObject reference) {
        LogEntry entry = ReportElementFactory.eINSTANCE.createLogEntry();
        return this.log(entry, severity, message, reference);
    }

    protected LogEntry log(LogEntry entry, Severity severity, String message, EObject reference) {
        entry.setDate(new Date());
        entry.setMessage(message);
        entry.setSeverity(severity);
        entry.setReferencedObject(reference);
        ReportList list = ReportRegistry.INSTANCE.getList(this.listId);
        list.getReports().add((Object)entry);
        return entry;
    }

    protected String toString(String msg, Throwable th) {
        StringWriter sw = new StringWriter();
        if (msg != null) {
            sw.append(msg).append("\n");
        }
        if (th != null) {
            th.printStackTrace(new PrintWriter(sw));
        }
        return sw.toString();
    }

    public String getListId() {
        return this.listId;
    }
}

