/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.library;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.LibraryTab;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.AtomicWidget;

public class MissingLibraryWidget {
    Button radio1;
    Button radio2;
    AtomicWidget cw;
    Text path;
    private LibraryTab tab;

    public MissingLibraryWidget(LibraryTab tab) {
        this.tab = tab;
    }

    public void createContents(Composite parent) {
        this.createWidget(parent, "Handling of other dependancies");
        this.attachListeners();
        this.initialize();
    }

    private void attachListeners() {
        this.radio1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MissingLibraryWidget.this.path.setEnabled(MissingLibraryWidget.this.radio1.getSelection());
                MissingLibraryWidget.this.tab.update();
            }
        });
        this.radio2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MissingLibraryWidget.this.path.setText("");
                MissingLibraryWidget.this.tab.update();
            }
        });
        this.path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MissingLibraryWidget.this.tab.update();
            }
        });
    }

    public void initialize() {
        this.radio2.setSelection(true);
        this.radio1.setSelection(false);
        this.path.setEnabled(false);
    }

    public void createWidget(Composite parent_p, String name_p) {
        Group group = new Group(parent_p, 0);
        group.setText(name_p);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        group.setLayoutData((Object)gd);
        this.cw = new AtomicWidget((Composite)group);
        this.radio1 = this.cw.createRadioButton((Composite)group, "Systematically force path", "");
        this.cw.createEmptyLabel(false);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        Label l = this.cw.createLabel("Path:");
        l.setLayoutData((Object)gd);
        this.path = this.cw.createText((Composite)group);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.path.setLayoutData((Object)gd);
        this.radio2 = this.cw.createRadioButton((Composite)group, "Apply Generation Strategy", "");
    }

    public Text createTextArea(Composite container) {
        Text description = new Text(container, 586);
        description.setEditable(false);
        GridData gd = new GridData(272);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        description.setLayoutData((Object)gd);
        return description;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String pathStr = this.path.getText();
        configuration.setAttribute("missing_lib_path", pathStr);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String value = configuration.getAttribute("missing_lib_path", "");
            if (!value.equals("")) {
                this.path.setText(value);
                this.radio1.setSelection(true);
                this.path.setEnabled(true);
                this.radio2.setSelection(false);
            }
            if (value.equals("")) {
                this.path.setText(value);
                this.radio1.setSelection(false);
                this.path.setEnabled(false);
                this.radio2.setSelection(true);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }
}

