/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.shared.view.menucreator;

import java.util.List;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.polarsys.kitalpha.massactions.core.extensionpoint.columnfilter.IMAColumnFilter;
import org.polarsys.kitalpha.massactions.core.table.IMATable;

public class MAColumnFilterMenuCreator
implements IMenuCreator {
    protected IMATable table;
    protected Menu filterMenu;
    protected MenuItem selectedFilterItem;

    public MAColumnFilterMenuCreator(IMATable table) {
        this.table = table;
    }

    protected MenuItem createFilterMenuItem(Menu parentMenu, final IMAColumnFilter filter, boolean selected) {
        final MenuItem filterMenuItem = new MenuItem(parentMenu, 32);
        filterMenuItem.setText(filter.getDisplayName());
        filterMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MAColumnFilterMenuCreator.this.table.commitAndCloseActiveCellEditor();
                MAColumnFilterMenuCreator.this.table.clearSelection();
                if (MAColumnFilterMenuCreator.this.selectedFilterItem != filterMenuItem) {
                    MAColumnFilterMenuCreator.this.selectedFilterItem.setSelection(false);
                    MAColumnFilterMenuCreator.this.selectedFilterItem = filterMenuItem;
                    MAColumnFilterMenuCreator.this.table.applyColumnFilter(filter);
                } else {
                    MAColumnFilterMenuCreator.this.selectedFilterItem.setSelection(true);
                }
            }
        });
        if (selected) {
            this.selectedFilterItem = filterMenuItem;
            filterMenuItem.setSelection(selected);
        }
        return filterMenuItem;
    }

    public void dispose() {
        if (this.filterMenu != null) {
            this.filterMenu.dispose();
        }
    }

    protected void createMenu() {
        List columnFilters = this.table.getColumnFilterList();
        int i = 0;
        while (i < columnFilters.size()) {
            IMAColumnFilter filter = (IMAColumnFilter)columnFilters.get(i);
            boolean isSelected = i == 0;
            this.createFilterMenuItem(this.filterMenu, filter, isSelected);
            ++i;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.filterMenu == null) {
            this.filterMenu = new Menu(parent);
            this.createMenu();
        }
        return this.filterMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.filterMenu == null) {
            this.filterMenu = new Menu(parent);
            this.createMenu();
        }
        return this.filterMenu;
    }
}

