/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import java.util.List;
import org.eclipse.kura.core.cloud.CloudServiceImpl;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.core.message.KuraBirthPayload;
import org.eclipse.kura.core.message.KuraDeviceProfile;
import org.eclipse.kura.core.message.KuraDisconnectPayload;
import org.eclipse.kura.core.util.NetUtil;
import org.eclipse.kura.message.KuraPosition;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.position.NmeaPosition;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.system.SystemAdminService;
import org.eclipse.kura.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCyclePayloadBuilder {
    private static final Logger s_logger = LoggerFactory.getLogger(LifeCyclePayloadBuilder.class);
    private static final String UNKNOWN = "UNKNOWN";
    private CloudServiceImpl m_cloudServiceImpl;

    LifeCyclePayloadBuilder(CloudServiceImpl cloudServiceImpl) {
        this.m_cloudServiceImpl = cloudServiceImpl;
    }

    public KuraBirthPayload buildBirthPayload() {
        KuraDeviceProfile deviceProfile = this.buildDeviceProfile();
        String appIds = this.buildApplicationIDs();
        String acceptEncoding = this.buildAcceptEncoding();
        CloudServiceOptions cso = this.m_cloudServiceImpl.getCloudServiceOptions();
        String deviceName = cso.getDeviceDisplayName();
        if (deviceName == null) {
            deviceName = this.m_cloudServiceImpl.getSystemService().getDeviceName();
        }
        KuraBirthPayload.KuraBirthPayloadBuilder birthPayloadBuilder = new KuraBirthPayload.KuraBirthPayloadBuilder();
        birthPayloadBuilder.withUptime(deviceProfile.getUptime()).withDisplayName(deviceName).withModelName(deviceProfile.getModelName()).withModelId(deviceProfile.getModelId()).withPartNumber(deviceProfile.getPartNumber()).withSerialNumber(deviceProfile.getSerialNumber()).withFirmwareVersion(deviceProfile.getFirmwareVersion()).withBiosVersion(deviceProfile.getBiosVersion()).withOs(deviceProfile.getOs()).withOsVersion(deviceProfile.getOsVersion()).withJvmName(deviceProfile.getJvmName()).withJvmVersion(deviceProfile.getJvmVersion()).withJvmProfile(deviceProfile.getJvmProfile()).withKuraVersion(deviceProfile.getKuraVersion()).withConnectionInterface(deviceProfile.getConnectionInterface()).withConnectionIp(deviceProfile.getConnectionIp()).withAcceptEncoding(acceptEncoding).withApplicationIdentifiers(appIds).withAvailableProcessors(deviceProfile.getAvailableProcessors()).withTotalMemory(deviceProfile.getTotalMemory()).withOsArch(deviceProfile.getOsArch()).withOsgiFramework(deviceProfile.getOsgiFramework()).withOsgiFrameworkVersion(deviceProfile.getOsgiFrameworkVersion());
        if (this.m_cloudServiceImpl.m_imei != null && this.m_cloudServiceImpl.m_imei.length() > 0 && !this.m_cloudServiceImpl.m_imei.equals("ERROR")) {
            birthPayloadBuilder.withModemImei(this.m_cloudServiceImpl.m_imei);
        }
        if (this.m_cloudServiceImpl.m_iccid != null && this.m_cloudServiceImpl.m_iccid.length() > 0 && !this.m_cloudServiceImpl.m_iccid.equals("ERROR")) {
            birthPayloadBuilder.withModemIccid(this.m_cloudServiceImpl.m_iccid);
        }
        if (this.m_cloudServiceImpl.m_imsi != null && this.m_cloudServiceImpl.m_imsi.length() > 0 && !this.m_cloudServiceImpl.m_imsi.equals("ERROR")) {
            birthPayloadBuilder.withModemImsi(this.m_cloudServiceImpl.m_imsi);
        }
        if (deviceProfile.getLatitude() != null && deviceProfile.getLongitude() != null) {
            KuraPosition KuraPosition2 = new KuraPosition();
            KuraPosition2.setLatitude(deviceProfile.getLatitude().doubleValue());
            KuraPosition2.setLongitude(deviceProfile.getLongitude().doubleValue());
            KuraPosition2.setAltitude(deviceProfile.getAltitude().doubleValue());
            birthPayloadBuilder.withPosition(KuraPosition2);
        }
        return birthPayloadBuilder.build();
    }

    public KuraDisconnectPayload buildDisconnectPayload() {
        SystemService systemService = this.m_cloudServiceImpl.getSystemService();
        SystemAdminService sysAdminService = this.m_cloudServiceImpl.getSystemAdminService();
        CloudServiceOptions cloudOptions = this.m_cloudServiceImpl.getCloudServiceOptions();
        String deviceName = cloudOptions.getDeviceDisplayName();
        if (deviceName == null) {
            deviceName = systemService.getDeviceName();
        }
        KuraDisconnectPayload payload = new KuraDisconnectPayload(sysAdminService.getUptime(), deviceName);
        return payload;
    }

    public KuraDeviceProfile buildDeviceProfile() {
        SystemService systemService = this.m_cloudServiceImpl.getSystemService();
        SystemAdminService sysAdminService = this.m_cloudServiceImpl.getSystemAdminService();
        NetworkService networkService = this.m_cloudServiceImpl.getNetworkService();
        PositionService positionService = this.m_cloudServiceImpl.getPositionService();
        StringBuilder sbConnectionIp = null;
        StringBuilder sbConnectionInterface = null;
        try {
            List nis = networkService.getActiveNetworkInterfaces();
            if (!nis.isEmpty()) {
                sbConnectionIp = new StringBuilder();
                sbConnectionInterface = new StringBuilder();
                for (NetInterface ni : nis) {
                    List nias = ni.getNetInterfaceAddresses();
                    if (nias == null || nias.isEmpty()) continue;
                    sbConnectionInterface.append(this.buildConnectionInterface((NetInterface<? extends NetInterfaceAddress>)ni)).append(",");
                    sbConnectionIp.append(this.buildConnectionIp((NetInterface<? extends NetInterfaceAddress>)ni)).append(",");
                }
                sbConnectionIp.deleteCharAt(sbConnectionIp.length() - 1);
                sbConnectionInterface.deleteCharAt(sbConnectionInterface.length() - 1);
            }
        }
        catch (Exception se) {
            s_logger.warn("Error while getting ConnetionIP and ConnectionInterface", (Throwable)se);
        }
        String connectionIp = sbConnectionIp != null ? sbConnectionIp.toString() : UNKNOWN;
        String connectionInterface = sbConnectionInterface != null ? sbConnectionInterface.toString() : UNKNOWN;
        double latitude = 0.0;
        double longitude = 0.0;
        double altitude = 0.0;
        if (positionService != null) {
            NmeaPosition position = positionService.getNmeaPosition();
            if (position != null) {
                latitude = position.getLatitude();
                longitude = position.getLongitude();
                altitude = position.getAltitude();
            } else {
                s_logger.warn("Unresolved PositionService reference.");
            }
        }
        KuraDeviceProfile KuraDeviceProfile2 = new KuraDeviceProfile(sysAdminService.getUptime(), systemService.getDeviceName(), systemService.getModelName(), systemService.getModelId(), systemService.getPartNumber(), systemService.getSerialNumber(), systemService.getFirmwareVersion(), systemService.getBiosVersion(), systemService.getOsName(), systemService.getOsVersion(), systemService.getJavaVmName(), String.valueOf(systemService.getJavaVmVersion()) + " " + systemService.getJavaVmInfo(), String.valueOf(systemService.getJavaVendor()) + " " + systemService.getJavaVersion(), systemService.getKuraVersion(), connectionInterface, connectionIp, latitude, longitude, altitude, String.valueOf(systemService.getNumberOfProcessors()), String.valueOf(systemService.getTotalMemory()), systemService.getOsArch(), systemService.getOsgiFwName(), systemService.getOsgiFwVersion());
        return KuraDeviceProfile2;
    }

    private String buildConnectionIp(NetInterface<? extends NetInterfaceAddress> ni) {
        String connectionIp = UNKNOWN;
        List nias = ni.getNetInterfaceAddresses();
        if (nias != null && !nias.isEmpty() && ((NetInterfaceAddress)nias.get(0)).getAddress() != null) {
            connectionIp = ((NetInterfaceAddress)nias.get(0)).getAddress().getHostAddress();
        }
        return connectionIp;
    }

    private String buildConnectionInterface(NetInterface<? extends NetInterfaceAddress> ni) {
        String connectionInterface = UNKNOWN;
        StringBuilder sb = new StringBuilder();
        sb.append(ni.getName()).append(" (").append(NetUtil.hardwareAddressToString((byte[])ni.getHardwareAddress())).append(")");
        connectionInterface = sb.toString();
        return connectionInterface;
    }

    private String buildApplicationIDs() {
        String[] appIdArray = this.m_cloudServiceImpl.getCloudApplicationIdentifiers();
        StringBuilder sbAppIDs = new StringBuilder();
        int i = 0;
        while (i < appIdArray.length) {
            if (i != 0) {
                sbAppIDs.append(",");
            }
            sbAppIDs.append(appIdArray[i]);
            ++i;
        }
        return sbAppIDs.toString();
    }

    private String buildAcceptEncoding() {
        String acceptEncoding = "";
        CloudServiceOptions options = this.m_cloudServiceImpl.getCloudServiceOptions();
        if (options.getEncodeGzip()) {
            acceptEncoding = "gzip";
        }
        return acceptEncoding;
    }
}

