/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsReceiver
implements Runnable {
    private static final String CLASS_NAME = CommsReceiver.class.getName();
    private static final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;
    private volatile boolean receiving;
    private final Semaphore runningSemaphore = new Semaphore(1);
    private String threadName;
    private Future receiverFuture;

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in) {
        this.in = new MqttInputStream(clientState, in);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        log.fine(CLASS_NAME, "start", "855");
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.receiverFuture = executorService.submit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            block11: {
                if (this.receiverFuture != null) {
                    this.receiverFuture.cancel(true);
                }
                log.fine(CLASS_NAME, "stop", "850");
                if (this.running) {
                    this.running = false;
                    this.receiving = false;
                    if (!Thread.currentThread().equals(this.recThread)) {
                        try {
                            try {
                                this.runningSemaphore.acquire();
                            }
                            catch (InterruptedException interruptedException) {
                                this.runningSemaphore.release();
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            this.runningSemaphore.release();
                            throw throwable;
                        }
                        this.runningSemaphore.release();
                    }
                }
            }
        }
        this.recThread = null;
        log.fine(CLASS_NAME, "stop", "851");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.recThread = Thread.currentThread();
        this.recThread.setName(this.threadName);
        token = null;
        try {
            this.runningSemaphore.acquire();
            if (true) ** GOTO lbl57
        }
        catch (InterruptedException v0) {
            this.running = false;
            return;
        }
        do {
            block17: {
                try {
                    CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "852");
                    this.receiving = this.in.available() > 0;
                    message = this.in.readMqttWireMessage();
                    this.receiving = false;
                    if (!(message instanceof MqttAck)) ** GOTO lbl31
                    token = this.tokenStore.getToken(message);
                    if (token != null) {
                        var3_5 = token;
                        synchronized (var3_5) {
                            this.clientState.notifyReceivedAck((MqttAck)message);
                            break block17;
                        }
                    }
                    if (message instanceof MqttPubRec || message instanceof MqttPubComp || message instanceof MqttPubAck) {
                        CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "857");
                    } else {
                        throw new MqttException(6);
lbl31:
                        // 1 sources

                        if (message != null) {
                            this.clientState.notifyReceivedMsg(message);
                        }
                    }
                }
                catch (MqttException ex) {
                    CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "856", null, ex);
                    this.running = false;
                    this.clientComms.shutdownConnection(token, ex);
                    this.receiving = false;
                    this.runningSemaphore.release();
                    continue;
                }
                catch (IOException ioe) {
                    try {
                        CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "853");
                        this.running = false;
                        if (this.clientComms.isDisconnecting()) continue;
                        this.clientComms.shutdownConnection(token, new MqttException(32109, (Throwable)ioe));
                        continue;
                    }
                    catch (Throwable var4_6) {
                        throw var4_6;
                    }
                    finally {
                        this.receiving = false;
                        this.runningSemaphore.release();
                    }
                }
            }
            this.receiving = false;
            this.runningSemaphore.release();
lbl57:
            // 5 sources

        } while (this.running && this.in != null);
        CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "854");
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isReceiving() {
        return this.receiving;
    }
}

