/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.broker.artemis.core.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.eclipse.kura.broker.artemis.core.internal.ProtocolTrackerListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolTracker {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolTracker.class);
    private final BundleContext context;
    private final Multimap<String, ProtocolManagerFactory<?>> protocols = HashMultimap.create();
    private final ServiceTrackerCustomizer<ProtocolManagerFactory, ProtocolManagerFactory> customizer = new ServiceTrackerCustomizer<ProtocolManagerFactory, ProtocolManagerFactory>(){

        public ProtocolManagerFactory addingService(ServiceReference<ProtocolManagerFactory> reference) {
            ProtocolManagerFactory service = (ProtocolManagerFactory)ProtocolTracker.this.context.getService(reference);
            ProtocolTracker.this.addProtocols(service);
            return service;
        }

        public void modifiedService(ServiceReference<ProtocolManagerFactory> reference, ProtocolManagerFactory service) {
        }

        public void removedService(ServiceReference<ProtocolManagerFactory> reference, ProtocolManagerFactory service) {
            ProtocolTracker.this.removeProtocols(service);
            ProtocolTracker.this.context.ungetService(reference);
        }
    };
    private final ServiceTracker<ProtocolManagerFactory, ProtocolManagerFactory> tracker;
    private final ProtocolTrackerListener listener;

    public ProtocolTracker(BundleContext context, ProtocolTrackerListener listener) {
        this.context = context;
        this.listener = listener;
        this.tracker = new ServiceTracker(context, ProtocolManagerFactory.class, this.customizer);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    protected synchronized void addProtocols(ProtocolManagerFactory<?> factory) {
        HashSet<String> protocols = new HashSet<String>(Arrays.asList(factory.getProtocols()));
        for (String protocol : protocols) {
            logger.info("Adding protocol - {} -> {}", (Object)protocol, factory);
            this.protocols.put((Object)protocol, factory);
        }
        if (this.listener != null) {
            this.listener.protocolsAdded(protocols);
        }
    }

    protected synchronized void removeProtocols(ProtocolManagerFactory<?> factory) {
        HashSet<String> protocols = new HashSet<String>(Arrays.asList(factory.getProtocols()));
        for (String protocol : protocols) {
            logger.info("Removing protocol - {} -> {}", (Object)protocol, factory);
            this.protocols.remove((Object)protocol, factory);
        }
        if (this.listener != null) {
            this.listener.protocolsRemoved(protocols);
        }
    }

    public synchronized Collection<ProtocolManagerFactory<?>> resolveProtocols(Set<String> requiredProtocols) {
        HashMap<String, ProtocolManagerFactory> result = new HashMap<String, ProtocolManagerFactory>();
        for (String required : requiredProtocols) {
            Collection factories = this.protocols.get((Object)required);
            if (factories.isEmpty()) {
                return null;
            }
            result.put(required, (ProtocolManagerFactory)factories.iterator().next());
        }
        for (Map.Entry entry : this.protocols.entries()) {
            if (result.containsKey(entry.getKey())) continue;
            result.put((String)entry.getKey(), (ProtocolManagerFactory)entry.getValue());
        }
        return result.values();
    }
}

