/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraBluetoothDiscoveryException;
import org.eclipse.kura.KuraBluetoothRemoveException;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.BluetoothLeDevice;
import org.eclipse.kura.bluetooth.le.BluetoothTransportType;
import org.eclipse.kura.internal.ble.BluetoothLeDeviceImpl;
import tinyb.BluetoothAdapter;
import tinyb.BluetoothDevice;
import tinyb.BluetoothException;
import tinyb.TransportType;

public class BluetoothLeAdapterImpl
implements BluetoothLeAdapter {
    private static final Logger logger = LogManager.getLogger();
    private static final long TIMEOUT = 30L;
    private final BluetoothAdapter adapter;

    public BluetoothLeAdapterImpl(BluetoothAdapter adapter) {
        this.adapter = adapter;
    }

    public String getAddress() {
        return this.adapter.getAddress();
    }

    public String getName() {
        return this.adapter.getName();
    }

    public String getInterfaceName() {
        return this.adapter.getInterfaceName();
    }

    public String getModalias() {
        return this.adapter.getModalias();
    }

    public String getAlias() {
        return this.adapter.getAlias();
    }

    public void setAlias(String value) {
        this.adapter.setAlias(value);
    }

    public long getBluetoothClass() {
        return this.adapter.getBluetoothClass();
    }

    public boolean isPowered() {
        return this.adapter.getPowered();
    }

    public void setPowered(boolean value) {
        this.adapter.setPowered(value);
    }

    public boolean isDiscoverable() {
        return this.adapter.getDiscoverable();
    }

    public void setDiscoverable(boolean value) {
        this.adapter.setDiscoverable(value);
    }

    public long getDiscoverableTimeout() {
        return this.adapter.getDiscoverableTimeout();
    }

    public void setDiscoverableTimout(long value) {
        this.setDiscoverableTimout(value);
    }

    public boolean isPairable() {
        return this.adapter.getPairable();
    }

    public void setPairable(boolean value) {
        this.adapter.setPairable(value);
    }

    public long getPairableTimeout() {
        return this.adapter.getPairableTimeout();
    }

    public void setPairableTimeout(long value) {
        this.adapter.setPairableTimeout(value);
    }

    public boolean isDiscovering() {
        return this.adapter.getDiscovering();
    }

    public UUID[] getUUIDs() {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        String[] stringArray = this.adapter.getUUIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uuid = stringArray[n2];
            uuidList.add(UUID.fromString(uuid));
            ++n2;
        }
        UUID[] uuids = new UUID[uuidList.size()];
        return uuidList.toArray(uuids);
    }

    public void stopDiscovery() throws KuraBluetoothDiscoveryException {
        try {
            this.adapter.stopDiscovery();
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothDiscoveryException((Throwable)e, (Object)"Stop discovery failed");
        }
    }

    public Future<BluetoothLeDevice> findDeviceByAddress(long timeout, String address) {
        return new BluetoothFuture<BluetoothLeDevice>(timeout, null, address);
    }

    public Future<BluetoothLeDevice> findDeviceByName(long timeout, String name) {
        return new BluetoothFuture<BluetoothLeDevice>(timeout, name, null);
    }

    public void findDeviceByAddress(long timeout, String address, Consumer<BluetoothLeDevice> consumer) {
        BluetoothFuture<BluetoothLeDevice> future = new BluetoothFuture<BluetoothLeDevice>(timeout, null, address);
        future.setConsumer(consumer);
    }

    public void findDeviceByName(long timeout, String name, Consumer<BluetoothLeDevice> consumer) {
        BluetoothFuture<BluetoothLeDevice> future = new BluetoothFuture<BluetoothLeDevice>(timeout, name, null);
        future.setConsumer(consumer);
    }

    public Future<List<BluetoothLeDevice>> findDevices(long timeout) {
        return new BluetoothFuture<List<BluetoothLeDevice>>(timeout);
    }

    public void findDevices(long timeout, Consumer<List<BluetoothLeDevice>> consumer) {
        BluetoothFuture<List<BluetoothLeDevice>> future = new BluetoothFuture<List<BluetoothLeDevice>>(timeout, null, null);
        future.setConsumer(consumer);
    }

    public int removeDevices() throws KuraBluetoothRemoveException {
        int removedDevices = 0;
        try {
            removedDevices = this.adapter.removeDevices();
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothRemoveException((Throwable)e, (Object)"Failed to remove devices");
        }
        return removedDevices;
    }

    public void setDiscoveryFilter(List<UUID> uuids, int rssi, int pathloss, BluetoothTransportType transportType) {
        this.adapter.setDiscoveryFilter(uuids, rssi, pathloss, this.toTransportType(transportType));
    }

    public void setRssiDiscoveryFilter(int rssi) {
        this.adapter.setRssiDiscoveryFilter(rssi);
    }

    private TransportType toTransportType(BluetoothTransportType type) {
        switch (type) {
            case AUTO: {
                return TransportType.AUTO;
            }
            case BREDR: {
                return TransportType.BREDR;
            }
            case LE: {
                return TransportType.LE;
            }
        }
        return TransportType.AUTO;
    }

    public class BluetoothFuture<T>
    extends CompletableFuture<T>
    implements Runnable {
        private final long internalTimeout;
        private String name;
        private String address;
        private Consumer<T> consumer;

        public BluetoothFuture(long timeout) {
            this.internalTimeout = timeout * 1000L;
            new Thread(this).start();
        }

        public BluetoothFuture(long timeout, String name, String address) {
            this.internalTimeout = timeout * 1000L;
            this.name = name;
            this.address = address;
            new Thread(this).start();
        }

        public void setConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            logger.info("The timeout value provided by get(...) method will be ignored");
            return this.get();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                BluetoothLeAdapterImpl.this.adapter.stopDiscovery();
            }
            catch (BluetoothException e) {
                logger.error("Stop discovery failed", (Throwable)e);
                return false;
            }
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public void run() {
            if (BluetoothLeAdapterImpl.this.adapter.getDiscovering()) {
                this.completeExceptionally((Throwable)new KuraBluetoothDiscoveryException((Object)"The BLE adapter has already been discovering..."));
            }
            try {
                BluetoothLeAdapterImpl.this.adapter.startDiscovery();
            }
            catch (BluetoothException e) {
                logger.error("Start discovery failed", (Throwable)e);
            }
            this.waitForStop();
            try {
                if (this.name != null || this.address != null) {
                    BluetoothDevice leDevice = BluetoothLeAdapterImpl.this.adapter.find(this.name, this.address, Duration.ofSeconds(30L));
                    if (leDevice == null || leDevice.getRSSI() == 0) {
                        this.complete(null);
                    } else {
                        this.complete(new BluetoothLeDeviceImpl(leDevice));
                    }
                    if (leDevice != null && this.consumer != null) {
                        this.consumer.accept(new BluetoothLeDeviceImpl(leDevice));
                    }
                } else {
                    List devices = BluetoothLeAdapterImpl.this.adapter.getDevices().stream().filter(device -> device.getRSSI() != 0).map(BluetoothLeDeviceImpl::new).collect(Collectors.toList());
                    this.complete(devices);
                    if (this.consumer != null) {
                        this.consumer.accept(devices);
                    }
                }
                BluetoothLeAdapterImpl.this.adapter.stopDiscovery();
            }
            catch (BluetoothException e) {
                logger.error("Stop discovery failed", (Throwable)e);
            }
        }

        private void waitForStop() {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start <= this.internalTimeout) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.completeExceptionally(e);
                }
            }
        }
    }
}

