/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.BluetoothLeService;
import org.eclipse.kura.internal.ble.BluetoothLeAdapterImpl;
import org.osgi.service.component.ComponentContext;
import tinyb.BluetoothAdapter;
import tinyb.BluetoothManager;

public class BluetoothLeServiceImpl
implements BluetoothLeService {
    private static final Logger logger = LogManager.getLogger();
    private BluetoothManager bluetoothManager;

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Le Service...");
        if (!this.startBluetoothSystemd() && !this.startBluetoothInitd()) {
            this.startBluetoothDaemon();
        }
        try {
            this.bluetoothManager = BluetoothManager.getBluetoothManager();
        }
        catch (RuntimeException | UnsatisfiedLinkError e) {
            logger.error("Failed to start bluetooth service", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Service...");
        this.bluetoothManager = null;
    }

    public List<BluetoothLeAdapter> getAdapters() {
        ArrayList<BluetoothLeAdapter> adapters = new ArrayList<BluetoothLeAdapter>();
        if (this.bluetoothManager != null) {
            for (BluetoothAdapter adapter : this.bluetoothManager.getAdapters()) {
                adapters.add(new BluetoothLeAdapterImpl(adapter));
            }
        }
        return adapters;
    }

    public BluetoothLeAdapter getAdapter(String interfaceName) {
        BluetoothLeAdapterImpl adapter = null;
        if (this.bluetoothManager != null) {
            for (BluetoothAdapter ba : this.bluetoothManager.getAdapters()) {
                if (!ba.getInterfaceName().equals(interfaceName)) continue;
                adapter = new BluetoothLeAdapterImpl(ba);
                break;
            }
        }
        return adapter;
    }

    private boolean startBluetoothSystemd() {
        String systemdCommand = "systemctl start bluetooth";
        boolean started = false;
        try {
            Process process = Runtime.getRuntime().exec(systemdCommand);
            started = process.waitFor() == 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Failed to start linux systemd bluetooth", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Failed to start linux systemd bluetooth", (Throwable)e);
        }
        return started;
    }

    private boolean startBluetoothInitd() {
        String initdCommand = "/etc/init.d/bluetooth start";
        boolean started = false;
        try {
            Process process = Runtime.getRuntime().exec(initdCommand);
            BufferedReader stdin = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String s = stdin.readLine();
            if (s != null && s.toLowerCase().contains("starting bluetooth")) {
                s = stdin.readLine();
                started = s != null && s.toLowerCase().contains("bluetoothd");
            }
        }
        catch (IOException e) {
            logger.error("Failed to start linux init.d bluetooth", (Throwable)e);
        }
        return started;
    }

    private void startBluetoothDaemon() {
        String daemonCommand = "bluetoothd -E";
        try {
            Runtime.getRuntime().exec(daemonCommand);
        }
        catch (IOException e) {
            logger.error("Failed to start linux bluetooth service", (Throwable)e);
        }
    }
}

