/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.eddystone;

import org.eclipse.kura.ble.eddystone.BluetoothLeEddystone;
import org.eclipse.kura.ble.eddystone.BluetoothLeEddystoneEncoder;
import org.eclipse.kura.internal.ble.eddystone.EddystoneFrameType;
import org.eclipse.kura.internal.ble.eddystone.EddystoneURLEncoding;
import org.eclipse.kura.internal.ble.eddystone.EddystoneURLScheme;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothLeEddystoneEncoderImpl
implements BluetoothLeEddystoneEncoder {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothLeEddystoneEncoderImpl.class);
    private static final byte PKT_BYTES_NUMBER = 31;
    private static final byte PAYLOAD_BYTES_NUMBER = 3;
    private static final byte UUID_LIST = 3;
    private static final byte[] EDDYSTONE_UUID = new byte[]{-2, -86};
    private static final byte EDDYSTONE_UID_PAYLOAD_LENGTH = 23;
    private static final byte SERVICE_DATA = 22;
    private static final Integer URL_MAX_LENGTH = 17;

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Le Eddystone Codec...");
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Le Eddystone Codec...");
    }

    public Class<BluetoothLeEddystone> getBeaconType() {
        return BluetoothLeEddystone.class;
    }

    public byte[] encode(BluetoothLeEddystone beacon) {
        byte flags = this.encodeFlags(beacon);
        EddystoneFrameType frameType = EddystoneFrameType.valueOf(beacon.getFrameType());
        if (frameType.equals((Object)EddystoneFrameType.UID)) {
            return this.encodeUID(flags, beacon);
        }
        if (frameType.equals((Object)EddystoneFrameType.URL)) {
            return this.encodeURL(flags, beacon);
        }
        if (frameType.equals((Object)EddystoneFrameType.TLM)) {
            return this.encodeTLM(flags, beacon);
        }
        if (frameType.equals((Object)EddystoneFrameType.EID)) {
            return this.encodeEID(flags, beacon);
        }
        return new byte[1];
    }

    private byte encodeFlags(BluetoothLeEddystone beacon) {
        byte flags = 0;
        flags = (byte)(flags | (beacon.isLeLimited() ? 1 : 0));
        flags = (byte)(flags | (beacon.isLeGeneral() ? 2 : 0));
        flags = (byte)(flags | (beacon.isBrEdrSupported() ? 4 : 0));
        flags = (byte)(flags | (beacon.isLeBrController() ? 8 : 0));
        flags = (byte)(flags | (beacon.isLeBrHost() ? 16 : 0));
        return flags;
    }

    private byte[] encodeUID(byte flags, BluetoothLeEddystone beacon) {
        byte[] data = new byte[32];
        data[0] = 31;
        data[1] = 2;
        data[2] = 1;
        data[3] = flags;
        data[4] = 3;
        data[5] = 3;
        data[6] = EDDYSTONE_UUID[1];
        data[7] = EDDYSTONE_UUID[0];
        data[8] = 23;
        data[9] = 22;
        data[10] = EDDYSTONE_UUID[1];
        data[11] = EDDYSTONE_UUID[0];
        data[12] = EddystoneFrameType.UID.getFrameTypeCode();
        data[13] = (byte)(beacon.getTxPower() & 0xFF);
        System.arraycopy(beacon.getNamespace(), 0, data, 14, 10);
        System.arraycopy(beacon.getInstance(), 0, data, 24, 6);
        data[30] = 0;
        data[31] = 0;
        return data;
    }

    private byte[] encodeURL(byte flags, BluetoothLeEddystone beacon) {
        byte[] hexUrl = EddystoneURLEncoding.encodeURL(beacon.getUrl());
        byte[] data = new byte[15 + URL_MAX_LENGTH];
        if (hexUrl.length <= URL_MAX_LENGTH) {
            data[0] = (byte)(14 + hexUrl.length);
            data[1] = 2;
            data[2] = 1;
            data[3] = flags;
            data[4] = 3;
            data[5] = 3;
            data[6] = EDDYSTONE_UUID[1];
            data[7] = EDDYSTONE_UUID[0];
            data[8] = (byte)(6 + hexUrl.length);
            data[9] = 22;
            data[10] = EDDYSTONE_UUID[1];
            data[11] = EDDYSTONE_UUID[0];
            data[12] = EddystoneFrameType.URL.getFrameTypeCode();
            data[13] = (byte)(beacon.getTxPower() & 0xFF);
            data[14] = EddystoneURLScheme.encodeURLScheme(beacon.getUrlScheme()).getUrlSchemeCode();
            System.arraycopy(hexUrl, 0, data, 15, hexUrl.length);
            int i = hexUrl.length;
            while (i < URL_MAX_LENGTH) {
                data[15 + i] = 0;
                ++i;
            }
        } else {
            logger.warn("Invalid Eddystone URL frame or url too long.");
        }
        return data;
    }

    private byte[] encodeTLM(byte flags, BluetoothLeEddystone beacon) {
        return new byte[1];
    }

    private byte[] encodeEID(byte flags, BluetoothLeEddystone beacon) {
        return new byte[1];
    }
}

