/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtGroupedNVPair;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtDeviceService;
import org.eclipse.kura.web.shared.service.GwtDeviceServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityService;
import org.eclipse.kura.web.shared.service.GwtSecurityServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.eclipse.kura.web.shared.service.GwtStatusService;
import org.eclipse.kura.web.shared.service.GwtStatusServiceAsync;

public class denali
implements EntryPoint {
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    Logger logger = Logger.getLogger(denali.class.getSimpleName());
    private final GwtStatusServiceAsync gwtStatusService = (GwtStatusServiceAsync)GWT.create(GwtStatusService.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtDeviceServiceAsync gwtDeviceService = (GwtDeviceServiceAsync)GWT.create(GwtDeviceService.class);
    private final GwtSecurityServiceAsync gwtSecurityService = (GwtSecurityServiceAsync)GWT.create(GwtSecurityService.class);
    private final EntryClassUi binder = (EntryClassUi)((Object)GWT.create(EntryClassUi.class));
    private boolean isDevelopMode;
    private boolean connected;

    public void onModuleLoad() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                denali.this.onModuleLoad2();
            }
        });
    }

    public void onModuleLoad2() {
        RootPanel.get().add((Widget)this.binder);
        denali.loadCss("denali/skin/skin.css");
        ScriptInjector.fromUrl((String)"denali/skin/skin.js?v=1").inject();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                FailureHandler.handle(ex, denali.class.getSimpleName());
            }

            public void onSuccess(GwtXSRFToken token) {
                denali.this.gwtDeviceService.findSystemProperties(token, new AsyncCallback<ArrayList<GwtGroupedNVPair>>(){

                    public void onSuccess(ArrayList<GwtGroupedNVPair> results) {
                        ArrayList<GwtGroupedNVPair> pairs;
                        final GwtSession gwtSession = new GwtSession();
                        if (results != null && (pairs = results) != null) {
                            for (GwtGroupedNVPair pair : pairs) {
                                String name = pair.getName();
                                if ("kura.have.net.admin".equals(name)) {
                                    Boolean value = Boolean.valueOf(pair.getValue());
                                    gwtSession.setNetAdminAvailable(value);
                                }
                                if ("kura.version".equals(name)) {
                                    gwtSession.setKuraVersion(pair.getValue());
                                }
                                if (!"kura.os.version".equals(name)) continue;
                                gwtSession.setOsVersion(pair.getValue());
                            }
                        }
                        denali.this.gwtSecurityService.isDebugMode(new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                FailureHandler.handle(caught, denali.class.getSimpleName());
                                denali.this.binder.setFooter(gwtSession);
                                denali.this.binder.initSystemPanel(gwtSession, denali.this.connected);
                                denali.this.binder.setSession(gwtSession);
                                denali.this.binder.init();
                            }

                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    denali.this.isDevelopMode = true;
                                    gwtSession.setDevelopMode(true);
                                }
                                denali.this.binder.setFooter(gwtSession);
                                denali.this.binder.initSystemPanel(gwtSession, denali.this.connected);
                                denali.this.binder.setSession(gwtSession);
                                denali.this.binder.init();
                            }
                        });
                    }

                    public void onFailure(Throwable caught) {
                        FailureHandler.handle(caught, denali.class.getSimpleName());
                        denali.this.binder.setFooter(new GwtSession());
                        denali.this.binder.initSystemPanel(new GwtSession(), denali.this.connected);
                        denali.this.binder.setSession(new GwtSession());
                    }
                });
            }
        });
    }

    private static native void loadCss(String var0);
}

