/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.Network;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.Network.NetworkTab;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.FormLabel;

public class TabHardwareUi
extends Composite
implements NetworkTab {
    private static TabHardwareUiUiBinder uiBinder = (TabHardwareUiUiBinder)GWT.create(TabHardwareUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    GwtSession session;
    GwtNetInterfaceConfig selectedNetIfConfig;
    @UiField
    FormLabel labelState;
    @UiField
    FormLabel labelName;
    @UiField
    FormLabel labelType;
    @UiField
    FormLabel labelHardware;
    @UiField
    FormLabel labelSerial;
    @UiField
    FormLabel labelDriver;
    @UiField
    FormLabel labelVersion;
    @UiField
    FormLabel labelFirmware;
    @UiField
    FormLabel labelMtu;
    @UiField
    FormLabel labelUsb;
    @UiField
    FormLabel labelRssi;
    @UiField
    FormControlStatic state;
    @UiField
    FormControlStatic name;
    @UiField
    FormControlStatic type;
    @UiField
    FormControlStatic hardware;
    @UiField
    FormControlStatic serial;
    @UiField
    FormControlStatic driver;
    @UiField
    FormControlStatic version;
    @UiField
    FormControlStatic firmware;
    @UiField
    FormControlStatic mtu;
    @UiField
    FormControlStatic usb;
    @UiField
    FormControlStatic rssi;

    public TabHardwareUi(GwtSession currentSession) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.session = currentSession;
        this.setDirty(false);
        this.labelState.setText(MSGS.netHwState());
        this.labelName.setText(MSGS.netHwName());
        this.labelType.setText(MSGS.netHwType());
        this.labelHardware.setText(MSGS.netHwAddress());
        this.labelSerial.setText(MSGS.netHwSerial());
        this.labelDriver.setText(MSGS.netHwDriver());
        this.labelVersion.setText(MSGS.netHwVersion());
        this.labelFirmware.setText(MSGS.netHwFirmware());
        this.labelMtu.setText(MSGS.netHwMTU());
        this.labelUsb.setText(MSGS.netHwUSBDevice());
        this.labelRssi.setText(MSGS.netHwSignalStrength());
    }

    @Override
    public void setDirty(boolean flag) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void setNetInterface(GwtNetInterfaceConfig config) {
        this.selectedNetIfConfig = config;
    }

    @Override
    public void refresh() {
        if (this.selectedNetIfConfig != null) {
            this.loadData();
        } else {
            this.reset();
        }
    }

    private void loadData() {
        this.state.setText(this.selectedNetIfConfig.getHwState());
        this.name.setText(this.selectedNetIfConfig.getHwName());
        this.type.setText(this.selectedNetIfConfig.getHwType());
        this.hardware.setText(this.selectedNetIfConfig.getHwAddress());
        this.serial.setText(this.selectedNetIfConfig.getHwSerial());
        this.driver.setText(this.selectedNetIfConfig.getHwDriver());
        this.version.setText(this.selectedNetIfConfig.getHwDriverVersion());
        this.firmware.setText(this.selectedNetIfConfig.getHwFirmware());
        this.mtu.setText(String.valueOf(this.selectedNetIfConfig.getHwMTU()));
        this.usb.setText(this.selectedNetIfConfig.getHwUsbDevice());
        this.rssi.setText(this.selectedNetIfConfig.getHwRssi());
    }

    private void reset() {
        this.state.setText("");
        this.name.setText("");
        this.type.setText("");
        this.hardware.setText("");
        this.serial.setText("");
        this.driver.setText("");
        this.version.setText("");
        this.firmware.setText("");
        this.mtu.setText("");
        this.usb.setText("");
        this.rssi.setText("");
    }

    @Override
    public void getUpdatedNetInterface(GwtNetInterfaceConfig updatedNetIf) {
        if (this.session != null) {
            updatedNetIf.setHwState(this.state.getText());
            updatedNetIf.setHwName(this.name.getText());
            updatedNetIf.setHwType(this.type.getText());
            updatedNetIf.setHwAddress(this.hardware.getText());
            updatedNetIf.setHwSerial(this.serial.getText());
            updatedNetIf.setHwDriver(this.driver.getText());
            updatedNetIf.setHwDriverVersion(this.version.getText());
            updatedNetIf.setHwFirmware(this.firmware.getText());
            if (this.mtu.getText() != null) {
                updatedNetIf.setHwMTU(Integer.parseInt(this.mtu.getText()));
            }
            updatedNetIf.setHwUsbDevice(this.usb.getText());
            updatedNetIf.setHwRssi(this.rssi.getText());
        }
    }

    static interface TabHardwareUiUiBinder
    extends UiBinder<Widget, TabHardwareUi> {
    }
}

