/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.StatusCodeException;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.Panel;

public class FailureHandler {
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private static Modal popup;
    private static Label errorMessageLabel;
    private static VerticalPanel errorStackTrace;
    private static Panel stackTraceContainer;

    private FailureHandler() {
    }

    public static void handle(Throwable caught, String name) {
        FailureHandler.printMessage(caught, name);
    }

    public static void handle(Throwable caught) {
        FailureHandler.printMessage(caught, "");
    }

    public static void showErrorMessage(String message) {
        FailureHandler.showErrorMessage("Warning", message, null);
    }

    public static void showErrorMessage(String message, StackTraceElement[] stackTrace) {
        FailureHandler.showErrorMessage("Warning", message, stackTrace);
    }

    public static void showErrorMessage(String title, String message, StackTraceElement[] stackTrace) {
        popup.setTitle(title);
        errorMessageLabel.setText(message);
        if (stackTrace == null) {
            stackTraceContainer.setVisible(false);
            return;
        }
        errorStackTrace.clear();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            Label tempLabel = new Label();
            tempLabel.setText(element.toString());
            errorStackTrace.add((Widget)tempLabel);
            ++n2;
        }
        stackTraceContainer.setVisible(true);
        popup.show();
    }

    private static void printMessage(Throwable caught, String name) {
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (name != null && !"".equals(name.trim())) {
            errorMessageBuilder.append(name);
            errorMessageBuilder.append(": ");
        }
        if (caught instanceof GwtKuraException) {
            GwtKuraException gee = (GwtKuraException)caught;
            GwtKuraErrorCode code = gee.getCode();
            if (code == GwtKuraErrorCode.DUPLICATE_NAME) {
                errorMessageBuilder.append(MSGS.duplicateNameError());
            } else if (code == GwtKuraErrorCode.CONNECTION_FAILURE) {
                errorMessageBuilder.append(MSGS.connectionFailure());
            } else if (code == GwtKuraErrorCode.ILLEGAL_ARGUMENT) {
                errorMessageBuilder.append(MSGS.illegalArgumentError());
            } else if (code == GwtKuraErrorCode.ILLEGAL_NULL_ARGUMENT) {
                errorMessageBuilder.append(MSGS.illegalNullArgumentError());
            } else {
                errorMessageBuilder.append(MSGS.genericError());
            }
        } else {
            if (caught instanceof StatusCodeException && ((StatusCodeException)caught).getStatusCode() == 0) {
                return;
            }
            String localizedMessage = caught.getLocalizedMessage();
            if (!"".equals(localizedMessage)) {
                errorMessageBuilder.append(localizedMessage);
            } else {
                errorMessageBuilder.append(MSGS.genericError());
            }
        }
        FailureHandler.showErrorMessage(errorMessageBuilder.toString(), caught.getStackTrace());
    }

    public static void setPopup(Modal uiElement, Label errorMessage, VerticalPanel errorStackTraceArea, Panel stackTraceContainerArea) {
        popup = uiElement;
        errorMessageLabel = errorMessage;
        errorStackTrace = errorStackTraceArea;
        stackTraceContainer = stackTraceContainerArea;
    }
}

