/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.SelfConfiguringComponent;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.Icon;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.Option;
import org.eclipse.kura.util.service.ServiceUtil;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.KuraExceptionHandler;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtWireGraphService;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.graph.WireComponentDefinition;
import org.eclipse.kura.wire.graph.WireComponentDefinitionService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GwtComponentServiceImpl
extends OsgiRemoteServiceServlet
implements GwtComponentService {
    private static final String DRIVER_PID = "driver.pid";
    private static final String KURA_SERVICE_PID = "kura.service.pid";
    private static final String SERVICE_FACTORY_PID = "service.factoryPid";
    private static final String KURA_UI_SERVICE_HIDE = "kura.ui.service.hide";
    private static final String PATTERN_SERVICE_PROVIDE_DRIVER = "provide interface=\"org.eclipse.kura.driver.Driver\"";
    private static final int SERVICE_WAIT_TIMEOUT = 60;
    private static final long serialVersionUID = -4176701819112753800L;

    @Override
    public List<String> findTrackedPids(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        return new ArrayList<String>(cs.getConfigurableComponentPids());
    }

    @Override
    public List<GwtConfigComponent> findFilteredComponentConfigurations(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        return this.findFilteredComponentConfigurationsInternal();
    }

    @Override
    public List<GwtConfigComponent> findComponentConfigurations(GwtXSRFToken xsrfToken, String osgiFilter) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            BundleContext context = FrameworkUtil.getBundle(GwtComponentServiceImpl.class).getBundleContext();
            Set matchingPids = Arrays.stream(context.getServiceReferences(null, osgiFilter)).map(reference -> (String)reference.getProperty(KURA_SERVICE_PID)).collect(Collectors.toSet());
            return ServiceLocator.applyToServiceOptionally(ConfigurationService.class, configurationService -> configurationService.getComponentConfigurations().stream().filter(config -> matchingPids.contains(config.getPid()))).map(this::createMetatypeOnlyGwtComponentConfigurationInternal).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (InvalidSyntaxException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<GwtConfigComponent> findFilteredComponentConfiguration(GwtXSRFToken xsrfToken, String componentPid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        return this.findFilteredComponentConfigurationInternal(componentPid);
    }

    @Override
    public List<GwtConfigComponent> findComponentConfigurations(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        return this.findComponentConfigurationsInternal();
    }

    @Override
    public List<GwtConfigComponent> findComponentConfiguration(GwtXSRFToken xsrfToken, String componentPid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        return this.findComponentConfigurationInternal(componentPid);
    }

    @Override
    public void updateComponentConfiguration(GwtXSRFToken xsrfToken, GwtConfigComponent gwtCompConfig) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        try {
            HashMap properties = new HashMap();
            ComponentConfiguration currentCC = cs.getComponentConfiguration(gwtCompConfig.getComponentId());
            Map currentConfigProp = currentCC.getConfigurationProperties();
            for (GwtConfigParameter gwtConfigParam : gwtCompConfig.getParameters()) {
                Object currentValue = currentConfigProp.get(gwtConfigParam.getId());
                boolean isReadOnly = gwtConfigParam.getMin() != null && gwtConfigParam.getMin().equals(gwtConfigParam.getMax());
                Object objValue = isReadOnly ? currentValue : GwtServerUtil.getUserDefinedObject(gwtConfigParam, currentValue);
                properties.put(gwtConfigParam.getId(), objValue);
            }
            if (currentConfigProp.get(KURA_SERVICE_PID) != null) {
                properties.put(KURA_SERVICE_PID, currentConfigProp.get(KURA_SERVICE_PID));
            }
            cs.updateConfiguration(gwtCompConfig.getComponentId(), properties);
        }
        catch (KuraException e) {
            KuraExceptionHandler.handle(e);
        }
    }

    @Override
    public void createFactoryComponent(GwtXSRFToken xsrfToken, String factoryPid, String pid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        this.internalCreateFactoryComponent(factoryPid, pid, null);
    }

    @Override
    public void createFactoryComponent(GwtXSRFToken xsrfToken, String factoryPid, String pid, GwtConfigComponent properties) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        Map<String, Object> propertiesMap = GwtServerUtil.fillPropertiesFromConfiguration(properties, null);
        this.internalCreateFactoryComponent(factoryPid, pid, propertiesMap);
    }

    private void internalCreateFactoryComponent(String factoryPid, String pid, Map<String, Object> properties) throws GwtKuraException {
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        try {
            cs.createFactoryConfiguration(factoryPid, pid, properties, true);
            String filterString = "(kura.service.pid=" + pid + ")";
            if (!ServiceUtil.waitForService((String)filterString, (long)60L, (TimeUnit)TimeUnit.SECONDS).isPresent()) {
                throw new GwtKuraException("Created component did not start in 60 seconds");
            }
        }
        catch (KuraException kuraException) {
            throw new GwtKuraException("A component with the same name already exists!");
        }
        catch (InterruptedException interruptedException) {
            throw new GwtKuraException("Interrupted while waiting for component creation");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new GwtKuraException("Invalid value for kura.service.pid: " + pid);
        }
    }

    @Override
    public void deleteFactoryConfiguration(GwtXSRFToken xsrfToken, String pid, boolean takeSnapshot) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        try {
            cs.deleteFactoryConfiguration(pid, takeSnapshot);
        }
        catch (KuraException kuraException) {
            throw new GwtKuraException("Could not delete component configuration!");
        }
    }

    @Override
    public List<String> findFactoryComponents(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> servicesToBeHidden = new ArrayList<String>();
        List<String> allWireComponents = this.findWireComponents();
        List<String> hiddenFactories = this.findFactoryHideComponents();
        this.fillServicesToHideList(servicesToBeHidden);
        result.addAll(cs.getFactoryComponentPids());
        result.removeAll(allWireComponents);
        result.removeAll(servicesToBeHidden);
        result.removeAll(hiddenFactories);
        return result;
    }

    private ComponentConfiguration waitForComponentConfiguration(ConfigurationService cs, String pid) throws InterruptedException, KuraException {
        long waitTime = 0L;
        while (waitTime < 60000L) {
            ComponentConfiguration config = cs.getComponentConfiguration(pid);
            if (config != null && config.getDefinition() != null) {
                return config;
            }
            Thread.sleep(1000L);
            waitTime += 1000L;
        }
        throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GwtConfigComponent findWireComponentConfigurationFromPid(GwtXSRFToken xsrfToken, String pid, String factoryPid, Map<String, Object> extraProps) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        GwtConfigComponent comp = null;
        try {
            ComponentConfiguration conf = cs.getComponentConfiguration(pid);
            if (conf != null) return this.createMetatypeOnlyGwtComponentConfiguration(conf);
            conf = cs.getDefaultComponentConfiguration(factoryPid);
            if (conf != null) {
                conf.getConfigurationProperties().put(SERVICE_FACTORY_PID, factoryPid);
            }
            if (conf == null) return this.createMetatypeOnlyGwtComponentConfiguration(conf);
            if (conf.getDefinition() != null) return this.createMetatypeOnlyGwtComponentConfiguration(conf);
            String temporaryName = String.valueOf(System.nanoTime());
            cs.createFactoryConfiguration(factoryPid, temporaryName, extraProps, false);
            try {
                String filterString = "(kura.service.pid=" + temporaryName + ")";
                ServiceUtil.waitForService((String)filterString, (long)60L, (TimeUnit)TimeUnit.SECONDS);
                GwtConfigComponent gwtConfigComponent = this.createMetatypeOnlyGwtComponentConfiguration(this.waitForComponentConfiguration(cs, temporaryName));
                return gwtConfigComponent;
            }
            catch (Exception ex) {
                throw new GwtKuraException(ex.getMessage());
            }
            finally {
                cs.deleteFactoryConfiguration(temporaryName, false);
            }
        }
        catch (KuraException kuraException) {
            throw new GwtKuraException("Could not retrieve component configuration!");
        }
    }

    private List<String> findWireComponents() throws GwtKuraException {
        return ServiceLocator.applyToServiceOptionally(WireComponentDefinitionService.class, wireComponentDefinitionService -> wireComponentDefinitionService.getComponentDefinitions().stream().map(WireComponentDefinition::getFactoryPid).collect(Collectors.toList()));
    }

    private List<String> findFactoryHideComponents() throws GwtKuraException {
        return ServiceLocator.applyToServiceOptionally(ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(dto -> dto.properties.containsKey("kura.ui.factory.hide")).map(dto -> dto.name).collect(Collectors.toList()));
    }

    private List<ComponentConfiguration> sortConfigurationsByName(List<ComponentConfiguration> configs) {
        Collections.sort(configs, (arg0, arg1) -> {
            int start = arg0.getPid().lastIndexOf(46);
            int substringIndex = start + 1;
            String name0 = start != -1 && substringIndex < arg0.getPid().length() ? arg0.getPid().substring(substringIndex) : arg0.getPid();
            start = arg1.getPid().lastIndexOf(46);
            substringIndex = start + 1;
            String name1 = start != -1 && substringIndex < arg1.getPid().length() ? arg1.getPid().substring(substringIndex) : arg1.getPid();
            return name0.compareTo(name1);
        });
        return configs;
    }

    private String stripPidPrefix(String pid) {
        int start = pid.lastIndexOf(46);
        if (start < 0) {
            return pid;
        }
        int begin = start + 1;
        if (begin < pid.length()) {
            return pid.substring(begin);
        }
        return pid;
    }

    private void fillServicesToHideList(List<String> hidePidsList) throws GwtKuraException {
        Collection<ServiceReference<ConfigurableComponent>> configurableComponentReferences = ServiceLocator.getInstance().getServiceReferences(ConfigurableComponent.class, null);
        Collection<ServiceReference<SelfConfiguringComponent>> selfConfiguringComponentReferences = ServiceLocator.getInstance().getServiceReferences(SelfConfiguringComponent.class, null);
        ArrayList<Object> componentReferences = new ArrayList<Object>();
        componentReferences.addAll(configurableComponentReferences);
        componentReferences.addAll(selfConfiguringComponentReferences);
        for (ServiceReference serviceReference : componentReferences) {
            Object propertyObject = serviceReference.getProperty(KURA_SERVICE_PID);
            if (serviceReference.getProperty(KURA_UI_SERVICE_HIDE) != null && propertyObject != null) {
                String servicePid = (String)propertyObject;
                hidePidsList.add(servicePid);
            }
            ServiceLocator.getInstance().ungetService(serviceReference);
        }
    }

    private List<GwtConfigComponent> findFilteredComponentConfigurationsInternal() throws GwtKuraException {
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        ArrayList<GwtConfigComponent> gwtConfigs = new ArrayList<GwtConfigComponent>();
        try {
            List configs = cs.getComponentConfigurations();
            this.sortConfigurationsByName(configs);
            for (ComponentConfiguration config : configs) {
                GwtConfigComponent gwtConfigComponent = this.createMetatypeOnlyGwtComponentConfiguration(config);
                if (gwtConfigComponent == null) continue;
                gwtConfigs.add(gwtConfigComponent);
            }
        }
        catch (Exception e) {
            KuraExceptionHandler.handle(e);
        }
        return gwtConfigs;
    }

    private List<GwtConfigComponent> findComponentConfigurationInternal(String componentPid) throws GwtKuraException {
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        ArrayList<GwtConfigComponent> gwtConfigs = new ArrayList<GwtConfigComponent>();
        try {
            ComponentConfiguration config = cs.getComponentConfiguration(componentPid);
            GwtConfigComponent gwtConfigComponent = null;
            if (config != null) {
                gwtConfigComponent = this.createMetatypeOnlyGwtComponentConfiguration(config);
            }
            GwtConfigComponent fullGwtConfigComponent = null;
            if (gwtConfigComponent != null) {
                fullGwtConfigComponent = this.addNonMetatypeProperties(gwtConfigComponent, config);
            }
            if (fullGwtConfigComponent != null) {
                gwtConfigs.add(fullGwtConfigComponent);
            }
        }
        catch (Exception e) {
            KuraExceptionHandler.handle(e);
        }
        return gwtConfigs;
    }

    private List<GwtConfigComponent> findFilteredComponentConfigurationInternal(String componentPid) throws GwtKuraException {
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        ArrayList<GwtConfigComponent> gwtConfigs = new ArrayList<GwtConfigComponent>();
        try {
            ComponentConfiguration config = cs.getComponentConfiguration(componentPid);
            if (config != null) {
                GwtConfigComponent gwtConfigComponent = this.createMetatypeOnlyGwtComponentConfiguration(config);
                gwtConfigs.add(gwtConfigComponent);
            }
        }
        catch (Exception e) {
            KuraExceptionHandler.handle(e);
        }
        return gwtConfigs;
    }

    private GwtConfigComponent addNonMetatypeProperties(GwtConfigComponent baseGwtConfig, ComponentConfiguration config) {
        GwtConfigComponent gwtConfigComponent = null;
        OCD ocd = config.getDefinition();
        if (ocd != null && baseGwtConfig != null) {
            gwtConfigComponent = new GwtConfigComponent();
            gwtConfigComponent.setComponentDescription(baseGwtConfig.getComponentDescription());
            gwtConfigComponent.setComponentId(baseGwtConfig.getComponentId());
            gwtConfigComponent.setComponentIcon(baseGwtConfig.getComponentIcon());
            gwtConfigComponent.setComponentName(baseGwtConfig.getComponentName());
            gwtConfigComponent.setProperties(baseGwtConfig.getProperties());
            ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
            gwtConfigComponent.setParameters(gwtParams);
            ArrayList<GwtConfigParameter> nonMetatypeConfigParameters = new ArrayList<GwtConfigParameter>();
            if (config.getConfigurationProperties() != null) {
                List<GwtConfigParameter> nonMetatypeProps = this.getNonMetatypeProperties(config);
                nonMetatypeConfigParameters.addAll(nonMetatypeProps);
            }
            gwtConfigComponent.setParameters(nonMetatypeConfigParameters);
        }
        return gwtConfigComponent;
    }

    private List<GwtConfigComponent> findComponentConfigurationsInternal() throws GwtKuraException {
        ConfigurationService cs = ServiceLocator.getInstance().getService(ConfigurationService.class);
        ArrayList<GwtConfigComponent> gwtConfigs = new ArrayList<GwtConfigComponent>();
        try {
            List configs = cs.getComponentConfigurations();
            this.sortConfigurationsByName(configs);
            for (ComponentConfiguration config : configs) {
                GwtConfigComponent gwtConfigComponent = this.createMetatypeOnlyGwtComponentConfiguration(config);
                gwtConfigs.add(gwtConfigComponent);
            }
        }
        catch (Exception e) {
            KuraExceptionHandler.handle(e);
        }
        return gwtConfigs;
    }

    private GwtConfigComponent createMetatypeOnlyGwtComponentConfigurationInternal(ComponentConfiguration config) {
        GwtConfigComponent gwtConfig = null;
        OCD ocd = config.getDefinition();
        if (ocd != null) {
            gwtConfig = new GwtConfigComponent();
            gwtConfig.setComponentId(config.getPid());
            Map props = config.getConfigurationProperties();
            if (props != null && props.get(DRIVER_PID) != null) {
                gwtConfig.set(DRIVER_PID, props.get(DRIVER_PID));
            }
            if (props != null && props.get(SERVICE_FACTORY_PID) != null) {
                String pid = this.stripPidPrefix(config.getPid());
                gwtConfig.setComponentName(pid);
                gwtConfig.setFactoryComponent(true);
                gwtConfig.setFactoryPid(String.valueOf(props.get(SERVICE_FACTORY_PID)));
            } else {
                gwtConfig.setComponentName(ocd.getName());
                gwtConfig.setFactoryComponent(false);
            }
            gwtConfig.setComponentDescription(ocd.getDescription());
            if (ocd.getIcon() != null && !ocd.getIcon().isEmpty()) {
                Icon icon = (Icon)ocd.getIcon().get(0);
                gwtConfig.setComponentIcon(icon.getResource());
            }
            ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
            gwtConfig.setParameters(gwtParams);
            if (config.getConfigurationProperties() != null) {
                List<GwtConfigParameter> metatypeProps = this.getADProperties(config);
                gwtParams.addAll(metatypeProps);
            }
        }
        return gwtConfig;
    }

    private GwtConfigComponent createMetatypeOnlyGwtComponentConfiguration(ComponentConfiguration config) throws GwtKuraException {
        GwtConfigComponent gwtConfig = this.createMetatypeOnlyGwtComponentConfigurationInternal(config);
        if (gwtConfig != null) {
            gwtConfig.setIsWireComponent(ServiceLocator.applyToServiceOptionally(WireHelperService.class, wireHelperService -> wireHelperService.getServicePid(gwtConfig.getComponentName()) != null));
        }
        return gwtConfig;
    }

    private List<GwtConfigParameter> getNonMetatypeProperties(ComponentConfiguration config) {
        ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
        for (Map.Entry entry : config.getConfigurationProperties().entrySet()) {
            GwtConfigParameter gwtParam = new GwtConfigParameter();
            gwtParam.setId((String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Object[]) {
                Object[] objValues = (Object[])value;
                ArrayList<String> strValues = new ArrayList<String>();
                Object[] objectArray = objValues;
                int n = objValues.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    if (v != null) {
                        strValues.add(String.valueOf(v));
                    }
                    ++n2;
                }
                gwtParam.setValues(strValues.toArray(new String[0]));
            } else if (value != null) {
                gwtParam.setValue(String.valueOf(value));
            }
            gwtParams.add(gwtParam);
        }
        return gwtParams;
    }

    private List<GwtConfigParameter> getADProperties(ComponentConfiguration config) {
        ArrayList<GwtConfigParameter> gwtParams = new ArrayList<GwtConfigParameter>();
        OCD ocd = config.getDefinition();
        for (AD ad : ocd.getAD()) {
            GwtConfigParameter gwtParam = new GwtConfigParameter();
            gwtParam.setId(ad.getId());
            gwtParam.setName(ad.getName());
            gwtParam.setDescription(ad.getDescription());
            gwtParam.setType(GwtConfigParameter.GwtConfigParameterType.valueOf(ad.getType().name()));
            gwtParam.setRequired(ad.isRequired());
            gwtParam.setCardinality(ad.getCardinality());
            if (ad.getOption() != null && !ad.getOption().isEmpty()) {
                HashMap<String, String> options = new HashMap<String, String>();
                for (Option option : ad.getOption()) {
                    options.put(option.getLabel(), option.getValue());
                }
                gwtParam.setOptions(options);
            }
            gwtParam.setMin(ad.getMin());
            gwtParam.setMax(ad.getMax());
            int cardinality = ad.getCardinality();
            Object value = config.getConfigurationProperties().get(ad.getId());
            if (value != null) {
                if (cardinality == 0 || cardinality == 1 || cardinality == -1) {
                    if (gwtParam.getType().equals((Object)GwtConfigParameter.GwtConfigParameterType.PASSWORD)) {
                        gwtParam.setValue("Placeholder");
                    } else {
                        gwtParam.setValue(String.valueOf(value));
                    }
                } else if (value instanceof Object[]) {
                    Object[] objValues = (Object[])value;
                    ArrayList<String> strValues = new ArrayList<String>();
                    Object[] objectArray = objValues;
                    int n = objValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object v = objectArray[n2];
                        if (v != null) {
                            if (gwtParam.getType().equals((Object)GwtConfigParameter.GwtConfigParameterType.PASSWORD)) {
                                strValues.add("Placeholder");
                            } else {
                                strValues.add(String.valueOf(v));
                            }
                        }
                        ++n2;
                    }
                    gwtParam.setValues(strValues.toArray(new String[0]));
                }
            }
            gwtParams.add(gwtParam);
        }
        return gwtParams;
    }

    @Override
    public boolean updateProperties(GwtXSRFToken xsrfToken, String pid, Map<String, Object> properties) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ConfigurationAdmin configAdmin = ServiceLocator.getInstance().getService(ConfigurationAdmin.class);
        WireHelperService wireHelperService = ServiceLocator.getInstance().getService(WireHelperService.class);
        try {
            String servicePid = wireHelperService.getServicePid(pid);
            Configuration conf = null;
            if (servicePid != null) {
                conf = configAdmin.getConfiguration(servicePid);
            }
            Hashtable<String, Object> props = null;
            if (conf != null) {
                props = conf.getProperties();
            }
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                ((Dictionary)props).put(key, value != null ? value : "");
            }
            if (conf != null) {
                conf.update(props);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public List<String> getDriverFactoriesList(GwtXSRFToken xsrfToken) throws GwtKuraException {
        Bundle[] bundles;
        this.checkXSRFToken(xsrfToken);
        ArrayList<String> driverFactoriesPids = new ArrayList<String>();
        Bundle[] bundleArray = bundles = FrameworkUtil.getBundle(GwtWireGraphService.class).getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Enumeration enumeration = bundle.findEntries("OSGI-INF", "*.xml", false);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    URL entry = (URL)enumeration.nextElement();
                    try {
                        Throwable throwable = null;
                        Object var11_12 = null;
                        try {
                            InputStreamReader inputStream = new InputStreamReader(entry.openConnection().getInputStream());
                            try {
                                try (BufferedReader reader = new BufferedReader(inputStream);){
                                    String line;
                                    StringBuilder contents = new StringBuilder();
                                    while ((line = reader.readLine()) != null) {
                                        contents.append(line);
                                    }
                                    if ((contents.toString().contains("provide interface=\"org.eclipse.kura.configuration.SelfConfiguringComponent\"") || contents.toString().contains("provide interface=\"org.eclipse.kura.configuration.ConfigurableComponent\"")) && contents.toString().contains("configuration-policy=\"require\"")) {
                                        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(entry.openConnection().getInputStream());
                                        NodeList nl = dom.getElementsByTagName("property");
                                        int i = 0;
                                        while (i < nl.getLength()) {
                                            String name;
                                            Node n3 = nl.item(i);
                                            if (n3 instanceof Element && "service.pid".equals(name = ((Element)n3).getAttribute("name"))) {
                                                String factoryPid = ((Element)n3).getAttribute("value");
                                                if (contents.toString().contains(PATTERN_SERVICE_PROVIDE_DRIVER)) {
                                                    driverFactoriesPids.add(factoryPid);
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                }
                                if (inputStream == null) continue;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                throw throwable;
                            }
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        throw new GwtKuraException(GwtKuraErrorCode.RESOURCE_FETCHING_FAILURE);
                    }
                }
            }
            ++n2;
        }
        return driverFactoriesPids;
    }

    @Override
    public List<String> getPidsFromTarget(GwtXSRFToken xsrfToken, String pid, String targetRef) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<String> result = new ArrayList<String>();
        BundleContext context = FrameworkUtil.getBundle(GwtWireGraphService.class).getBundleContext();
        ServiceReference scrServiceRef = context.getServiceReference(ServiceComponentRuntime.class);
        try {
            ServiceComponentRuntime scrService = (ServiceComponentRuntime)context.getService(scrServiceRef);
            Set<String> referenceInterfaces = scrService.getComponentDescriptionDTOs(new Bundle[0]).stream().map(component -> {
                ReferenceDTO[] references;
                ReferenceDTO[] referenceDTOArray = references = component.references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceDTO reference = referenceDTOArray[n2];
                    if (targetRef.equals(reference.name)) {
                        return reference.interfaceName;
                    }
                    ++n2;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            referenceInterfaces.forEach(reference -> {
                try {
                    Class<?> t = Class.forName(reference);
                    Collection<ServiceReference<?>> cloudServiceReferences = ServiceLocator.getInstance().getServiceReferences(t, null);
                    for (ServiceReference<?> cloudServiceReferenceObject : cloudServiceReferences) {
                        if (!(cloudServiceReferenceObject instanceof ServiceReference)) continue;
                        ServiceReference<?> cloudServiceReference = cloudServiceReferenceObject;
                        String cloudServicePid = (String)cloudServiceReference.getProperty(KURA_SERVICE_PID);
                        result.add(cloudServicePid);
                        ServiceLocator.getInstance().ungetService(cloudServiceReference);
                    }
                }
                catch (ClassNotFoundException | GwtKuraException exception) {}
            });
        }
        finally {
            context.ungetService(scrServiceRef);
        }
        return result;
    }
}

