/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.publisher;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.publisher.CloudPublisherOptions;
import org.eclipse.kura.internal.wire.publisher.PositionType;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;
import org.eclipse.kura.position.NmeaPosition;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public final class CloudPublisher
implements WireReceiver,
ConfigurableComponent {
    private static final Logger logger = LogManager.getLogger();
    private static final String ASSET_NAME_PROPERTY_KEY = "assetName";
    private CloudPublisherOptions cloudPublisherOptions;
    private volatile WireHelperService wireHelperService;
    private PositionService positionService;
    private WireSupport wireSupport;
    private org.eclipse.kura.cloudconnection.publisher.CloudPublisher cloudConnectionPublisher;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    public void unsetPositionService(PositionService positionService) {
        this.positionService = null;
    }

    public void setCloudPublisher(org.eclipse.kura.cloudconnection.publisher.CloudPublisher cloudPublisher) {
        this.cloudConnectionPublisher = cloudPublisher;
    }

    public void unsetCloudPublisher(org.eclipse.kura.cloudconnection.publisher.CloudPublisher cloudPublisher) {
        this.cloudConnectionPublisher = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Cloud Publisher Wire Component...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.cloudPublisherOptions = new CloudPublisherOptions(properties);
        logger.debug("Activating Cloud Publisher Wire Component... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Cloud Publisher Wire Component...");
        this.cloudPublisherOptions = new CloudPublisherOptions(properties);
        logger.debug("Updating Cloud Publisher Wire Component... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating Cloud Publisher Wire Component...");
        logger.debug("Deactivating Cloud Publisher Wire Component... Done");
    }

    public void onWireReceive(WireEnvelope wireEnvelope) {
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        if (Objects.nonNull(this.cloudConnectionPublisher)) {
            List records = wireEnvelope.getRecords();
            this.publish(records);
        }
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    private KuraPayload buildKuraPayload(WireRecord wireRecord) {
        Objects.requireNonNull(wireRecord, "Wire Record cannot be null");
        KuraPayload kuraPayload = new KuraPayload();
        kuraPayload.setTimestamp(new Date());
        if (this.cloudPublisherOptions.getPositionType() != PositionType.NONE) {
            KuraPosition kuraPosition = this.getPosition();
            kuraPayload.setPosition(kuraPosition);
        }
        for (Map.Entry entry : wireRecord.getProperties().entrySet()) {
            kuraPayload.addMetric((String)entry.getKey(), ((TypedValue)entry.getValue()).getValue());
        }
        return kuraPayload;
    }

    private KuraPosition getPosition() {
        NmeaPosition position = this.positionService.getNmeaPosition();
        KuraPosition kuraPosition = new KuraPosition();
        kuraPosition.setAltitude(position.getAltitude());
        kuraPosition.setLatitude(position.getLatitude());
        kuraPosition.setLongitude(position.getLongitude());
        if (this.cloudPublisherOptions.getPositionType() == PositionType.FULL) {
            kuraPosition.setHeading(position.getTrack());
            kuraPosition.setPrecision(position.getDOP());
            kuraPosition.setSpeed(position.getSpeed());
            kuraPosition.setSatellites(position.getNrSatellites());
        }
        return kuraPosition;
    }

    private void publish(List<WireRecord> wireRecords) {
        Objects.requireNonNull(wireRecords, "Wire Records cannot be null");
        try {
            for (WireRecord dataRecord : wireRecords) {
                Map<String, Object> properties = this.buildKuraMessageProperties(dataRecord);
                KuraPayload kuraPayload = this.buildKuraPayload(dataRecord);
                KuraMessage message = new KuraMessage(kuraPayload, properties);
                this.cloudConnectionPublisher.publish(message);
            }
        }
        catch (Exception e) {
            logger.error("Error in publishing wire records using cloud publisher..", (Throwable)e);
        }
    }

    private Map<String, Object> buildKuraMessageProperties(WireRecord wireRecord) {
        Map wireRecordProps = wireRecord.getProperties();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (wireRecordProps.containsKey(ASSET_NAME_PROPERTY_KEY)) {
            properties.put(ASSET_NAME_PROPERTY_KEY, ((TypedValue)wireRecordProps.get(ASSET_NAME_PROPERTY_KEY)).getValue());
        }
        return properties;
    }
}

