/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.asset.provider;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.annotation.Extensible;
import org.eclipse.kura.asset.Asset;
import org.eclipse.kura.asset.AssetConfiguration;
import org.eclipse.kura.asset.provider.BaseAssetExecutor;
import org.eclipse.kura.asset.provider.BaseAssetOCD;
import org.eclipse.kura.asset.provider.BaseChannelDescriptor;
import org.eclipse.kura.asset.provider.DriverState;
import org.eclipse.kura.channel.Channel;
import org.eclipse.kura.channel.ChannelFlag;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelStatus;
import org.eclipse.kura.channel.ChannelType;
import org.eclipse.kura.channel.listener.ChannelListener;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.SelfConfiguringComponent;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.driver.PreparedRead;
import org.eclipse.kura.internal.asset.provider.BaseAssetConfiguration;
import org.eclipse.kura.internal.asset.provider.DriverTrackerCustomizer;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extensible
public class BaseAsset
implements Asset,
SelfConfiguringComponent {
    protected static final String CONF_PID = "org.eclipse.kura.asset";
    private static final Logger logger = LoggerFactory.getLogger(BaseAsset.class);
    protected final Set<ChannelListenerRegistration> channelListeners = new HashSet<ChannelListenerRegistration>();
    private BaseAssetConfiguration config;
    private ComponentContext context;
    private ServiceTracker<Driver, Driver> driverServiceTracker;
    private BaseAssetExecutor executor;
    private AtomicReference<DriverState> driverState = new AtomicReference();

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.info("activating...");
        this.context = componentContext;
        this.executor = this.initBaseAssetExecutor();
        this.updated(properties);
        logger.info("activating...done");
    }

    public void updated(Map<String, Object> properties) {
        logger.info("loading asset configuration...");
        long start = System.currentTimeMillis();
        try {
            this.config = new BaseAssetConfiguration(properties);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve properties from config", (Throwable)e);
        }
        logger.info("loading asset configuration...done in {} ms", (Object)(System.currentTimeMillis() - start));
        this.reopenDriverTracker(this.config.getAssetConfiguration().getDriverPid());
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("deactivating...");
        if (this.driverServiceTracker != null) {
            this.driverServiceTracker.close();
        }
        this.executor.shutdown();
        logger.debug("deactivating...done");
    }

    private void reopenDriverTracker(String driverId) {
        Objects.requireNonNull(driverId, "Driver PID cannot be null");
        logger.debug("Attaching driver instance...");
        if (this.driverServiceTracker != null) {
            this.driverServiceTracker.close();
            this.driverServiceTracker = null;
        }
        DriverTrackerCustomizer driverTrackerCustomizer = new DriverTrackerCustomizer(this.context.getBundleContext(), this, driverId);
        this.driverServiceTracker = new ServiceTracker(this.context.getBundleContext(), Driver.class.getName(), (ServiceTrackerCustomizer)driverTrackerCustomizer);
        this.driverServiceTracker.open();
        logger.debug("Attaching driver instance...Done");
    }

    public AssetConfiguration getAssetConfiguration() {
        return this.config.getAssetConfiguration();
    }

    public void setDriver(Driver driver) {
        DriverState newState = new DriverState(driver);
        DriverState oldState = this.driverState.getAndSet(newState);
        this.executor.runConfig(() -> {
            PreparedRead preparedRead;
            if (oldState != null) {
                oldState.shutdown();
            }
            this.config.complete(this.getOCD(), this.context, this.getAssetChannelDescriptor(), newState.getDriver());
            List<ChannelRecord> readRecords = this.config.getAllReadRecords();
            if (!readRecords.isEmpty() && (preparedRead = newState.tryPrepareRead(readRecords)) != null) {
                this.onPreparedReadCreated(preparedRead);
            }
            this.updateChannelListenerRegistrations(this.channelListeners, this.config.getAssetConfiguration());
            newState.syncChannelListeners(this.channelListeners, this.config.getAssetConfiguration().getAssetChannels());
        });
    }

    public void unsetDriver() {
        DriverState oldState = this.driverState.getAndSet(null);
        if (oldState != null) {
            this.executor.runConfig(() -> {
                PreparedRead preparedRead = oldState.getPreparedRead();
                if (preparedRead != null) {
                    this.onPreparedReadReleased(preparedRead);
                }
                oldState.shutdown();
            });
        }
    }

    public Driver getDriver() {
        DriverState state = this.driverState.get();
        if (state == null) {
            return null;
        }
        return state.getDriver();
    }

    public ComponentConfiguration getConfiguration() throws KuraException {
        Map<String, Object> properties = this.config.getProperties();
        String componentName = properties.get("kura.service.pid").toString();
        Tocd ocd = this.config.getDefinition();
        if (ocd == null) {
            ocd = this.getOCD();
        }
        return new ComponentConfigurationImpl(componentName, ocd, new HashMap<String, Object>(properties));
    }

    protected String getFactoryPid() {
        return CONF_PID;
    }

    protected String getKuraServicePid() throws KuraException {
        return this.config.getKuraServicePid();
    }

    public List<ChannelRecord> readAllChannels() throws KuraException {
        logger.debug("Reading asset channels...");
        DriverState state = this.driverState.get();
        if (state == null) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Driver not attached"});
        }
        BaseAssetConfiguration conf = this.config;
        List channelRecords = BaseAsset.unwrap(this.executor.runIO(() -> {
            List<ChannelRecord> records;
            PreparedRead preparedRead = state.getPreparedRead();
            if (preparedRead != null) {
                records = preparedRead.execute();
            } else {
                records = conf.getAllReadRecords();
                if (!records.isEmpty()) {
                    state.getDriver().read(records);
                }
            }
            return records;
        }));
        logger.debug("Reading asset channels...Done");
        return channelRecords;
    }

    private void validateChannel(Channel channel, EnumSet<ChannelType> allowedTypes, String typeNotAllowedMessage) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel not available");
        }
        if (!allowedTypes.contains(channel.getType())) {
            throw new IllegalArgumentException(typeNotAllowedMessage);
        }
        if (!channel.isEnabled()) {
            throw new IllegalArgumentException("Channel is not enabled");
        }
    }

    public List<ChannelRecord> read(Set<String> channelNames) throws KuraException {
        logger.debug("Reading asset channels...");
        DriverState state = this.driverState.get();
        if (state == null) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Driver not attached"});
        }
        Map channels = this.config.getAssetConfiguration().getAssetChannels();
        ArrayList<ChannelRecord> channelRecords = new ArrayList<ChannelRecord>(channelNames.size());
        ArrayList<ChannelRecord> validRecords = new ArrayList<ChannelRecord>(channelNames.size());
        for (String name : channelNames) {
            Channel channel = (Channel)channels.get(name);
            try {
                this.validateChannel(channel, EnumSet.of(ChannelType.READ, ChannelType.READ_WRITE), "Channel type not within expected types (READ or READ_WRITE)");
            }
            catch (Exception e) {
                ChannelRecord record = ChannelRecord.createStatusRecord((String)name, (ChannelStatus)new ChannelStatus(ChannelFlag.FAILURE, e.getMessage(), e));
                record.setTimestamp(System.currentTimeMillis());
                channelRecords.add(record);
                continue;
            }
            ChannelRecord record = channel.createReadRecord();
            validRecords.add(record);
            channelRecords.add(record);
        }
        if (!validRecords.isEmpty()) {
            BaseAsset.unwrap(this.executor.runIO(() -> {
                state.getDriver().read(validRecords);
                return null;
            }));
        }
        logger.debug("Reading asset channels...Done");
        return channelRecords;
    }

    public boolean hasReadChannels() {
        return this.config.hasReadChannels();
    }

    public synchronized void registerChannelListener(String channelName, ChannelListener channelListener) throws KuraException {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(channelListener, "Asset Listener cannot be null");
        logger.debug("Registering Channel Listener for monitoring...");
        Map channels = this.config.getAssetConfiguration().getAssetChannels();
        Channel channel = (Channel)channels.get(channelName);
        if (channel == null) {
            throw new IllegalArgumentException("Channel not found");
        }
        ChannelListenerRegistration reg = new ChannelListenerRegistration(channelName, channelListener);
        if (this.channelListeners.contains(reg)) {
            return;
        }
        this.channelListeners.add(reg);
        DriverState state = this.driverState.get();
        if (state == null) {
            return;
        }
        this.executor.runConfig(() -> state.syncChannelListeners(this.channelListeners, channels));
    }

    public synchronized void unregisterChannelListener(ChannelListener channelListener) throws KuraException {
        Objects.requireNonNull(channelListener, "Asset Listener cannot be null");
        Iterator<ChannelListenerRegistration> i = this.channelListeners.iterator();
        while (i.hasNext()) {
            ChannelListenerRegistration reg = i.next();
            if (reg.listener != channelListener) continue;
            i.remove();
        }
        DriverState state = this.driverState.get();
        if (state == null) {
            return;
        }
        Map channels = this.config.getAssetConfiguration().getAssetChannels();
        this.executor.runConfig(() -> state.syncChannelListeners(this.channelListeners, channels));
    }

    protected void onPreparedReadCreated(PreparedRead preparedRead) {
    }

    protected void onPreparedReadReleased(PreparedRead preparedRead) {
    }

    public BaseAssetExecutor getBaseAssetExecutor() {
        return this.executor;
    }

    protected BaseAssetExecutor initBaseAssetExecutor() {
        ThreadPoolExecutor ioExecutor = new ThreadPoolExecutor(1, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ThreadPoolExecutor configExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        return new BaseAssetExecutor(ioExecutor, configExecutor);
    }

    public void write(List<ChannelRecord> channelRecords) throws KuraException {
        logger.debug("Writing to channels...");
        DriverState state = this.driverState.get();
        if (state == null) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Driver not attached"});
        }
        Map channels = this.config.getAssetConfiguration().getAssetChannels();
        ArrayList<ChannelRecord> validRecords = new ArrayList<ChannelRecord>(channelRecords.size());
        for (ChannelRecord channelRecord : channelRecords) {
            String channelName = channelRecord.getChannelName();
            Channel channel = (Channel)channels.get(channelName);
            try {
                this.validateChannel(channel, EnumSet.of(ChannelType.WRITE, ChannelType.READ_WRITE), "Channel type not within expected types (WRITE or READ_WRITE)");
            }
            catch (Exception e) {
                channelRecord.setChannelStatus(new ChannelStatus(ChannelFlag.FAILURE, e.getMessage(), e));
                channelRecord.setTimestamp(System.currentTimeMillis());
                continue;
            }
            channelRecord.setChannelConfig(channel.getConfiguration());
            validRecords.add(channelRecord);
        }
        if (!validRecords.isEmpty()) {
            BaseAsset.unwrap(this.executor.runIO(() -> {
                state.getDriver().write(validRecords);
                return null;
            }));
        }
        logger.debug("Writing to channels...Done");
    }

    private static <T> T unwrap(CompletableFuture<T> future) throws KuraException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new KuraException(KuraErrorCode.CONNECTION_FAILED, cause, new Object[]{cause.getMessage()});
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.CONNECTION_FAILED, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    protected boolean isChannelListenerValid(ChannelListenerRegistration reg, Channel channel) {
        return channel != null;
    }

    protected void updateChannelListenerRegistrations(Set<ChannelListenerRegistration> listeners, AssetConfiguration config) {
        Map channels = config.getAssetChannels();
        Iterator<ChannelListenerRegistration> i = listeners.iterator();
        while (i.hasNext()) {
            ChannelListenerRegistration reg = i.next();
            if (this.isChannelListenerValid(reg, (Channel)channels.get(reg.getChannelName()))) continue;
            i.remove();
        }
    }

    protected List<Tad> getAssetChannelDescriptor() {
        return (List)BaseChannelDescriptor.get().getDescriptor();
    }

    protected Tocd getOCD() {
        return new BaseAssetOCD();
    }

    public String toString() {
        return "BaseAsset [Asset Configuration=" + this.config + "]";
    }

    protected static class ChannelListenerRegistration {
        private final String channelName;
        private final ChannelListener listener;

        public ChannelListenerRegistration(String channelName, ChannelListener listener) {
            this.channelName = channelName;
            this.listener = listener;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public ChannelListener getChannelListener() {
            return this.listener;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.channelName == null ? 0 : this.channelName.hashCode());
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChannelListenerRegistration other = (ChannelListenerRegistration)obj;
            if (this.channelName == null ? other.channelName != null : !this.channelName.equals(other.channelName)) {
                return false;
            }
            if (this.listener == null && other.listener != null) {
                return false;
            }
            return this.listener == other.listener;
        }
    }
}

