/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.util;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.internal.ble.util.BluetoothSafeProcess;

public class BluetoothProcessUtil {
    private static final Logger logger = LogManager.getLogger(BluetoothProcessUtil.class);
    private static final ExecutorService processExecutor = Executors.newSingleThreadExecutor();

    public static BluetoothSafeProcess exec(String command) throws IOException {
        StringTokenizer st = new StringTokenizer(command);
        int count = st.countTokens();
        String[] cmdArray = new String[count];
        int i = 0;
        while (i < count) {
            cmdArray[i] = st.nextToken();
            ++i;
        }
        return BluetoothProcessUtil.exec(cmdArray);
    }

    public static BluetoothSafeProcess exec(String[] cmdarray) throws IOException {
        Future<BluetoothSafeProcess> futureSafeProcess = processExecutor.submit(() -> {
            Thread.currentThread().setName("SafeProcessExecutor");
            BluetoothSafeProcess safeProcess = new BluetoothSafeProcess();
            safeProcess.exec(cmdarray);
            return safeProcess;
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    public static void destroy(BluetoothSafeProcess proc) {
        proc.destroy();
    }
}

