/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.db;

import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DbHelper {
    private static final Logger logger = LoggerFactory.getLogger(H2DbHelper.class);
    private static final String H2_DB_SERVICE_FACTORY_PID = "org.eclipse.kura.core.db.H2DbService";
    private ConfigurationService configurationService;

    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void unsetConfigurationService(ConfigurationService configurationService) {
        this.configurationService = null;
    }

    private void startDefaultDbServiceInstance() {
        try {
            if (this.configurationService.getComponentConfiguration("org.eclipse.kura.db.H2DbService") == null) {
                logger.info("Default H2DbService instance configuration not found, creating new instance...");
                this.configurationService.createFactoryConfiguration(H2_DB_SERVICE_FACTORY_PID, "org.eclipse.kura.db.H2DbService", null, true);
            } else {
                logger.info("Default H2DbService instance configuration found");
            }
        }
        catch (KuraException e) {
            logger.error("Failed to retrieve or create default H2DbService factory configuration", (Throwable)e);
        }
    }

    private void stopDefaultDbServiceInstance() {
        try {
            if (this.configurationService.getComponentConfiguration("org.eclipse.kura.db.H2DbService") != null) {
                this.configurationService.deleteFactoryConfiguration("org.eclipse.kura.db.H2DbService", false);
            }
        }
        catch (KuraException e) {
            logger.error("Failed to remove default H2DbService instance", (Throwable)e);
        }
    }

    protected void activate() {
        logger.info("activating...");
        this.startDefaultDbServiceInstance();
        logger.info("activating...done");
    }

    protected void deactivate() {
        this.stopDefaultDbServiceInstance();
    }
}

