/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.asset;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.channel.Channel;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class AssetConfiguration {
    private final Map<String, Channel> assetChannels;
    private String assetDescription;
    private final String driverPid;

    public AssetConfiguration(String description, String driverPid, Map<String, Channel> channels) {
        Objects.requireNonNull(description, "Asset description cannot be null");
        Objects.requireNonNull(driverPid, "Asset driver PID cannot be null");
        Objects.requireNonNull(channels, "Asset channel configurations cannot be null");
        this.assetDescription = description;
        this.driverPid = driverPid;
        this.assetChannels = Collections.unmodifiableMap(channels);
    }

    public Map<String, Channel> getAssetChannels() {
        return this.assetChannels;
    }

    public String getAssetDescription() {
        return this.assetDescription;
    }

    public String getDriverPid() {
        return this.driverPid;
    }

    public void setAssetDescription(String description) {
        Objects.requireNonNull(description, "Asset description cannot be null");
        this.assetDescription = description;
    }

    public String toString() {
        return "AssetConfiguration [channels=" + this.assetChannels + ", description=" + this.assetDescription + ", driverPid=" + this.driverPid + "]";
    }
}

