/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.drivers.assets;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.cell.client.TextInputCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.DefaultHeaderOrFooterBuilder;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.HeaderBuilder;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetModel;
import org.eclipse.kura.web.client.ui.drivers.assets.DriversAndAssetsRPC;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.AssetConstants;
import org.eclipse.kura.web.shared.model.GwtChannelRecord;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.gwt.CellTable;

public class AssetDataUi
extends Composite {
    private static AssetDataUiBinder uiBinder = (AssetDataUiBinder)GWT.create(AssetDataUiBinder.class);
    protected static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private static final int MAXIMUM_PAGE_SIZE = 5;
    private final ListDataProvider<AssetModel.ChannelModel> channelsDataProvider = new ListDataProvider();
    private final SingleSelectionModel<AssetModel.ChannelModel> selectionModel = new SingleSelectionModel();
    private AssetModel model;
    private final Map<String, GwtChannelRecord> channelValues = new HashMap<String, GwtChannelRecord>();
    private final Set<String> modifiedWriteChannels = new HashSet<String>();
    private final TextInputCell valuesCell = new TextInputCell();
    @UiField
    PanelBody configurationPanelBody;
    @UiField
    Button applyDataChanges;
    @UiField
    Button refreshData;
    @UiField
    CellTable<AssetModel.ChannelModel> assetDataTable;
    @UiField
    SimplePager channelPager;
    @UiField
    AlertDialog alertDialog;

    public AssetDataUi(AssetModel model) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.channelPager.setPageSize(5);
        this.channelPager.setDisplay(this.assetDataTable);
        this.assetDataTable.setSelectionModel(this.selectionModel);
        this.channelsDataProvider.addDataDisplay(this.assetDataTable);
        this.model = model;
        this.initButtons();
        this.initTable();
    }

    public void setModel(AssetModel model) {
        this.model = model;
    }

    private void initButtons() {
        this.applyDataChanges.addClickHandler(event -> this.write());
        this.refreshData.addClickHandler(event -> this.renderForm());
        this.applyDataChanges.setEnabled(false);
    }

    private void initTable() {
        this.assetDataTable.setHeaderBuilder((HeaderBuilder)new DefaultHeaderOrFooterBuilder(this.assetDataTable, false));
        this.assetDataTable.addColumn((Column)new StaticColumn(AssetConstants.NAME.value()), (Header)new TextHeader(MSGS.wiresChannelName()));
        this.assetDataTable.addColumn((Column)new StaticColumn(AssetConstants.TYPE.value()), (Header)new TextHeader(MSGS.wiresChannelOperation()));
        this.assetDataTable.addColumn((Column)new StaticColumn(AssetConstants.VALUE_TYPE.value()), (Header)new TextHeader(MSGS.wiresChannelValueType()));
        Column<AssetModel.ChannelModel, String> statusColumn = new Column<AssetModel.ChannelModel, String>((Cell)new StatusCell()){

            public void onBrowserEvent(Cell.Context context, Element elem, AssetModel.ChannelModel object, NativeEvent event) {
                if (AssetDataUi.this.getChannelStatus(object) == ChannelStatus.FAILURE) {
                    GwtChannelRecord record = (GwtChannelRecord)AssetDataUi.this.channelValues.get(object.getChannelName());
                    AssetDataUi.showFailureDetails(record);
                }
            }

            public String getValue(AssetModel.ChannelModel object) {
                return AssetDataUi.this.getChannelStatus(object).getLabel();
            }

            public String getCellStyleNames(Cell.Context context, AssetModel.ChannelModel object) {
                return AssetDataUi.this.getChannelStatus(object).getCellStyle();
            }

            public void render(Cell.Context context, AssetModel.ChannelModel object, SafeHtmlBuilder sb) {
                ChannelStatus status = AssetDataUi.this.getChannelStatus(object);
                sb.append((SafeHtml & Serializable)() -> "<i class=\"fa assets-status-icon " + status.getIconStyle() + "\"></i><span>" + SafeHtmlUtils.htmlEscape((String)this.getValue(object)) + "</span>");
            }
        };
        this.assetDataTable.addColumn((Column)statusColumn, (Header)new TextHeader(MSGS.wiresChannelStatus()));
        Column<AssetModel.ChannelModel, String> valueColumn = new Column<AssetModel.ChannelModel, String>((Cell)this.valuesCell){

            public void onBrowserEvent(Cell.Context context, Element elem, AssetModel.ChannelModel object, NativeEvent event) {
                if (!"READ".equals(object.getValue(AssetConstants.TYPE.value()))) {
                    super.onBrowserEvent(context, elem, (Object)object, event);
                }
            }

            public String getCellStyleNames(Cell.Context context, AssetModel.ChannelModel object) {
                if (AssetDataUi.this.getChannelStatus(object) == ChannelStatus.FAILURE) {
                    return "cell-readonly";
                }
                return null;
            }

            public String getValue(AssetModel.ChannelModel object) {
                if (AssetDataUi.this.getChannelStatus(object) == ChannelStatus.SUCCESS) {
                    GwtChannelRecord result = (GwtChannelRecord)AssetDataUi.this.channelValues.get(object.getChannelName());
                    return result.getValue();
                }
                return "Not available";
            }

            public void render(Cell.Context context, AssetModel.ChannelModel object, SafeHtmlBuilder sb) {
                if ("READ".equals(object.getValue(AssetConstants.TYPE.value()))) {
                    sb.appendEscaped(this.getValue(object));
                    return;
                }
                if (!AssetDataUi.this.isDirty(object.getChannelName())) {
                    AssetDataUi.this.valuesCell.clearViewData(context.getKey());
                }
                super.render(context, (Object)object, sb);
            }
        };
        valueColumn.setFieldUpdater((index, object, value) -> {
            String channelName = object.getChannelName();
            GwtChannelRecord result = this.createWriteRecord((AssetModel.ChannelModel)object);
            result.setValue((String)value);
            this.channelValues.put(channelName, result);
            this.markAsDirty(channelName);
            this.assetDataTable.redraw();
        });
        this.assetDataTable.addColumn((Column)valueColumn, (Header)new TextHeader(MSGS.devicePropValue()));
    }

    private static void showFailureDetails(GwtChannelRecord record) {
        record.setUnescaped(true);
        String reason = record.getExceptionMessage();
        record.setUnescaped(false);
        if (reason == null || reason.trim().isEmpty()) {
            reason = "unknown";
        }
        FailureHandler.showErrorMessage("Channel failure details", "Reason: " + reason, record.getExceptionStackTrace());
    }

    private GwtChannelRecord createWriteRecord(AssetModel.ChannelModel channel) {
        GwtChannelRecord result = new GwtChannelRecord();
        result.setUnescaped(true);
        result.setName(channel.getChannelName());
        result.setValueType(channel.getValue(AssetConstants.VALUE_TYPE.value()));
        return result;
    }

    private void write() {
        if (!this.isDirty()) {
            return;
        }
        ArrayList<GwtChannelRecord> writeRecords = new ArrayList<GwtChannelRecord>();
        for (String channelName : this.modifiedWriteChannels) {
            GwtChannelRecord record = this.channelValues.get(channelName);
            if (record == null) continue;
            writeRecords.add(record);
        }
        if (writeRecords.isEmpty()) {
            return;
        }
        this.alertDialog.show(MSGS.driversAssetsWriteConfirm(this.model.getAssetPid()), () -> DriversAndAssetsRPC.write(this.model.getAssetPid(), writeRecords, result -> {
            List<GwtChannelRecord> records = result.getRecords();
            if (records != null) {
                this.setDirty(false);
                for (GwtChannelRecord channelRecord : records) {
                    channelRecord.setUnescaped(true);
                    this.channelValues.put(channelRecord.getName(), channelRecord);
                }
                this.channelsDataProvider.refresh();
                this.assetDataTable.redraw();
            } else {
                FailureHandler.showErrorMessage("Channel operation failed", result.getExceptionMessage(), result.getStackTrace());
            }
        }));
    }

    private boolean isDirty(String channelName) {
        return this.modifiedWriteChannels.contains(channelName);
    }

    private void markAsDirty(String channelName) {
        this.modifiedWriteChannels.add(channelName);
        this.applyDataChanges.setEnabled(true);
    }

    public void setDirty(boolean flag) {
        if (!flag) {
            this.modifiedWriteChannels.clear();
        }
        if (this.isDirty()) {
            this.applyDataChanges.setEnabled(true);
        }
    }

    public boolean isDirty() {
        return !this.modifiedWriteChannels.isEmpty();
    }

    public void renderForm() {
        this.setDirty(false);
        this.channelValues.clear();
        this.applyDataChanges.setEnabled(false);
        this.channelsDataProvider.getList().clear();
        this.channelsDataProvider.refresh();
        EntryClassUi.showWaitModal();
        DriversAndAssetsRPC.readAllChannels(this.model.getAssetPid(), result -> {
            List<GwtChannelRecord> records = result.getRecords();
            if (records != null) {
                for (GwtChannelRecord record : records) {
                    record.setUnescaped(true);
                    this.channelValues.put(record.getName(), record);
                }
                this.channelsDataProvider.getList().addAll(this.model.getChannels());
                this.channelsDataProvider.refresh();
                int size = this.channelsDataProvider.getList().size();
                this.assetDataTable.setVisibleRange(0, size);
                this.assetDataTable.redraw();
            } else {
                FailureHandler.showErrorMessage("Channel operation failed", result.getExceptionMessage(), result.getStackTrace());
            }
        });
    }

    private ChannelStatus getChannelStatus(AssetModel.ChannelModel model) {
        String channelName = model.getChannelName();
        GwtChannelRecord record = this.channelValues.get(model.getChannelName());
        if ("false".equals(model.getValue(AssetConstants.ENABLED.value()))) {
            return ChannelStatus.DISABLED;
        }
        if (this.modifiedWriteChannels.contains(channelName)) {
            return ChannelStatus.DIRTY;
        }
        if (record == null) {
            return ChannelStatus.UNKNOWN;
        }
        if (record.getValue() == null) {
            return ChannelStatus.FAILURE;
        }
        return ChannelStatus.SUCCESS;
    }

    static interface AssetDataUiBinder
    extends UiBinder<Widget, AssetDataUi> {
    }

    private static enum ChannelStatus {
        UNKNOWN("Unknown", "fa-times text-danger", "text-danger"),
        SUCCESS("Success", "fa-check text-success", "text-success"),
        FAILURE("Failure - click for details", "fa-times text-danger", "text-danger cell-clickable"),
        DIRTY("Modified", "fa-pencil", ""),
        DISABLED("Disabled", "", "");

        private String label;
        private String iconStyle;
        private String cellStyle;

        private ChannelStatus(String label, String iconStyle, String cellStyle) {
            this.label = label;
            this.iconStyle = iconStyle;
            this.cellStyle = cellStyle;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIconStyle() {
            return this.iconStyle;
        }

        public String getCellStyle() {
            return this.cellStyle;
        }
    }

    private static final class StaticColumn
    extends Column<AssetModel.ChannelModel, String> {
        private final String key;

        public StaticColumn(String key) {
            super((Cell)new TextCell());
            this.key = key;
        }

        public String getValue(AssetModel.ChannelModel object) {
            return object.getValue(this.key);
        }
    }

    private static final class StatusCell
    extends TextCell {
        private StatusCell() {
        }

        public Set<String> getConsumedEvents() {
            HashSet<String> set = new HashSet<String>();
            set.add("click");
            return set;
        }
    }
}

