/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.apache.felix.deploymentadmin.spi.GetStorageAreaCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;

public class SnapshotCommand
extends Command {
    private final GetStorageAreaCommand m_getStorageAreaCommand;

    public SnapshotCommand(GetStorageAreaCommand getStorageAreaCommand) {
        this.m_getStorageAreaCommand = getStorageAreaCommand;
    }

    public void execute(DeploymentSessionImpl session) throws DeploymentException {
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        BundleInfo[] infos = target.getBundleInfos();
        Map storageAreas = this.m_getStorageAreaCommand.getStorageAreas();
        for (int i = 0; i < infos.length; ++i) {
            if (this.isCancelled()) {
                throw new DeploymentException(401);
            }
            Bundle bundle = target.getBundle(infos[i].getSymbolicName());
            if (bundle == null) continue;
            File root = (File)storageAreas.get(bundle.getSymbolicName());
            if (root != null) {
                File snapshot = context.getDataFile("snapshots");
                snapshot.mkdirs();
                snapshot = new File(snapshot, infos[i].getSymbolicName());
                try {
                    snapshot.createNewFile();
                    this.store(root, snapshot);
                    this.addRollback(new RestoreSnapshotRunnable(session, snapshot, root));
                    this.addCommit(new DeleteSnapshotRunnable(session, snapshot));
                }
                catch (IOException e) {
                    snapshot.delete();
                }
                continue;
            }
            session.getLog().log(2, "Could not retrieve storage area of bundle '" + bundle.getSymbolicName() + "', skipping it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(File source, File target) throws IOException {
        ZipOutputStream output = null;
        try {
            File[] children = source.listFiles();
            output = new ZipOutputStream(new FileOutputStream(target));
            for (int i = 0; i < children.length; ++i) {
                this.storeRecursive(source, new File(children[i].getName()), output);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeRecursive(File current, File path, ZipOutputStream output) throws IOException {
        output.putNextEntry(new ZipEntry(path.getPath()));
        if (current.isDirectory()) {
            output.closeEntry();
            File[] childs = current.listFiles();
            for (int i = 0; i < childs.length; ++i) {
                this.storeRecursive(childs[i], new File(path, childs[i].getName()), output);
            }
        } else {
            FileInputStream input = null;
            try {
                input = new FileInputStream(current);
                byte[] buffer = new byte[4096];
                int i = ((InputStream)input).read(buffer);
                while (i != -1) {
                    output.write(buffer, 0, i);
                    i = ((InputStream)input).read(buffer);
                }
                output.closeEntry();
            }
            finally {
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    private static class RestoreSnapshotRunnable
    implements Runnable {
        private final DeploymentSessionImpl m_session;
        private final File m_snapshot;
        private final File m_root;

        private RestoreSnapshotRunnable(DeploymentSessionImpl session, File snapshot, File root) {
            this.m_session = session;
            this.m_snapshot = snapshot;
            this.m_root = root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.delete(this.m_root, false);
                this.unpack(this.m_snapshot, this.m_root);
            }
            catch (Exception ex) {
                this.m_session.getLog().log(2, "Failed to restore snapshot!", (Throwable)ex);
            }
            finally {
                this.m_snapshot.delete();
            }
        }

        private void delete(File root, boolean deleteRoot) {
            if (root.isDirectory()) {
                File[] childs = root.listFiles();
                for (int i = 0; i < childs.length; ++i) {
                    this.delete(childs[i], true);
                }
            }
            if (deleteRoot) {
                root.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unpack(File source, File target) throws IOException {
            ZipInputStream input = null;
            try {
                input = new ZipInputStream(new FileInputStream(source));
                ZipEntry entry = input.getNextEntry();
                while (entry != null) {
                    if (entry.isDirectory()) {
                        new File(target, entry.getName()).mkdirs();
                    } else {
                        FileOutputStream output = null;
                        try {
                            output = new FileOutputStream(target);
                            byte[] buffer = new byte[4096];
                            int i = input.read(buffer);
                            while (i > -1) {
                                ((OutputStream)output).write(buffer, 0, i);
                                i = input.read(buffer);
                            }
                        }
                        finally {
                            if (output != null) {
                                try {
                                    ((OutputStream)output).close();
                                }
                                catch (Exception ex) {}
                            }
                        }
                    }
                    input.closeEntry();
                    entry = input.getNextEntry();
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    private static class DeleteSnapshotRunnable
    implements Runnable {
        private final DeploymentSessionImpl m_session;
        private final File m_snapshot;

        private DeleteSnapshotRunnable(DeploymentSessionImpl session, File snapshot) {
            this.m_session = session;
            this.m_snapshot = snapshot;
        }

        public void run() {
            if (!this.m_snapshot.delete()) {
                this.m_session.getLog().log(2, "Failed to delete snapshot in " + this.m_snapshot + "!");
            }
        }
    }
}

