/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AbstractServicesUi;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtComponentServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.FieldSet;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.ModalHeader;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;

public class SslTabUi
extends AbstractServicesUi {
    private static final SslTabUiUiBinder uiBinder = (SslTabUiUiBinder)GWT.create(SslTabUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtComponentServiceAsync gwtComponentService = (GwtComponentServiceAsync)GWT.create(GwtComponentService.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private boolean dirty;
    private boolean initialized;
    private GwtConfigComponent originalConfig;
    private Modal modal;
    @UiField
    Button apply;
    @UiField
    Button reset;
    @UiField
    FieldSet fields;
    @UiField
    Form form;
    @UiField
    Modal incompleteFieldsModal;
    @UiField
    Alert incompleteFields;
    @UiField
    Text incompleteFieldsText;

    public SslTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initialized = false;
        this.apply.setText(MSGS.apply());
        this.apply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SslTabUi.this.apply();
            }
        });
        this.reset.setText(MSGS.reset());
        this.reset.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SslTabUi.this.reset();
            }
        });
    }

    public void load() {
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                SslTabUi.this.gwtComponentService.findFilteredComponentConfiguration(token, "org.eclipse.kura.ssl.SslManagerService", new AsyncCallback<List<GwtConfigComponent>>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught);
                    }

                    public void onSuccess(List<GwtConfigComponent> result) {
                        for (GwtConfigComponent config : result) {
                            SslTabUi.this.originalConfig = config;
                            SslTabUi.this.restoreConfiguration(SslTabUi.this.originalConfig);
                            (this).SslTabUi.this.fields.clear();
                            SslTabUi.this.renderForm();
                            SslTabUi.this.initInvalidDataModal();
                            SslTabUi.this.setDirty(false);
                            (this).SslTabUi.this.apply.setEnabled(false);
                            (this).SslTabUi.this.reset.setEnabled(false);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
        if (this.dirty && this.initialized) {
            this.apply.setEnabled(true);
            this.reset.setEnabled(true);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    private void apply() {
        if (this.isValid()) {
            if (this.isDirty()) {
                this.modal = new Modal();
                ModalHeader header = new ModalHeader();
                header.setTitle(MSGS.confirm());
                this.modal.add((Widget)header);
                ModalBody body = new ModalBody();
                body.add((Widget)new Span(MSGS.deviceConfigConfirmation(this.configurableComponent.getComponentName())));
                this.modal.add((Widget)body);
                ModalFooter footer = new ModalFooter();
                ButtonGroup group = new ButtonGroup();
                Button no = new Button();
                no.setText(MSGS.noButton());
                no.addStyleName("fa fa-times");
                no.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        SslTabUi.this.modal.hide();
                    }
                });
                group.add((Widget)no);
                Button yes = new Button();
                yes.setText(MSGS.yesButton());
                yes.addStyleName("fa fa-check");
                yes.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        EntryClassUi.showWaitModal();
                        try {
                            SslTabUi.this.getUpdatedConfiguration();
                        }
                        catch (Exception ex) {
                            EntryClassUi.hideWaitModal();
                            FailureHandler.handle(ex);
                            return;
                        }
                        SslTabUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                            public void onFailure(Throwable ex) {
                                EntryClassUi.hideWaitModal();
                                FailureHandler.handle(ex);
                            }

                            public void onSuccess(GwtXSRFToken token) {
                                SslTabUi.this.gwtComponentService.updateComponentConfiguration(token, SslTabUi.this.configurableComponent, new AsyncCallback<Void>(){

                                    public void onFailure(Throwable caught) {
                                        EntryClassUi.hideWaitModal();
                                        FailureHandler.handle(caught);
                                        errorLogger.log(Level.SEVERE, caught.getLocalizedMessage() != null ? caught.getLocalizedMessage() : caught.getClass().getName(), caught);
                                    }

                                    public void onSuccess(Void result) {
                                        SslTabUi.this.modal.hide();
                                        logger.info(String.valueOf(MSGS.info()) + ": " + MSGS.deviceConfigApplied());
                                        ((this).this).SslTabUi.this.apply.setEnabled(false);
                                        ((this).this).SslTabUi.this.reset.setEnabled(false);
                                        SslTabUi.this.setDirty(false);
                                        SslTabUi.this.originalConfig = SslTabUi.this.configurableComponent;
                                        EntryClassUi.hideWaitModal();
                                    }
                                });
                            }
                        });
                    }
                });
                group.add((Widget)yes);
                footer.add((Widget)group);
                this.modal.add((Widget)footer);
                this.modal.show();
                no.setFocus(true);
            }
        } else {
            errorLogger.log(Level.SEVERE, "Device configuration error!");
            this.incompleteFieldsModal.show();
        }
    }

    @Override
    public void reset() {
        if (this.isDirty()) {
            this.modal = new Modal();
            ModalHeader header = new ModalHeader();
            header.setTitle(MSGS.confirm());
            this.modal.add((Widget)header);
            ModalBody body = new ModalBody();
            body.add((Widget)new Span(MSGS.deviceConfigDirty()));
            this.modal.add((Widget)body);
            ModalFooter footer = new ModalFooter();
            ButtonGroup group = new ButtonGroup();
            Button no = new Button();
            no.setText(MSGS.noButton());
            no.addStyleName("fa fa-times");
            no.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SslTabUi.this.modal.hide();
                }
            });
            group.add((Widget)no);
            Button yes = new Button();
            yes.setText(MSGS.yesButton());
            yes.addStyleName("fa fa-check");
            yes.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SslTabUi.this.modal.hide();
                    SslTabUi.this.restoreConfiguration(SslTabUi.this.originalConfig);
                    SslTabUi.this.renderForm();
                    SslTabUi.this.apply.setEnabled(false);
                    SslTabUi.this.reset.setEnabled(false);
                    SslTabUi.this.setDirty(false);
                }
            });
            group.add((Widget)yes);
            footer.add((Widget)group);
            this.modal.add((Widget)footer);
            this.modal.show();
            no.setFocus(true);
        }
    }

    @Override
    public void renderForm() {
        this.fields.clear();
        for (GwtConfigParameter param : this.configurableComponent.getParameters()) {
            if (param.getCardinality() == 0 || param.getCardinality() == 1 || param.getCardinality() == -1) {
                FormGroup formGroup = new FormGroup();
                this.renderConfigParameter(param, true, formGroup);
                continue;
            }
            this.renderMultiFieldConfigParameter(param);
        }
        this.initialized = true;
    }

    @Override
    protected void renderTextField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderTextField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderPasswordField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderPasswordField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderBooleanField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderBooleanField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderChoiceField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderChoiceField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    private void initInvalidDataModal() {
        this.incompleteFieldsModal.setTitle(MSGS.warning());
        this.incompleteFieldsText.setText(MSGS.formWithErrorsOrIncomplete());
    }

    private GwtConfigComponent getUpdatedConfiguration() {
        for (Widget w : this.fields) {
            if (!(w instanceof FormGroup)) continue;
            FormGroup fg = (FormGroup)w;
            this.fillUpdatedConfiguration(fg);
        }
        return this.configurableComponent;
    }

    static interface SslTabUiUiBinder
    extends UiBinder<Widget, SslTabUi> {
    }
}

