/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net.modem;

import org.eclipse.kura.core.net.NetInterfaceAddressImpl;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.modem.ModemConnectionStatus;
import org.eclipse.kura.net.modem.ModemConnectionType;
import org.eclipse.kura.net.modem.ModemInterfaceAddress;

public class ModemInterfaceAddressImpl
extends NetInterfaceAddressImpl
implements ModemInterfaceAddress {
    private int m_signalStrength;
    private boolean m_isRoaming;
    private ModemConnectionStatus m_connectionStatus;
    private long m_bytesTransmitted;
    private long m_bytesReceived;
    private ModemConnectionType m_connectionType;

    public ModemInterfaceAddressImpl() {
        this.m_connectionType = ModemConnectionType.PPP;
    }

    public ModemInterfaceAddressImpl(ModemInterfaceAddress other) {
        super((NetInterfaceAddress)other);
        this.m_signalStrength = other.getSignalStrength();
        this.m_isRoaming = other.isRoaming();
        this.m_connectionStatus = other.getConnectionStatus();
        this.m_bytesTransmitted = other.getBytesTransmitted();
        this.m_bytesReceived = other.getBytesReceived();
        this.m_connectionType = other.getConnectionType();
    }

    public int getSignalStrength() {
        return this.m_signalStrength;
    }

    public void setSignalStrength(int signalStrength) {
        this.m_signalStrength = signalStrength;
    }

    public boolean isRoaming() {
        return this.m_isRoaming;
    }

    public void setIsRoaming(boolean isRoaming) {
        this.m_isRoaming = isRoaming;
    }

    public ModemConnectionStatus getConnectionStatus() {
        return this.m_connectionStatus;
    }

    public void setConnectionStatus(ModemConnectionStatus connectionStatus) {
        this.m_connectionStatus = connectionStatus;
    }

    public long getBytesTransmitted() {
        return this.m_bytesTransmitted;
    }

    public void setBytesTransmitted(long bytesTransmitted) {
        this.m_bytesTransmitted = bytesTransmitted;
    }

    public long getBytesReceived() {
        return this.m_bytesReceived;
    }

    public void setBytesReceived(long bytesReceived) {
        this.m_bytesReceived = bytesReceived;
    }

    public ModemConnectionType getConnectionType() {
        return this.m_connectionType;
    }

    public void setConnectionType(ModemConnectionType connectionType) {
        this.m_connectionType = connectionType;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.m_bytesReceived ^ this.m_bytesReceived >>> 32);
        result = 31 * result + (int)(this.m_bytesTransmitted ^ this.m_bytesTransmitted >>> 32);
        result = 31 * result + (this.m_connectionStatus == null ? 0 : this.m_connectionStatus.hashCode());
        result = 31 * result + (this.m_connectionType == null ? 0 : this.m_connectionType.hashCode());
        result = 31 * result + (this.m_isRoaming ? 1231 : 1237);
        result = 31 * result + this.m_signalStrength;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModemInterfaceAddressImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModemInterfaceAddressImpl other = (ModemInterfaceAddressImpl)obj;
        if (this.m_bytesReceived != other.m_bytesReceived) {
            return false;
        }
        if (this.m_bytesTransmitted != other.m_bytesTransmitted) {
            return false;
        }
        if (this.m_connectionStatus != other.m_connectionStatus) {
            return false;
        }
        if (this.m_connectionType != other.m_connectionType) {
            return false;
        }
        if (this.m_isRoaming != other.m_isRoaming) {
            return false;
        }
        return this.m_signalStrength == other.m_signalStrength;
    }
}

