/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.kura.web.server.servlet.FileServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UploadRequest
extends ServletFileUpload {
    private static Logger logger = LoggerFactory.getLogger(UploadRequest.class);
    Map<String, String> formFields;
    List<FileItem> fileItems;

    public UploadRequest(DiskFileItemFactory diskFileItemFactory) {
        super((FileItemFactory)diskFileItemFactory);
        this.setSizeMax(FileServlet.getFileUploadSizeMax());
        this.formFields = new HashMap<String, String>();
        this.fileItems = new ArrayList<FileItem>();
    }

    public void parse(HttpServletRequest req) throws FileUploadException {
        logger.debug("upload.getFileSizeMax(): {}", (Object)this.getFileSizeMax());
        logger.debug("upload.getSizeMax(): {}", (Object)this.getSizeMax());
        List items = null;
        items = this.parseRequest(req);
        for (FileItem item : items) {
            if (item.isFormField()) {
                String name = item.getFieldName();
                String value = item.getString();
                logger.debug("Form field item name: {}, value: {}", (Object)name, (Object)value);
                this.formFields.put(name, value);
                continue;
            }
            String fieldName = item.getFieldName();
            String fileName = item.getName();
            String contentType = item.getContentType();
            boolean isInMemory = item.isInMemory();
            long sizeInBytes = item.getSize();
            logger.debug("File upload item name: {}, fileName: {}, contentType: {}, isInMemory: {}, size: {}", new Object[]{fieldName, fileName, contentType, isInMemory, sizeInBytes});
            this.fileItems.add(item);
        }
    }

    public Map<String, String> getFormFields() {
        return this.formFields;
    }

    public List<FileItem> getFileItems() {
        return this.fileItems;
    }
}

