/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.certificates;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraIOException;
import org.eclipse.kura.certificate.CertificatesService;
import org.eclipse.kura.certificate.KuraCertificateEntry;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.message.KuraApplicationTopic;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.security.keystore.KeystoreService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesManager
implements CertificatesService {
    private static final Logger logger = LoggerFactory.getLogger(CertificatesManager.class);
    public static final String APP_ID = "org.eclipse.kura.core.certificates.CertificatesManager";
    private static final String RESOURCE_CERTIFICATE_DM = "dm";
    private static final String RESOURCE_CERTIFICATE_LOGIN = "login";
    private static final String RESOURCE_CERTIFICATE_BUNDLE = "bundle";
    private static final String RESOURCE_CERTIFICATE_SSL = "ssl";
    private static final String LOGIN_KEYSTORE_SERVICE_PID = "HttpsKeystore";
    private static final String SSL_KEYSTORE_SERVICE_PID = "SSLKeystore";
    private static final String DEFAULT_KEYSTORE_SERVICE_PID = "org.eclipse.kura.crypto.CryptoService";
    private CryptoService cryptoService;
    private ConfigurationService configurationService;
    private Map<String, KeystoreService> keystoreServices = new HashMap<String, KeystoreService>();
    private BundleContext bundleContext;
    private ServiceTrackerCustomizer<KeystoreService, KeystoreService> keystoreServiceTrackerCustomizer;
    private ServiceTracker<KeystoreService, KeystoreService> keystoreServiceTracker;

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        if (this.cryptoService == cryptoService) {
            this.cryptoService = null;
        }
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void unsetConfigurationService(ConfigurationService configurationService) {
        if (this.configurationService == configurationService) {
            this.configurationService = null;
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.keystoreServiceTrackerCustomizer = new KeystoreServiceTrackerCustomizer();
        this.initKeystoreServiceTracking();
        logger.info("Bundle {} has started!", (Object)APP_ID);
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.keystoreServiceTracker != null) {
            this.keystoreServiceTracker.close();
        }
        logger.info("Bundle {} is deactivating!", (Object)APP_ID);
    }

    public Certificate returnCertificate(String alias) throws KuraException {
        KeyStore.TrustedCertificateEntry cert;
        try {
            cert = this.getCertificateEntry("org.eclipse.kura.crypto.CryptoService:" + alias).getCertificateEntry();
        }
        catch (KuraException kuraException) {
            return null;
        }
        return cert.getTrustedCertificate();
    }

    public void storeCertificate(Certificate cert, String alias) throws KuraException {
        if (alias.startsWith(RESOURCE_CERTIFICATE_DM)) {
            this.storeDmCertificate(cert, alias);
        } else if (alias.startsWith(RESOURCE_CERTIFICATE_BUNDLE)) {
            this.storeTrustRepoCertificate(cert, alias);
        } else if (alias.startsWith(RESOURCE_CERTIFICATE_LOGIN)) {
            this.storeLoginCertificate(cert, alias);
        } else if (alias.startsWith(RESOURCE_CERTIFICATE_SSL)) {
            this.storeSSLCertificate(cert, alias);
        }
    }

    protected void storeLoginCertificate(Certificate cert, String alias) throws KuraException {
        KuraCertificateEntry kuraCertificate = new KuraCertificateEntry(LOGIN_KEYSTORE_SERVICE_PID, alias, cert);
        this.addCertificate(kuraCertificate);
    }

    protected void storeSSLCertificate(Certificate cert, String alias) throws KuraException {
        KuraCertificateEntry kuraCertificate = new KuraCertificateEntry(SSL_KEYSTORE_SERVICE_PID, alias, cert);
        this.addCertificate(kuraCertificate);
    }

    protected void storeTrustRepoCertificate(Certificate cert, String alias) throws KuraException {
        KuraCertificateEntry kuraCertificate = new KuraCertificateEntry(DEFAULT_KEYSTORE_SERVICE_PID, alias, cert);
        this.addCertificate(kuraCertificate);
    }

    protected void storeDmCertificate(Certificate cert, String alias) throws KuraException {
        this.storeTrustRepoCertificate(cert, alias);
    }

    public Enumeration<String> listBundleCertificatesAliases() {
        return this.listCertificatesAliases(DEFAULT_KEYSTORE_SERVICE_PID);
    }

    public Enumeration<String> listDMCertificatesAliases() {
        return this.listCertificatesAliases(DEFAULT_KEYSTORE_SERVICE_PID);
    }

    public Enumeration<String> listSSLCertificatesAliases() {
        return this.listCertificatesAliases(SSL_KEYSTORE_SERVICE_PID);
    }

    public Enumeration<String> listCACertificatesAliases() {
        return this.listCertificatesAliases(DEFAULT_KEYSTORE_SERVICE_PID);
    }

    public void removeCertificate(String alias) throws KuraException {
        for (Map.Entry<String, KeystoreService> keystoreServiceEntry : this.keystoreServices.entrySet()) {
            keystoreServiceEntry.getValue().deleteEntry(alias);
        }
    }

    public boolean verifySignature(KuraApplicationTopic kuraTopic, KuraPayload kuraPayload) {
        return true;
    }

    protected Enumeration<String> listCertificatesAliases(String keystoreId) {
        try {
            return Collections.enumeration(this.getKeystore(keystoreId).getAliases());
        }
        catch (IllegalArgumentException | KuraException throwable) {
            return Collections.emptyEnumeration();
        }
    }

    public List<KuraCertificateEntry> getCertificates() throws KuraException {
        ArrayList<KuraCertificateEntry> certificates = new ArrayList<KuraCertificateEntry>();
        for (Map.Entry<String, KeystoreService> keystoreServiceEntry : this.keystoreServices.entrySet()) {
            String keystoreId = keystoreServiceEntry.getKey();
            Map keystoreEntries = keystoreServiceEntry.getValue().getEntries();
            keystoreEntries.entrySet().stream().filter(entry -> entry.getValue() instanceof KeyStore.TrustedCertificateEntry).forEach(entry -> {
                String alias = (String)entry.getKey();
                certificates.add(new KuraCertificateEntry(keystoreId, alias, (KeyStore.TrustedCertificateEntry)entry.getValue()));
            });
        }
        return certificates;
    }

    public KuraCertificateEntry getCertificateEntry(String id) throws KuraException {
        String keystoreId = KuraCertificateEntry.getKeystoreId((String)id);
        String alias = KuraCertificateEntry.getAlias((String)id);
        KeyStore.Entry keystoreEntry = this.getKeystore(keystoreId).getEntry(alias);
        if (keystoreEntry instanceof KeyStore.TrustedCertificateEntry) {
            return new KuraCertificateEntry(keystoreId, alias, (KeyStore.TrustedCertificateEntry)keystoreEntry);
        }
        throw new KuraIOException((Object)("Failed to retrieve certificate " + id));
    }

    public void updateCertificate(KuraCertificateEntry certificate) throws KuraException {
        this.addCertificate(certificate);
    }

    public void addCertificate(KuraCertificateEntry certificate) throws KuraException {
        this.getKeystore(certificate.getKeystoreId()).setEntry(certificate.getAlias(), (KeyStore.Entry)certificate.getCertificateEntry());
    }

    public void deleteCertificate(String id) throws KuraException {
        String keystoreId = KuraCertificateEntry.getKeystoreId((String)id);
        String alias = KuraCertificateEntry.getAlias((String)id);
        this.getKeystore(keystoreId).deleteEntry(alias);
    }

    private void initKeystoreServiceTracking() {
        String filterString = String.format("(&(%s=%s))", "objectClass", KeystoreService.class.getName());
        Filter filter = null;
        try {
            filter = this.bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            logger.error("Filter setup exception ", (Throwable)e);
        }
        this.keystoreServiceTracker = new ServiceTracker(this.bundleContext, filter, this.keystoreServiceTrackerCustomizer);
        this.keystoreServiceTracker.open();
    }

    private KeystoreService getKeystore(String keystoreId) throws KuraException {
        KeystoreService service = this.keystoreServices.get(keystoreId);
        if (service == null) {
            throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE, new Object[]{"KeystoreService " + keystoreId + " not found"});
        }
        return service;
    }

    private final class KeystoreServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<KeystoreService, KeystoreService> {
        private static final String KURA_SERVICE_PID = "kura.service.pid";

        private KeystoreServiceTrackerCustomizer() {
        }

        public KeystoreService addingService(ServiceReference<KeystoreService> reference) {
            String kuraServicePid = (String)reference.getProperty(KURA_SERVICE_PID);
            CertificatesManager.this.keystoreServices.put(kuraServicePid, (KeystoreService)CertificatesManager.this.bundleContext.getService(reference));
            return (KeystoreService)CertificatesManager.this.keystoreServices.get(kuraServicePid);
        }

        public void modifiedService(ServiceReference<KeystoreService> reference, KeystoreService service) {
            String kuraServicePid = (String)reference.getProperty(KURA_SERVICE_PID);
            CertificatesManager.this.keystoreServices.put(kuraServicePid, (KeystoreService)CertificatesManager.this.bundleContext.getService(reference));
        }

        public void removedService(ServiceReference<KeystoreService> reference, KeystoreService service) {
            String kuraServicePid = (String)reference.getProperty(KURA_SERVICE_PID);
            CertificatesManager.this.keystoreServices.remove(kuraServicePid);
        }
    }
}

