/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLSocketFactoryWrapper.class);
    private final String ciphers;
    private final Boolean hostnameVerification;
    private final SSLSocketFactory sslsf;

    public SSLSocketFactoryWrapper(SSLSocketFactory sslsf, String ciphers, Boolean hnVerify) {
        this.sslsf = sslsf;
        this.ciphers = ciphers;
        this.hostnameVerification = hnVerify;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslsf.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslsf.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslsf.createSocket();
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.sslsf.createSocket(host, port);
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = this.sslsf.createSocket(host, port, localHost, localPort);
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.sslsf.createSocket(host, port);
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.sslsf.createSocket(address, port, address, localPort);
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.sslsf.createSocket(s, host, port, autoClose);
        this.updateSSLParameters(socket);
        return socket;
    }

    private void updateSSLParameters(Socket socket) throws SocketException {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLParameters sslParams = sslSocket.getSSLParameters();
            ArrayList<String> protocols = new ArrayList<String>(Arrays.asList(sslParams.getProtocols()));
            protocols.remove("SSLv2Hello");
            sslParams.setProtocols(protocols.toArray(new String[protocols.size()]));
            if (this.hostnameVerification.booleanValue()) {
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                logger.info("SSL Endpoint Identification enabled.");
            }
            if (this.ciphers != null && !this.ciphers.isEmpty()) {
                String[] arrCiphers = this.ciphers.split(",");
                ArrayList<String> lsCiphers = new ArrayList<String>();
                String[] stringArray = arrCiphers;
                int n = arrCiphers.length;
                int n2 = 0;
                while (n2 < n) {
                    String cipher = stringArray[n2];
                    lsCiphers.add(cipher.trim());
                    ++n2;
                }
                sslParams.setCipherSuites(lsCiphers.toArray(new String[lsCiphers.size()]));
            }
            sslSocket.setSSLParameters(sslParams);
            socket.setTcpNoDelay(true);
        }
    }
}

