/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.metatype.OCDService;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.JaxRsRequestHandlerProxy;
import org.eclipse.kura.request.handler.jaxrs.annotation.EXEC;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationDTO;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationList;
import org.eclipse.kura.rest.configuration.api.CreateFactoryComponentConfigurationsRequest;
import org.eclipse.kura.rest.configuration.api.DTOUtil;
import org.eclipse.kura.rest.configuration.api.DeleteFactoryComponentRequest;
import org.eclipse.kura.rest.configuration.api.FactoryComponentConfigurationDTO;
import org.eclipse.kura.rest.configuration.api.FailureHandler;
import org.eclipse.kura.rest.configuration.api.PidAndFactoryPid;
import org.eclipse.kura.rest.configuration.api.PidAndFactoryPidSet;
import org.eclipse.kura.rest.configuration.api.PidSet;
import org.eclipse.kura.rest.configuration.api.SnapshotId;
import org.eclipse.kura.rest.configuration.api.SnapshotIdSet;
import org.eclipse.kura.rest.configuration.api.UpdateComponentConfigurationRequest;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/configuration/v2")
public class ConfigurationRestService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationRestService.class);
    private static final String APP_ID = "CONF-V2";
    private static final String KURA_PERMISSION_REST_CONFIGURATION_ROLE = "kura.permission.rest.configuration";
    private static final String SNAPSHOT_SUBTASK_ID = "snapshot";
    private final RequestHandler requestHandler = new JaxRsRequestHandlerProxy((Object)this);
    private ConfigurationService configurationService;
    private OCDService ocdService;
    private CryptoService cryptoService;

    public void setUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole(KURA_PERMISSION_REST_CONFIGURATION_ROLE, 2);
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setOCDService(OCDService ocdService) {
        this.ocdService = ocdService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void setRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.registerRequestHandler(APP_ID, this.requestHandler);
        }
        catch (Exception e) {
            logger.warn("failed to register request handler", (Throwable)e);
        }
    }

    public void unsetRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.unregister(APP_ID);
        }
        catch (KuraException e) {
            logger.warn("failed to unregister request handler", (Throwable)e);
        }
    }

    @GET
    @RolesAllowed(value={"configuration"})
    @Path(value="/snapshots")
    @Produces(value={"application/json"})
    public SnapshotIdSet listSnapshots() {
        try {
            return new SnapshotIdSet(this.configurationService.getSnapshots().stream().collect(Collectors.toCollection(TreeSet::new)));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @GET
    @RolesAllowed(value={"configuration"})
    @Path(value="/factoryComponents")
    @Produces(value={"application/json"})
    public PidSet listFactoryComponentsPids() {
        return new PidSet(this.configurationService.getFactoryComponentPids().stream().collect(Collectors.toSet()));
    }

    @POST
    @RolesAllowed(value={"configuration"})
    @Path(value="/factoryComponents")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createFactoryComponents(CreateFactoryComponentConfigurationsRequest configs) {
        configs.validate();
        FailureHandler handler = new FailureHandler();
        for (FactoryComponentConfigurationDTO config : configs.getConfigs()) {
            handler.runFallibleSubtask("create:" + config.getPid(), () -> {
                Map<String, Object> castedProperties = DTOUtil.dtosToConfigurationProperties(config.getProperties());
                this.configurationService.createFactoryConfiguration(config.getFactoryPid(), config.getPid(), castedProperties, false);
            });
        }
        if (configs.isTakeSnapshot()) {
            handler.runFallibleSubtask(SNAPSHOT_SUBTASK_ID, () -> {
                long l = this.configurationService.snapshot();
            });
        }
        handler.checkStatus();
        return Response.ok().build();
    }

    @DELETE
    @RolesAllowed(value={"configuration"})
    @Path(value="/factoryComponents/byPid")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteFactoryConfigurations(DeleteFactoryComponentRequest request) {
        request.validate();
        FailureHandler handler = new FailureHandler();
        for (String pid : request.getPids()) {
            handler.runFallibleSubtask("delete:" + pid, () -> this.configurationService.deleteFactoryConfiguration(pid, false));
        }
        if (request.isTakeSnapshot()) {
            handler.runFallibleSubtask(SNAPSHOT_SUBTASK_ID, () -> {
                long l = this.configurationService.snapshot();
            });
        }
        handler.checkStatus();
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"configuration"})
    @Path(value="/factoryComponents/ocd")
    @Produces(value={"application/json"})
    public ComponentConfigurationList getFactoryComponentOcds() {
        List ocds;
        try {
            ocds = this.ocdService.getFactoryComponentOCDs();
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return DTOUtil.toComponentConfigurationList(ocds, this.cryptoService, false);
    }

    @POST
    @RolesAllowed(value={"configuration"})
    @Path(value="/factoryComponents/ocd/byFactoryPid")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ComponentConfigurationList getFactoryComponentOcdsByPid(PidSet factoryPids) {
        List<ComponentConfiguration> ocds;
        factoryPids.validate();
        try {
            ocds = this.ocdService.getFactoryComponentOCDs().stream().filter(c -> factoryPids.getPids().contains(c.getPid())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return DTOUtil.toComponentConfigurationList(ocds, this.cryptoService, false);
    }

    @GET
    @RolesAllowed(value={"configuration"})
    @Path(value="/configurableComponents/pidsWithFactory")
    @Produces(value={"application/json"})
    public PidAndFactoryPidSet listConfigurableComponentsPidAndFactoryPid() {
        List ccs;
        try {
            ccs = this.configurationService.getComponentConfigurations();
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        Set<PidAndFactoryPid> result = ccs.stream().map(c -> {
            String pid = c.getPid();
            Optional factoryPid = Optional.ofNullable(c.getConfigurationProperties()).map(p -> p.get("service.factoryPid")).flatMap(o -> {
                if (o instanceof String) {
                    return Optional.of((String)o);
                }
                return Optional.empty();
            });
            if (factoryPid.isPresent()) {
                return new PidAndFactoryPid(pid, (String)factoryPid.get());
            }
            return new PidAndFactoryPid(pid);
        }).collect(Collectors.toSet());
        return new PidAndFactoryPidSet(result);
    }

    @GET
    @RolesAllowed(value={"configuration"})
    @Path(value="/configurableComponents")
    @Produces(value={"application/json"})
    public PidSet listConfigurableComponentsPids() {
        return new PidSet(this.configurationService.getConfigurableComponentPids().stream().collect(Collectors.toSet()));
    }

    @GET
    @RolesAllowed(value={"configuration"})
    @Path(value="/configurableComponents/configurations")
    @Produces(value={"application/json"})
    public ComponentConfigurationList listComponentConfigurations() {
        List ccs;
        try {
            ccs = this.configurationService.getComponentConfigurations();
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return DTOUtil.toComponentConfigurationList(ccs, this.cryptoService, true);
    }

    @POST
    @RolesAllowed(value={"configuration"})
    @Path(value="/configurableComponents/configurations/byPid")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ComponentConfigurationList listComponentConfigurations(PidSet pids) {
        List<ComponentConfiguration> configs;
        pids.validate();
        try {
            configs = this.configurationService.getComponentConfigurations().stream().filter(c -> pids.getPids().contains(c.getPid())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return DTOUtil.toComponentConfigurationList(configs, this.cryptoService, true);
    }

    @POST
    @RolesAllowed(value={"configuration"})
    @Path(value="/configurableComponents/configurations/byPid/_default")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ComponentConfigurationList listDefaultComponentConfiguration(PidSet pids) {
        pids.validate();
        ArrayList<ComponentConfigurationDTO> result = new ArrayList<ComponentConfigurationDTO>();
        for (String pid : pids.getPids()) {
            try {
                ComponentConfiguration cc = this.configurationService.getDefaultComponentConfiguration(pid);
                if (cc == null || cc.getDefinition() == null) {
                    logger.warn("cannot find default configuration for {}", (Object)pid);
                    continue;
                }
                result.add(DTOUtil.toComponentConfigurationDTO(cc, this.cryptoService, true));
            }
            catch (Exception e) {
                logger.warn("failed to get default configuration for {}", (Object)pid, (Object)e);
            }
        }
        return new ComponentConfigurationList(result);
    }

    @PUT
    @RolesAllowed(value={"configuration"})
    @Path(value="/configurableComponents/configurations/_update")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateComponentConfigurations(UpdateComponentConfigurationRequest request) {
        request.validate();
        FailureHandler handler = new FailureHandler();
        for (ComponentConfigurationDTO ccr : request.getComponentConfigurations()) {
            handler.runFallibleSubtask("update:" + ccr.getPid(), () -> {
                Map<String, Object> configurationProperties = DTOUtil.dtosToConfigurationProperties(ccr.getProperties());
                this.configurationService.updateConfiguration(ccr.getPid(), configurationProperties, false);
            });
        }
        if (request.isTakeSnapshot()) {
            handler.runFallibleSubtask(SNAPSHOT_SUBTASK_ID, () -> {
                long l = this.configurationService.snapshot();
            });
        }
        handler.checkStatus();
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"configuration"})
    @Path(value="/snapshots/byId")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ComponentConfigurationList getSnapshot(SnapshotId id) {
        id.validate();
        try {
            List configs = this.configurationService.getSnapshot(id.getId());
            return DTOUtil.toComponentConfigurationList(configs, this.cryptoService, false);
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @EXEC
    @POST
    @RolesAllowed(value={"configuration"})
    @Path(value="/snapshots/_write")
    @Produces(value={"application/json"})
    public SnapshotId takeSnapshot() {
        try {
            return new SnapshotId(this.configurationService.snapshot());
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @EXEC
    @POST
    @RolesAllowed(value={"configuration"})
    @Path(value="/snapshots/_rollback")
    @Produces(value={"application/json"})
    public SnapshotId rollbackSnapshot() {
        try {
            return new SnapshotId(this.configurationService.rollback());
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @EXEC
    @POST
    @RolesAllowed(value={"configuration"})
    @Path(value="/snapshots/byId/_rollback")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response rollbackSnapshot(SnapshotId id) {
        id.validate();
        try {
            this.configurationService.rollback(id.getId());
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
        return Response.ok().build();
    }
}

