/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.dm.FilterIndex;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MultiPropertyExactFilter
implements FilterIndex,
ServiceTrackerCustomizer {
    private final Object m_lock = new Object();
    private ServiceTracker m_tracker;
    private BundleContext m_context;
    private final List m_propertyKeys;
    private final Map m_keyToServiceReferencesMap = new HashMap();
    private final Map m_keyToListenersMap = new HashMap();
    private final Map m_listenerToFilterMap = new HashMap();

    public MultiPropertyExactFilter(String[] propertyKeys) {
        Object[] keys = Arrays.copyOf(propertyKeys, propertyKeys.length);
        Arrays.sort(keys);
        this.m_propertyKeys = Arrays.asList(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(BundleContext context) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context != null) {
                throw new IllegalStateException("Filter already open.");
            }
            try {
                this.m_tracker = new ServiceTracker(context, context.createFilter("(objectClass=*)"), (ServiceTrackerCustomizer)this);
            }
            catch (InvalidSyntaxException e) {
                throw new Error();
            }
            this.m_context = context;
        }
        this.m_tracker.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceTracker tracker;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context == null) {
                throw new IllegalStateException("Filter already closed.");
            }
            tracker = this.m_tracker;
            this.m_tracker = null;
            this.m_context = null;
        }
        tracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllServiceReferences(String clazz, String filter) {
        ArrayList result = new ArrayList();
        List keys = this.createKeysFromFilter(clazz, filter);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Map map = this.m_keyToServiceReferencesMap;
            synchronized (map) {
                List references = (List)this.m_keyToServiceReferencesMap.get(key);
                if (references != null) {
                    result.addAll(references);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        BundleContext context;
        Object object = this.m_lock;
        synchronized (object) {
            context = this.m_context;
        }
        if (context != null) {
            return context.getService(reference);
        }
        throw new IllegalStateException("No valid bundle context.");
    }

    public void addedService(ServiceReference reference, Object service) {
        if (this.isApplicable(reference.getPropertyKeys())) {
            this.add(reference);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        if (this.isApplicable(reference.getPropertyKeys())) {
            this.modify(reference);
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        if (this.isApplicable(reference.getPropertyKeys())) {
            this.remove(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ServiceReference reference) {
        List keys = this.createKeys(reference);
        Map map = this.m_keyToServiceReferencesMap;
        synchronized (map) {
            for (int i = 0; i < keys.size(); ++i) {
                ArrayList<ServiceReference> references = (ArrayList<ServiceReference>)this.m_keyToServiceReferencesMap.get(keys.get(i));
                if (references == null) {
                    references = new ArrayList<ServiceReference>();
                    this.m_keyToServiceReferencesMap.put(keys.get(i), references);
                }
                references.add(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ServiceReference reference) {
        List keys = this.createKeys(reference);
        Map map = this.m_keyToServiceReferencesMap;
        synchronized (map) {
            Iterator iterator = this.m_keyToServiceReferencesMap.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                if (list == null) continue;
                Iterator i2 = list.iterator();
                while (i2.hasNext()) {
                    ServiceReference ref = (ServiceReference)i2.next();
                    if (!ref.equals(reference)) continue;
                    i2.remove();
                }
            }
            for (int i = 0; i < keys.size(); ++i) {
                ArrayList<ServiceReference> references = (ArrayList<ServiceReference>)this.m_keyToServiceReferencesMap.get(keys.get(i));
                if (references == null) {
                    references = new ArrayList<ServiceReference>();
                    this.m_keyToServiceReferencesMap.put(keys.get(i), references);
                }
                references.add(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ServiceReference reference) {
        List keys = this.createKeys(reference);
        Map map = this.m_keyToServiceReferencesMap;
        synchronized (map) {
            for (int i = 0; i < keys.size(); ++i) {
                List references = (List)this.m_keyToServiceReferencesMap.get(keys.get(i));
                if (references == null) continue;
                references.remove(reference);
            }
        }
    }

    public boolean isApplicable(String[] propertyKeys) {
        List<String> list = Arrays.asList(propertyKeys);
        Iterator iterator = this.m_propertyKeys.iterator();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            if (list.contains(item)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println("" + new MultiPropertyExactFilter(new String[]{"objectClass", "repository", "path", "name"}).isApplicable(null, "(objectClass=abc)"));
    }

    public boolean isApplicable(String clazz, String filter) {
        HashSet<String> found = new HashSet<String>();
        if (filter != null && filter.startsWith("(&(objectClass=") && filter.contains(")(&(") && filter.endsWith(")))")) {
            int i1 = filter.indexOf(")(&(");
            String className = filter.substring("(&(objectClass=".length(), i1);
            if (!this.m_propertyKeys.contains("objectClass")) {
                return false;
            }
            found.add("objectClass");
            String[] parts = filter.substring(i1 + ")(&(".length(), filter.length() - ")))".length()).split("\\)\\(");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                String[] tuple = part.split("=");
                if (!this.m_propertyKeys.contains(tuple[0])) {
                    return false;
                }
                found.add(tuple[0]);
            }
            return found.size() == this.m_propertyKeys.size();
        }
        if (filter != null && filter.startsWith("(&(") && filter.endsWith("))")) {
            String[] parts = filter.substring(3, filter.length() - 2).split("\\)\\(");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                String[] tuple = part.split("=");
                if (!this.m_propertyKeys.contains(tuple[0])) {
                    return false;
                }
                found.add(tuple[0]);
            }
            return found.size() == this.m_propertyKeys.size();
        }
        if (filter != null && filter.startsWith("(") && filter.endsWith(")") && this.m_propertyKeys.size() == 1) {
            String part = filter.substring(1, filter.length() - 1);
            String[] tuple = part.split("=");
            return this.m_propertyKeys.contains(tuple[0]);
        }
        return clazz != null && filter == null && this.m_propertyKeys.size() == 1 && this.m_propertyKeys.get(0).equals("objectClass");
    }

    private List createKeys(ServiceReference reference) {
        ArrayList<String> results = new ArrayList<String>();
        results.add("");
        Object[] keys = reference.getPropertyKeys();
        Arrays.sort(keys);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            if (!this.m_propertyKeys.contains(key)) continue;
            Object value = reference.getProperty((String)key);
            if (value instanceof String[]) {
                String[] values = (String[])value;
                ArrayList<String> newResults = new ArrayList<String>();
                for (int j = 0; j < values.length; ++j) {
                    String val = values[j];
                    for (int k = 0; k < results.size(); ++k) {
                        String head = (String)results.get(k);
                        if (head != null && head.length() > 0) {
                            head = head + ";";
                        }
                        newResults.add(head + (String)key + "=" + val);
                    }
                }
                results = newResults;
                continue;
            }
            for (int k = 0; k < results.size(); ++k) {
                String head = (String)results.get(k);
                if (head != null && head.length() > 0) {
                    head = head + ";";
                }
                results.set(k, head + (String)key + "=" + value);
            }
        }
        return results;
    }

    private List createKeysFromFilter(String clazz, String filter) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer index = new StringBuffer();
        Iterator iterator = this.m_propertyKeys.iterator();
        while (iterator.hasNext()) {
            String startString;
            int i1;
            String key = (String)iterator.next();
            if (index.length() > 0) {
                index.append(';');
            }
            index.append(key);
            index.append('=');
            String value = null;
            if (clazz != null && "objectClass".equals(key)) {
                value = clazz;
            }
            if (filter != null && (i1 = filter.indexOf(startString = "(" + key + "=")) != -1) {
                int i2 = filter.indexOf(")(", i1);
                if (i2 == -1) {
                    i2 = filter.endsWith(")))") ? filter.length() - 3 : (filter.endsWith("))") ? filter.length() - 2 : filter.length() - 1);
                }
                String value2 = filter.substring(i1 + startString.length(), i2);
                if (value != null && !value.equals(value2)) {
                    return result;
                }
                value = value2;
            }
            index.append(value);
        }
        result.add(index.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        if (this.isApplicable(event.getServiceReference().getPropertyKeys())) {
            List keys = this.createKeys(event.getServiceReference());
            ArrayList list = new ArrayList();
            Map map = this.m_keyToListenersMap;
            synchronized (map) {
                for (int i = 0; i < keys.size(); ++i) {
                    String key = (String)keys.get(i);
                    List listeners = (List)this.m_keyToListenersMap.get(key);
                    if (listeners == null) continue;
                    list.addAll(listeners);
                }
            }
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ServiceListener listener = (ServiceListener)iterator.next();
                    listener.serviceChanged(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener, String filter) {
        List keys = this.createKeysFromFilter(null, filter);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Map map = this.m_keyToListenersMap;
            synchronized (map) {
                CopyOnWriteArrayList<ServiceListener> listeners = (CopyOnWriteArrayList<ServiceListener>)this.m_keyToListenersMap.get(key);
                if (listeners == null) {
                    listeners = new CopyOnWriteArrayList<ServiceListener>();
                    this.m_keyToListenersMap.put(key, listeners);
                }
                listeners.add(listener);
                this.m_listenerToFilterMap.put(listener, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        Map map = this.m_keyToListenersMap;
        synchronized (map) {
            String filter = (String)this.m_listenerToFilterMap.remove(listener);
            List keys = this.createKeysFromFilter(null, filter);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                List listeners;
                String key = (String)iterator.next();
                boolean result = filter != null;
                if (!result || (listeners = (List)this.m_keyToListenersMap.get(key)) == null) continue;
                listeners.remove(listener);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MultiPropertyExactFilter[");
        sb.append("K2L: " + this.m_keyToListenersMap.size());
        sb.append(", K2SR: " + this.m_keyToServiceReferencesMap.size());
        sb.append(", L2F: " + this.m_listenerToFilterMap.size());
        sb.append("]");
        return sb.toString();
    }
}

