/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloud.factory.CloudServiceFactory;
import org.eclipse.kura.cloudconnection.CloudConnectionConstants;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.cloudconnection.factory.CloudConnectionFactory;
import org.eclipse.kura.cloudconnection.publisher.CloudPublisher;
import org.eclipse.kura.cloudconnection.subscriber.CloudSubscriber;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.web.server.GwtCertificatesServiceImpl;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.GwtComponentServiceInternal;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.FilterUtil;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtCloudComponentFactories;
import org.eclipse.kura.web.shared.model.GwtCloudConnectionEntry;
import org.eclipse.kura.web.shared.model.GwtCloudEntry;
import org.eclipse.kura.web.shared.model.GwtCloudPubSubEntry;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtCloudConnectionService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtCloudConnectionServiceImpl
extends OsgiRemoteServiceServlet
implements GwtCloudConnectionService {
    private static final long serialVersionUID = 693996483299382655L;
    private static final String CLOUD_CONNECTION_FACTORY_FILTER = "(|(objectClass=org.eclipse.kura.cloudconnection.factory.CloudConnectionFactory)(objectClass=org.eclipse.kura.cloud.factory.CloudServiceFactory))";
    private static final String KURA_UI_CSF_PID_DEFAULT = "kura.ui.csf.pid.default";
    private static final String KURA_UI_CSF_PID_REGEX = "kura.ui.csf.pid.regex";
    private static final String CLOUD_PUBLISHER = CloudPublisher.class.getName();
    private static final String CLOUD_SUBSCRIBER = CloudSubscriber.class.getName();
    private static final String DATA_SERVICE_REFERENCE_NAME = "DataService";
    private static final Logger logger = LoggerFactory.getLogger(GwtCertificatesServiceImpl.class);

    @Override
    public List<GwtCloudEntry> findCloudEntries() throws GwtKuraException {
        ArrayList<GwtCloudEntry> result = new ArrayList<GwtCloudEntry>();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(service -> {
            String factoryPid = service.getFactoryPid();
            if (factoryPid == null) {
                return;
            }
            for (String pid : service.getManagedCloudConnectionPids()) {
                if (pid == null) continue;
                GwtCloudConnectionEntry cloudConnectionEntry = new GwtCloudConnectionEntry();
                cloudConnectionEntry.setCloudConnectionFactoryPid(factoryPid);
                cloudConnectionEntry.setPid(pid);
                GwtCloudConnectionServiceImpl.fillState(cloudConnectionEntry);
                result.add(cloudConnectionEntry);
            }
        });
        result.addAll(GwtCloudConnectionServiceImpl.getPublisherInstances());
        result.addAll(GwtCloudConnectionServiceImpl.getSubscriberInstances());
        return result;
    }

    private static void fillState(GwtCloudConnectionEntry cloudConnectionEntry) throws GwtKuraException {
        cloudConnectionEntry.setState(GwtCloudConnectionEntry.GwtCloudConnectionState.UNREGISTERED);
        String filter = String.format("(%s=%s)", "kura.service.pid", cloudConnectionEntry.getPid());
        ServiceLocator.withAllServices(null, filter, service -> {
            if (service instanceof CloudConnectionManager) {
                cloudConnectionEntry.setState(((CloudConnectionManager)service).isConnected() ? GwtCloudConnectionEntry.GwtCloudConnectionState.CONNECTED : GwtCloudConnectionEntry.GwtCloudConnectionState.DISCONNECTED);
                cloudConnectionEntry.setConnectionType(GwtCloudConnectionEntry.GwtCloudConnectionType.CONNECTION);
            } else if (service instanceof CloudEndpoint) {
                cloudConnectionEntry.setConnectionType(GwtCloudConnectionEntry.GwtCloudConnectionType.ENDPOINT);
            } else if (service instanceof CloudService) {
                cloudConnectionEntry.setState(((CloudService)service).isConnected() ? GwtCloudConnectionEntry.GwtCloudConnectionState.CONNECTED : GwtCloudConnectionEntry.GwtCloudConnectionState.DISCONNECTED);
                cloudConnectionEntry.setConnectionType(GwtCloudConnectionEntry.GwtCloudConnectionType.CONNECTION);
            }
        });
    }

    @Override
    public GwtCloudComponentFactories getCloudComponentFactories() throws GwtKuraException {
        ArrayList<String> cloudConnectionFactoryPids = new ArrayList<String>();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(service -> {
            boolean bl = cloudConnectionFactoryPids.add(service.getFactoryPid());
        });
        List<GwtCloudEntry> pubSubFactories = GwtCloudConnectionServiceImpl.getPubSubFactories();
        GwtCloudComponentFactories result = new GwtCloudComponentFactories();
        result.setCloudConnectionFactoryPids(cloudConnectionFactoryPids);
        result.setPubSubFactories(pubSubFactories);
        return result;
    }

    @Override
    public List<GwtConfigComponent> getStackConfigurationsByFactory(String factoryPid, String cloudServicePid) throws GwtKuraException {
        ArrayList result = new ArrayList();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(factory -> {
            if (factoryPid.equals(factory.getFactoryPid())) {
                result.addAll(factory.getStackComponentsPids(cloudServicePid));
            }
        });
        return GwtComponentServiceInternal.findComponentConfigurations(FilterUtil.getPidFilter(result.iterator()));
    }

    @Override
    public void createCloudServiceFromFactory(GwtXSRFToken xsrfToken, String factoryPid, String cloudServicePid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (factoryPid == null || factoryPid.trim().isEmpty() || cloudServicePid == null || cloudServicePid.trim().isEmpty()) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_NULL_ARGUMENT);
        }
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(service -> {
            if (service.getFactoryPid().equals(factoryPid)) {
                service.createConfiguration(cloudServicePid);
            }
        });
    }

    @Override
    public void deleteCloudServiceFromFactory(GwtXSRFToken xsrfToken, String factoryPid, String cloudServicePid) throws GwtKuraException {
        if (factoryPid == null || factoryPid.trim().isEmpty() || cloudServicePid == null || cloudServicePid.trim().isEmpty()) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_NULL_ARGUMENT);
        }
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(service -> {
            if (service.getFactoryPid().equals(factoryPid)) {
                service.deleteConfiguration(cloudServicePid);
            }
        });
    }

    @Override
    public String findSuggestedCloudServicePid(String factoryPid) throws GwtKuraException {
        AtomicReference result = new AtomicReference();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactoryRefs((ref, ctx) -> {
            CloudConnectionFactory cloudServiceFactory = GwtCloudConnectionServiceImpl.wrap(ctx.getService(ref));
            try {
                if (!cloudServiceFactory.getFactoryPid().equals(factoryPid)) {
                    return;
                }
                Object propertyObject = ref.getProperty(KURA_UI_CSF_PID_DEFAULT);
                if (propertyObject != null) {
                    result.set((String)propertyObject);
                }
            }
            finally {
                ctx.ungetService(ref);
            }
        });
        return (String)result.get();
    }

    @Override
    public String findCloudServicePidRegex(String factoryPid) throws GwtKuraException {
        AtomicReference result = new AtomicReference();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactoryRefs((ref, ctx) -> {
            CloudConnectionFactory cloudServiceFactory = GwtCloudConnectionServiceImpl.wrap(ctx.getService(ref));
            try {
                if (!cloudServiceFactory.getFactoryPid().equals(factoryPid)) {
                    return;
                }
                Object propertyObject = ref.getProperty(KURA_UI_CSF_PID_REGEX);
                ServiceLocator.getInstance().ungetService(ref);
                if (propertyObject != null) {
                    result.set((String)propertyObject);
                }
            }
            finally {
                ctx.ungetService(ref);
            }
        });
        return (String)result.get();
    }

    @Override
    public void createPubSubInstance(GwtXSRFToken token, String pid, String factoryPid, String cloudConnectionPid) throws GwtKuraException {
        this.checkXSRFToken(token);
        GwtCloudConnectionServiceImpl.requireIsPubSubFactory(factoryPid);
        ServiceLocator.applyToServiceOptionally(ConfigurationService.class, cs -> {
            cs.createFactoryConfiguration(factoryPid, pid, Collections.singletonMap(CloudConnectionConstants.CLOUD_ENDPOINT_SERVICE_PID_PROP_NAME.value(), cloudConnectionPid), true);
            return null;
        });
    }

    @Override
    public void deletePubSubInstance(GwtXSRFToken token, String pid) throws GwtKuraException {
        this.checkXSRFToken(token);
        GwtCloudConnectionServiceImpl.requireIsPubSub(pid);
        ServiceLocator.applyToServiceOptionally(ConfigurationService.class, cs -> {
            cs.deleteFactoryConfiguration(pid, true);
            return null;
        });
    }

    private static void requireIsPubSubFactory(String factoryPid) throws GwtKuraException {
        boolean isPubSub = ServiceLocator.applyToServiceOptionally(ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().anyMatch(c -> {
            Map properties = c.properties;
            if (properties == null) {
                return false;
            }
            return Objects.equals(factoryPid, properties.get("service.pid")) && GwtCloudConnectionServiceImpl.pubSubToGwt(c) != null;
        }));
        if (!isPubSub) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }

    private static boolean isPubSub(String pid) {
        return GwtServerUtil.providesService(pid, CloudPublisher.class) || GwtServerUtil.providesService(pid, CloudSubscriber.class);
    }

    private static boolean isComponentManagedByFactory(String pid) {
        AtomicBoolean result = new AtomicBoolean(false);
        try {
            GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(f -> {
                for (String stackPid : f.getManagedCloudConnectionPids()) {
                    if (!f.getStackComponentsPids(stackPid).contains(pid)) continue;
                    result.set(true);
                    return;
                }
            });
        }
        catch (Exception exception) {
            return false;
        }
        return result.get();
    }

    private static void requireIsPubSub(String pid) throws GwtKuraException {
        if (!GwtCloudConnectionServiceImpl.isPubSub(pid)) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }

    private static GwtCloudEntry pubSubToGwt(ComponentDescriptionDTO component) {
        if (Arrays.stream(component.serviceInterfaces).noneMatch(intf -> CLOUD_PUBLISHER.equals(intf) || CLOUD_SUBSCRIBER.equals(intf))) {
            return null;
        }
        String ccsfFactoryPidPropName = CloudConnectionConstants.CLOUD_CONNECTION_FACTORY_PID_PROP_NAME.value();
        Object ccsfFactoryPid = component.properties.get(ccsfFactoryPidPropName);
        Object factoryPid = component.properties.get("service.pid");
        Object defaultFactoryPid = component.properties.get(KURA_UI_CSF_PID_DEFAULT);
        Object defaultFactoryPidRegex = component.properties.get(KURA_UI_CSF_PID_REGEX);
        if (!(factoryPid instanceof String)) {
            logger.warn("component {} defines a CloudPublisher or CloudSubscriber but does not specify the service.pid property, ignoring it", (Object)component.name);
            return null;
        }
        if (!(ccsfFactoryPid instanceof String)) {
            logger.warn("component {} defines a CloudPublisher or CloudSubscriber but does not specify the {} property, ignoring it", (Object)component.name, (Object)ccsfFactoryPidPropName);
            return null;
        }
        GwtCloudEntry entry = new GwtCloudEntry();
        entry.setPid((String)factoryPid);
        entry.setFactoryPid((String)ccsfFactoryPid);
        entry.setDefaultFactoryPid((String)defaultFactoryPid);
        entry.setDefaultFactoryPidRegex((String)defaultFactoryPidRegex);
        return entry;
    }

    private static List<GwtCloudEntry> getPubSubFactories() throws GwtKuraException {
        return ServiceLocator.applyToServiceOptionally(ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().map(GwtCloudConnectionServiceImpl::pubSubToGwt).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static GwtCloudPubSubEntry pubSubRefToGwt(ServiceReference<?> ref, GwtCloudPubSubEntry.Type type) {
        Object ccsPid = ref.getProperty(CloudConnectionConstants.CLOUD_ENDPOINT_SERVICE_PID_PROP_NAME.value());
        Object factoryPid = ref.getProperty("service.factoryPid");
        if (!(ccsPid instanceof String) || !(factoryPid instanceof String)) {
            return null;
        }
        String kuraServicePid = (String)ref.getProperty("kura.service.pid");
        GwtCloudPubSubEntry result = new GwtCloudPubSubEntry();
        result.setPid(kuraServicePid);
        result.setCloudConnectionPid((String)ccsPid);
        result.setFactoryPid((String)factoryPid);
        result.setType(type);
        return result;
    }

    private static Set<GwtCloudPubSubEntry> getPublisherInstances() throws GwtKuraException {
        BundleContext context = FrameworkUtil.getBundle(GwtCloudConnectionServiceImpl.class).getBundleContext();
        HashSet<GwtCloudPubSubEntry> result = new HashSet<GwtCloudPubSubEntry>();
        try {
            context.getServiceReferences(CloudPublisher.class, null).stream().map(ref -> GwtCloudConnectionServiceImpl.pubSubRefToGwt(ref, GwtCloudPubSubEntry.Type.PUBLISHER)).filter(Objects::nonNull).forEach(result::add);
            return result;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new GwtKuraException("Unexpected error");
        }
    }

    private static Set<GwtCloudPubSubEntry> getSubscriberInstances() throws GwtKuraException {
        BundleContext context = FrameworkUtil.getBundle(GwtCloudConnectionServiceImpl.class).getBundleContext();
        HashSet<GwtCloudPubSubEntry> result = new HashSet<GwtCloudPubSubEntry>();
        try {
            context.getServiceReferences(CloudSubscriber.class, null).stream().map(ref -> GwtCloudConnectionServiceImpl.pubSubRefToGwt(ref, GwtCloudPubSubEntry.Type.SUBSCRIBER)).filter(Objects::nonNull).forEach(result::add);
            return result;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new GwtKuraException("Unexpected error");
        }
    }

    private static void withAllCloudConnectionFactoryRefs(ServiceLocator.ServiceReferenceConsumer<Object> consumer) throws GwtKuraException {
        ServiceLocator.withAllServiceReferences(CLOUD_CONNECTION_FACTORY_FILTER, consumer, new Class[0]);
    }

    private static void withAllCloudConnectionFactories(ServiceLocator.ServiceConsumer<CloudConnectionFactory> consumer) throws GwtKuraException {
        ServiceLocator.withAllServices(CLOUD_CONNECTION_FACTORY_FILTER, o -> consumer.consume(GwtCloudConnectionServiceImpl.wrap(o)), new Class[0]);
    }

    public static CloudConnectionFactory wrap(Object o) {
        if (o instanceof CloudConnectionFactory) {
            return (CloudConnectionFactory)o;
        }
        if (o instanceof CloudServiceFactory) {
            final CloudServiceFactory f = (CloudServiceFactory)o;
            return new CloudConnectionFactory(){

                public List<String> getStackComponentsPids(String pid) throws KuraException {
                    return f.getStackComponentsPids(pid);
                }

                public Set<String> getManagedCloudConnectionPids() throws KuraException {
                    return f.getManagedCloudServicePids();
                }

                public String getFactoryPid() {
                    return f.getFactoryPid();
                }

                public void deleteConfiguration(String pid) throws KuraException {
                    f.deleteConfiguration(pid);
                }

                public void createConfiguration(String pid) throws KuraException {
                    f.createConfiguration(pid);
                }
            };
        }
        return null;
    }

    @Override
    public GwtConfigComponent getPubSubConfiguration(GwtXSRFToken xsrfToken, String pid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        GwtCloudConnectionServiceImpl.requireIsPubSub(pid);
        return GwtComponentServiceInternal.findFilteredComponentConfiguration(pid).get(0);
    }

    @Override
    public void updateStackComponentConfiguration(GwtXSRFToken xsrfToken, GwtConfigComponent component) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (!GwtCloudConnectionServiceImpl.isPubSub(component.getComponentId()) && !GwtCloudConnectionServiceImpl.isComponentManagedByFactory(component.getComponentId())) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
        }
        GwtComponentServiceInternal.updateComponentConfiguration(component);
    }

    @Override
    public void connectDataService(GwtXSRFToken xsrfToken, String connectionId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpServletRequest request = this.getThreadLocalRequest();
        request.getSession(false);
        Collection<ServiceReference<CloudService>> cloudServiceReferences = ServiceLocator.getInstance().getServiceReferences(CloudService.class, null);
        for (ServiceReference<CloudService> cloudServiceReference : cloudServiceReferences) {
            String cloudServicePid = (String)cloudServiceReference.getProperty("kura.service.pid");
            if (cloudServicePid.endsWith(connectionId)) {
                String dataServiceRef = (String)cloudServiceReference.getProperty("DataService.target");
                Collection<ServiceReference<DataService>> dataServiceReferences = ServiceLocator.getInstance().getServiceReferences(DataService.class, dataServiceRef);
                for (ServiceReference<DataService> dataServiceReference : dataServiceReferences) {
                    DataService dataService = ServiceLocator.getInstance().getService(dataServiceReference);
                    if (dataService != null) {
                        GwtKuraException gwtKuraException = null;
                        int counter = 10;
                        try {
                            dataService.connect();
                            while (!dataService.isConnected() && counter > 0) {
                                Thread.sleep(1000L);
                                --counter;
                            }
                        }
                        catch (KuraConnectException e) {
                            logger.warn("Error connecting", (Throwable)e);
                            gwtKuraException = new GwtKuraException(GwtKuraErrorCode.CONNECTION_FAILURE, (Throwable)e, "Error connecting. Please review your configuration.");
                        }
                        catch (InterruptedException e) {
                            logger.warn("Interrupt Exception");
                            gwtKuraException = new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e, "Interrupt Exception");
                        }
                        catch (IllegalStateException e) {
                            logger.warn("Illegal client state", (Throwable)e);
                            gwtKuraException = new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e, "Illegal client state");
                        }
                        if (gwtKuraException != null) {
                            throw gwtKuraException;
                        }
                    }
                    ServiceLocator.getInstance().ungetService(dataServiceReference);
                }
            }
            ServiceLocator.getInstance().ungetService(cloudServiceReference);
        }
        Collection<ServiceReference<CloudConnectionManager>> cloudConnectionManagerReferences = ServiceLocator.getInstance().getServiceReferences(CloudConnectionManager.class, null);
        for (ServiceReference<CloudConnectionManager> cloudConnectionManagerReference : cloudConnectionManagerReferences) {
            String cloudConnectionManagerPid = (String)cloudConnectionManagerReference.getProperty("kura.service.pid");
            if (cloudConnectionManagerPid.endsWith(connectionId)) {
                CloudConnectionManager cloudConnectionManager = ServiceLocator.getInstance().getService(cloudConnectionManagerReference);
                try {
                    cloudConnectionManager.connect();
                }
                catch (KuraException e) {
                    logger.warn("Error connecting");
                    throw new GwtKuraException(GwtKuraErrorCode.CONNECTION_FAILURE, (Throwable)e, "Error connecting. Please review your configuration.");
                }
            }
            ServiceLocator.getInstance().ungetService(cloudConnectionManagerReference);
        }
    }

    @Override
    public void disconnectDataService(GwtXSRFToken xsrfToken, String connectionId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpServletRequest request = this.getThreadLocalRequest();
        request.getSession(false);
        Collection<ServiceReference<CloudService>> cloudServiceReferences = ServiceLocator.getInstance().getServiceReferences(CloudService.class, null);
        for (ServiceReference<CloudService> cloudServiceReference : cloudServiceReferences) {
            String cloudServicePid = (String)cloudServiceReference.getProperty("kura.service.pid");
            if (cloudServicePid.endsWith(connectionId)) {
                String dataServiceRef = (String)cloudServiceReference.getProperty("DataService.target");
                Collection<ServiceReference<DataService>> dataServiceReferences = ServiceLocator.getInstance().getServiceReferences(DataService.class, dataServiceRef);
                for (ServiceReference<DataService> dataServiceReference : dataServiceReferences) {
                    DataService dataService = ServiceLocator.getInstance().getService(dataServiceReference);
                    if (dataService != null) {
                        dataService.disconnect(10L);
                    }
                    ServiceLocator.getInstance().ungetService(dataServiceReference);
                }
            }
            ServiceLocator.getInstance().ungetService(cloudServiceReference);
        }
        Collection<ServiceReference<CloudConnectionManager>> cloudConnectionManagerReferences = ServiceLocator.getInstance().getServiceReferences(CloudConnectionManager.class, null);
        for (ServiceReference<CloudConnectionManager> cloudConnectionManagerReference : cloudConnectionManagerReferences) {
            String cloudConnectionManagerPid = (String)cloudConnectionManagerReference.getProperty("kura.service.pid");
            if (cloudConnectionManagerPid.endsWith(connectionId)) {
                CloudConnectionManager cloudConnectionManager = ServiceLocator.getInstance().getService(cloudConnectionManagerReference);
                try {
                    cloudConnectionManager.disconnect();
                }
                catch (KuraException e) {
                    logger.warn("Error disconnecting");
                    throw new GwtKuraException(GwtKuraErrorCode.CONNECTION_FAILURE, (Throwable)e, "Error disconnecting. Please review your configuration.");
                }
            }
            ServiceLocator.getInstance().ungetService(cloudConnectionManagerReference);
        }
    }

    @Override
    public boolean isConnected(GwtXSRFToken xsrfToken, String connectionId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        boolean isConnected = false;
        Collection<ServiceReference<CloudService>> cloudServiceReferences = ServiceLocator.getInstance().getServiceReferences(CloudService.class, null);
        for (ServiceReference<CloudService> cloudServiceReference : cloudServiceReferences) {
            String cloudServicePid = (String)cloudServiceReference.getProperty("kura.service.pid");
            if (cloudServicePid.endsWith(connectionId)) {
                String dataServiceRef = (String)cloudServiceReference.getProperty("DataService.target");
                Collection<ServiceReference<DataService>> dataServiceReferences = ServiceLocator.getInstance().getServiceReferences(DataService.class, dataServiceRef);
                for (ServiceReference<DataService> dataServiceReference : dataServiceReferences) {
                    DataService dataService = ServiceLocator.getInstance().getService(dataServiceReference);
                    if (dataService != null) {
                        isConnected = dataService.isConnected();
                    }
                    ServiceLocator.getInstance().ungetService(dataServiceReference);
                }
            }
            ServiceLocator.getInstance().ungetService(cloudServiceReference);
        }
        Collection<ServiceReference<CloudConnectionManager>> cloudConnectionManagerReferences = ServiceLocator.getInstance().getServiceReferences(CloudConnectionManager.class, null);
        for (ServiceReference<CloudConnectionManager> cloudConnectionManagerReference : cloudConnectionManagerReferences) {
            String cloudConnectionManagerPid = (String)cloudConnectionManagerReference.getProperty("kura.service.pid");
            if (cloudConnectionManagerPid.endsWith(connectionId)) {
                CloudConnectionManager cloudConnectionManager = ServiceLocator.getInstance().getService(cloudConnectionManagerReference);
                isConnected = cloudConnectionManager.isConnected();
            }
            ServiceLocator.getInstance().ungetService(cloudConnectionManagerReference);
        }
        return isConnected;
    }
}

