/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.StrongReference;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.TypeRef;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.annotations.DBusProperties;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.DBusSignal;

public class ExportedObject {
    private Map<MethodTuple, Method> methods;
    private Reference<DBusInterface> object;
    private String introspectiondata;

    public ExportedObject(DBusInterface _object, boolean _weakreferences) throws DBusException {
        this.object = _weakreferences ? new WeakReference<DBusInterface>(_object) : new StrongReference<DBusInterface>(_object);
        this.introspectiondata = "";
        this.methods = this.getExportedMethods(_object.getClass());
        this.introspectiondata = this.introspectiondata + " <interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n   <arg type=\"s\" direction=\"out\"/>\n  </method>\n </interface>\n";
        this.introspectiondata = this.introspectiondata + " <interface name=\"org.freedesktop.DBus.Peer\">\n  <method name=\"Ping\">\n  </method>\n  <method name=\"GetMachineId\">\n   <arg type=\"s\" name=\"machine_uuid\" direction=\"out\"/>\n  </method>\n </interface>\n";
    }

    private String getAnnotations(AnnotatedElement c) {
        String ans = "";
        for (Annotation a : c.getDeclaredAnnotations()) {
            if (!a.annotationType().isAssignableFrom(DBusInterface.class)) continue;
            Class<? extends Annotation> t = a.annotationType();
            String value = "";
            try {
                Method m = t.getMethod("value", new Class[0]);
                if (m != null) {
                    value = m.invoke((Object)a, new Object[0]).toString();
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            ans = ans + "  <annotation name=\"" + AbstractConnection.DOLLAR_PATTERN.matcher(t.getName()).replaceAll(".") + "\" value=\"" + value + "\" />\n";
        }
        return ans;
    }

    protected String getProperty(DBusProperty property) throws DBusException {
        String propertyTypeString;
        Class<?> propertyTypeClass = property.type();
        if (TypeRef.class.isAssignableFrom(propertyTypeClass)) {
            Type actualType = Arrays.stream(propertyTypeClass.getGenericInterfaces()).filter(t -> t instanceof ParameterizedType).map(t -> (ParameterizedType)t).filter(t -> TypeRef.class.equals((Object)t.getRawType())).map(t -> t.getActualTypeArguments()[0]).findFirst().orElseThrow(() -> new DBusException("Could not read TypeRef type for property '" + property.name() + "'"));
            propertyTypeString = Marshalling.getDBusType(new Type[]{actualType});
        } else {
            propertyTypeString = List.class.equals(propertyTypeClass) ? "av" : (Map.class.equals(propertyTypeClass) ? "a{vv}" : Marshalling.getDBusType(new Type[]{propertyTypeClass}));
        }
        String access = property.access().getAccessName();
        return "<property name=\"" + property.name() + "\" type=\"" + propertyTypeString + "\" access=\"" + access + "\" />";
    }

    protected String getProperties(Class<?> c) throws DBusException {
        DBusProperty property;
        StringBuilder xml = new StringBuilder();
        DBusProperties properties = c.getAnnotation(DBusProperties.class);
        if (properties != null) {
            for (DBusProperty property2 : properties.value()) {
                xml.append("  ").append(this.getProperty(property2)).append("\n");
            }
        }
        if ((property = c.getAnnotation(DBusProperty.class)) != null) {
            xml.append("  ").append(this.getProperty(property)).append("\n");
        }
        return xml.toString();
    }

    private Map<MethodTuple, Method> getExportedMethods(Class<?> c) throws DBusException {
        if (DBusInterface.class.equals(c)) {
            return new HashMap<MethodTuple, Method>();
        }
        HashMap<MethodTuple, Method> m = new HashMap<MethodTuple, Method>();
        for (Class<?> i : c.getInterfaces()) {
            if (DBusInterface.class.equals(i)) {
                if (null != c.getAnnotation(DBusInterfaceName.class)) {
                    String name = c.getAnnotation(DBusInterfaceName.class).value();
                    this.introspectiondata = this.introspectiondata + " <interface name=\"" + name + "\">\n";
                    DBusSignal.addInterfaceMap(c.getName(), name);
                } else {
                    if (c.getName().equals(c.getSimpleName())) {
                        throw new DBusException("DBusInterfaces cannot be declared outside a package");
                    }
                    if (c.getName().length() > 255) {
                        throw new DBusException("Introspected interface name exceeds 255 characters. Cannot export objects of type " + c.getName());
                    }
                    this.introspectiondata = this.introspectiondata + " <interface name=\"" + AbstractConnection.DOLLAR_PATTERN.matcher(c.getName()).replaceAll(".") + "\">\n";
                }
                this.introspectiondata = this.introspectiondata + this.getAnnotations(c);
                for (Method method : c.getDeclaredMethods()) {
                    int n;
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    String ms = "";
                    String name = method.isAnnotationPresent(DBusMemberName.class) ? method.getAnnotation(DBusMemberName.class).value() : method.getName();
                    if (name.length() > 255) {
                        throw new DBusException("Introspected method name exceeds 255 characters. Cannot export objects with method " + name);
                    }
                    this.introspectiondata = this.introspectiondata + "  <method name=\"" + name + "\" >\n";
                    this.introspectiondata = this.introspectiondata + this.getAnnotations(method);
                    for (Class<?> ex : method.getExceptionTypes()) {
                        if (!DBusExecutionException.class.isAssignableFrom(ex)) continue;
                        this.introspectiondata = this.introspectiondata + "   <annotation name=\"org.freedesktop.DBus.Method.Error\" value=\"" + AbstractConnection.DOLLAR_PATTERN.matcher(ex.getName()).replaceAll(".") + "\" />\n";
                    }
                    Type[] typeArray = method.getGenericParameterTypes();
                    int n2 = typeArray.length;
                    for (n = 0; n < n2; ++n) {
                        Type pt = typeArray[n];
                        for (String s : Marshalling.getDBusType(pt)) {
                            this.introspectiondata = this.introspectiondata + "   <arg type=\"" + s + "\" direction=\"in\"/>\n";
                            ms = ms + s;
                        }
                    }
                    if (!Void.TYPE.equals(method.getGenericReturnType())) {
                        String[] tc;
                        if (Tuple.class.isAssignableFrom(method.getReturnType())) {
                            Type[] ts;
                            tc = (String[])method.getGenericReturnType();
                            for (Type t : ts = tc.getActualTypeArguments()) {
                                if (t == null) continue;
                                for (String s : Marshalling.getDBusType(t)) {
                                    this.introspectiondata = this.introspectiondata + "   <arg type=\"" + s + "\" direction=\"out\"/>\n";
                                }
                            }
                        } else {
                            if (Object[].class.equals((Object)method.getGenericReturnType())) {
                                throw new DBusException("Return type of Object[] cannot be introspected properly");
                            }
                            tc = Marshalling.getDBusType(method.getGenericReturnType());
                            int ts = tc.length;
                            for (n = 0; n < ts; ++n) {
                                String s = tc[n];
                                this.introspectiondata = this.introspectiondata + "   <arg type=\"" + s + "\" direction=\"out\"/>\n";
                            }
                        }
                    }
                    this.introspectiondata = this.introspectiondata + "  </method>\n";
                    m.put(new MethodTuple(name, ms), method);
                }
                this.introspectiondata = this.introspectiondata + this.getProperties(c);
                for (GenericDeclaration genericDeclaration : c.getDeclaredClasses()) {
                    String name;
                    if (!DBusSignal.class.isAssignableFrom((Class<?>)genericDeclaration)) continue;
                    if (((Class)genericDeclaration).isAnnotationPresent(DBusMemberName.class)) {
                        name = ((Class)genericDeclaration).getAnnotation(DBusMemberName.class).value();
                        DBusSignal.addSignalMap(((Class)genericDeclaration).getSimpleName(), name);
                    } else {
                        name = ((Class)genericDeclaration).getSimpleName();
                    }
                    if (name.length() > 255) {
                        throw new DBusException("Introspected signal name exceeds 255 characters. Cannot export objects with signals of type " + name);
                    }
                    this.introspectiondata = this.introspectiondata + "  <signal name=\"" + name + "\">\n";
                    Constructor<?> con = ((Class)genericDeclaration).getConstructors()[0];
                    Type[] ts = con.getGenericParameterTypes();
                    for (int j = 1; j < ts.length; ++j) {
                        for (String s : Marshalling.getDBusType(ts[j])) {
                            this.introspectiondata = this.introspectiondata + "   <arg type=\"" + s + "\" direction=\"out\" />\n";
                        }
                    }
                    this.introspectiondata = this.introspectiondata + this.getAnnotations(genericDeclaration);
                    this.introspectiondata = this.introspectiondata + "  </signal>\n";
                }
                this.introspectiondata = this.introspectiondata + " </interface>\n";
                continue;
            }
            m.putAll(this.getExportedMethods(i));
        }
        return m;
    }

    public Map<MethodTuple, Method> getMethods() {
        return this.methods;
    }

    public Reference<DBusInterface> getObject() {
        return this.object;
    }

    public String getIntrospectiondata() {
        return this.introspectiondata;
    }
}

