/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.internal.JAXRSConnector;
import javax.ws.rs.Path;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceTracker
extends ServiceTracker {
    private final BundleContext context;
    private final JAXRSConnector connector;

    public ResourceTracker(BundleContext context, Filter filter, JAXRSConnector connector) {
        super(context, filter, null);
        this.context = context;
        this.connector = connector;
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        return this.delegateAddService(reference, service);
    }

    private Object delegateAddService(ServiceReference reference, Object service) {
        Object result;
        if (this.isResource(service)) {
            result = this.connector.addResource(reference);
        } else {
            this.context.ungetService(reference);
            result = null;
        }
        return result;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.connector.removeResource(service);
        this.context.ungetService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.connector.removeResource(service);
        this.delegateAddService(reference, service);
    }

    private boolean isResource(Object service) {
        return service != null && (this.hasRegisterableAnnotation(service) || service instanceof Feature);
    }

    private boolean hasRegisterableAnnotation(Object service) {
        boolean result = this.isRegisterableAnnotationPresent(service.getClass());
        if (!result) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = service.getClass().getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                result = result || this.isRegisterableAnnotationPresent(type);
                ++n2;
            }
        }
        return result;
    }

    private boolean isRegisterableAnnotationPresent(Class<?> type) {
        return type.isAnnotationPresent(Path.class) || type.isAnnotationPresent(Provider.class);
    }
}

