/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.bluetooth.le.beacon;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public enum AdvertisingReportEventType {
    ADV_IND(0),
    ADV_DIRECT_IND(1),
    ADV_SCAN_IND(2),
    ADV_NONCONN_IND(3),
    SCAN_RSP(4),
    ADV_IND_EXT(19),
    ADV_DIRECT_IND_EXT(21),
    ADV_SCAN_IND_EXT(18),
    ADV_NONCONN_IND_EXT(16),
    SCAN_RSP_ADV_IND_EXT(27),
    SCAN_RSP_ADV_SCAN_IND_EXT(26),
    DATA_STATUS_COMPLETED(0),
    DATA_STATUS_INCOMPLETE_ONGOING(32),
    DATA_STATUS_INCOMPLETE_FINISHED(64);

    private DataStatus dataStatus = DataStatus.UNKNOWN;
    private boolean connectable = false;
    private boolean directed = false;
    private boolean scannable = false;
    private boolean scanResponse = false;
    private final byte eventType;

    private AdvertisingReportEventType(byte eventType) {
        this.eventType = eventType;
    }

    public DataStatus getDataStatus() {
        return this.dataStatus;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isScannable() {
        return this.scannable;
    }

    public boolean isScanResponse() {
        return this.scanResponse;
    }

    public byte getEventTypeCode() {
        return this.eventType;
    }

    private static AdvertisingReportEventType getLegacyType(int event, byte eventData) {
        AdvertisingReportEventType type = null;
        if ((eventData & 0x10) == 0) {
            byte status = (byte)(eventData & 0x60);
            if (status == AdvertisingReportEventType.DATA_STATUS_COMPLETED.eventType) {
                type = DATA_STATUS_COMPLETED;
                type.dataStatus = DataStatus.COMPLETED;
            } else if (status == AdvertisingReportEventType.DATA_STATUS_INCOMPLETE_ONGOING.eventType) {
                type = DATA_STATUS_INCOMPLETE_ONGOING;
                type.dataStatus = DataStatus.INCOMPLETE_ONGOING;
            } else if (status == AdvertisingReportEventType.DATA_STATUS_INCOMPLETE_FINISHED.eventType) {
                type = DATA_STATUS_INCOMPLETE_FINISHED;
                type.dataStatus = DataStatus.INCOMPLETE_FINISHED;
            } else {
                throw new IllegalArgumentException("Data status type not recognized");
            }
            type.connectable = (eventData & 1) != 0;
            type.scannable = (eventData & 2) != 0;
            type.directed = (eventData & 4) != 0;
            type.scanResponse = (eventData & 8) != 0;
        } else if (event == AdvertisingReportEventType.ADV_IND_EXT.eventType) {
            type = ADV_IND_EXT;
            type.connectable = true;
        } else if (event == AdvertisingReportEventType.ADV_DIRECT_IND_EXT.eventType) {
            type = ADV_DIRECT_IND_EXT;
            type.connectable = true;
            type.directed = true;
        } else if (event == AdvertisingReportEventType.ADV_SCAN_IND_EXT.eventType) {
            type = ADV_SCAN_IND_EXT;
            type.scannable = true;
        } else if (event == AdvertisingReportEventType.SCAN_RSP_ADV_IND_EXT.eventType) {
            type = SCAN_RSP_ADV_IND_EXT;
            type.connectable = true;
            type.scanResponse = true;
        } else if (event == AdvertisingReportEventType.SCAN_RSP_ADV_SCAN_IND_EXT.eventType) {
            type = SCAN_RSP_ADV_SCAN_IND_EXT;
            type.scannable = true;
            type.scanResponse = true;
        } else if (event == AdvertisingReportEventType.ADV_NONCONN_IND_EXT.eventType) {
            type = ADV_NONCONN_IND_EXT;
        } else {
            throw new IllegalArgumentException("Report Event type not recognized");
        }
        return type;
    }

    @Deprecated
    public static AdvertisingReportEventType valueOf(byte event) {
        return AdvertisingReportEventType.valueOf(event, false);
    }

    public static AdvertisingReportEventType valueOf(String string) {
        return Enum.valueOf(AdvertisingReportEventType.class, string);
    }

    public static enum DataStatus {
        UNKNOWN,
        COMPLETED,
        INCOMPLETE_ONGOING,
        INCOMPLETE_FINISHED;

    }
}

