/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.io.IOException;
import java.io.InputStream;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPData;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPInputStream;

public final class FileReader
extends InputStream {
    private short length = 0;
    private boolean locked = true;
    private PMPInputStream is;

    public FileReader(PMPInputStream is) {
        this.is = is;
        is.lock();
        this.checkEOF();
    }

    public synchronized int read() throws IOException {
        if (this.locked) {
            if (this.length > 0) {
                try {
                    int read = this.is.read();
                    this.length = (short)(this.length - 1);
                    return read;
                }
                catch (IOException ioExc) {
                    this.close();
                    throw ioExc;
                }
            }
            this.checkEOF();
            return this.read();
        }
        return -1;
    }

    public synchronized int read(byte[] buff, int off, int len) throws IOException {
        if (this.locked) {
            if (this.length > 0) {
                try {
                    int read = this.is.read(buff, off, this.length >= len ? len : (int)this.length);
                    this.length = (short)(this.length - read);
                    return read;
                }
                catch (IOException ioExc) {
                    this.close();
                    throw ioExc;
                }
            }
            this.checkEOF();
            return this.read(buff, off, len);
        }
        return -1;
    }

    private void checkEOF() {
        if (this.length == 0) {
            try {
                this.length = PMPData.readShort(this.is);
                if (this.length == -1) {
                    this.close();
                }
            }
            catch (IOException iOException) {
                this.close();
            }
        }
    }

    public synchronized void close() {
        if (this.locked) {
            this.locked = false;
            if (this.length > 0) {
                try {
                    this.is.skip(this.length);
                }
                catch (IOException iOException) {}
            }
            this.is.unlock();
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {}
    }
}

