/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.List;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetInterfaceAddress;

public class NetInterfaceAddressImpl
implements NetInterfaceAddress {
    private IPAddress address;
    private short networkPrefixLength;
    private IPAddress netmask;
    private IPAddress gateway;
    private IPAddress broadcast;
    private List<? extends IPAddress> dnsAddresses;

    public NetInterfaceAddressImpl() {
    }

    public NetInterfaceAddressImpl(NetInterfaceAddress other) {
        this.address = other.getAddress();
        this.networkPrefixLength = other.getNetworkPrefixLength();
        this.netmask = other.getNetmask();
        this.gateway = other.getGateway();
        this.broadcast = other.getBroadcast();
        this.dnsAddresses = other.getDnsServers();
    }

    public IPAddress getAddress() {
        return this.address;
    }

    public void setAddress(IPAddress address) {
        this.address = address;
    }

    public short getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    public void setNetworkPrefixLength(short networkPrefixLength) {
        this.networkPrefixLength = networkPrefixLength;
    }

    public IPAddress getNetmask() {
        return this.netmask;
    }

    public void setNetmask(IPAddress netmask) {
        this.netmask = netmask;
    }

    public IPAddress getGateway() {
        return this.gateway;
    }

    public void setGateway(IPAddress gateway) {
        this.gateway = gateway;
    }

    public IPAddress getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(IPAddress broadcast) {
        this.broadcast = broadcast;
    }

    public List<? extends IPAddress> getDnsServers() {
        return this.dnsAddresses;
    }

    public void setDnsServers(List<? extends IPAddress> dnsAddresses) {
        this.dnsAddresses = dnsAddresses;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetInterfaceAddress)) {
            return false;
        }
        NetInterfaceAddress other = (NetInterfaceAddress)obj;
        return this.networkPrefixLength == other.getNetworkPrefixLength() && this.compare(this.address, other.getAddress()) && this.compare(this.netmask, other.getNetmask()) && this.compare(this.gateway, other.getGateway()) && this.compare(this.broadcast, other.getBroadcast()) && this.compare(this.dnsAddresses, other.getDnsServers());
    }

    protected boolean compare(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.broadcast == null ? 0 : this.broadcast.hashCode());
        result = 31 * result + (this.dnsAddresses == null ? 0 : this.dnsAddresses.hashCode());
        result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
        result = 31 * result + this.networkPrefixLength;
        return result;
    }
}

