/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.util.configuration.Property;

public class PKCS11KeystoreServiceOptions {
    private static final Property<String> PKCS11_LIBRARY_PROPERTY = new Property("library.path", String.class);
    private static final Property<String> PIN_PROPERTY = new Property("pin", String.class);
    private static final Property<Integer> SLOT_PROPERTY = new Property("slot", Integer.class);
    private static final Property<Integer> SLOT_LIST_INDEX_PROPERTY = new Property("slot.list.index", Integer.class);
    private static final Property<String> ENABLED_MECHANISMS_PROPERTY = new Property("enabled.mechanisms", String.class);
    private static final Property<String> DISABLED_MECHANISMS_PROPERTY = new Property("disabled.mechanisms", String.class);
    private static final Property<String> ATTRIBUTES_PROPERTY = new Property("attributes", String.class);
    private static final Property<String> CRL_STORE_PATH = new Property("crl.store.path", String.class);
    private final String ownPid;
    private final Optional<String> libraryPath;
    private final Optional<String> pin;
    private final Optional<Integer> slot;
    private final Optional<Integer> slotListIndex;
    private final Optional<String> enabledMechanisms;
    private final Optional<String> disabledMechanisms;
    private final Optional<String> attributes;
    private final Optional<String> crlStorePath;

    public PKCS11KeystoreServiceOptions(Map<String, Object> properties, String ownPid) {
        this.libraryPath = PKCS11_LIBRARY_PROPERTY.getOptional(properties);
        this.pin = PIN_PROPERTY.getOptional(properties);
        this.ownPid = ownPid;
        this.slot = SLOT_PROPERTY.getOptional(properties);
        this.slotListIndex = SLOT_LIST_INDEX_PROPERTY.getOptional(properties);
        this.enabledMechanisms = ENABLED_MECHANISMS_PROPERTY.getOptional(properties).filter(s -> !s.trim().isEmpty());
        this.disabledMechanisms = DISABLED_MECHANISMS_PROPERTY.getOptional(properties).filter(s -> !s.trim().isEmpty());
        this.attributes = ATTRIBUTES_PROPERTY.getOptional(properties).filter(s -> !s.trim().isEmpty());
        this.crlStorePath = CRL_STORE_PATH.getOptional(properties).filter(s -> !s.trim().isEmpty());
    }

    public Optional<String> getLibraryPath() {
        return this.libraryPath;
    }

    public Optional<char[]> getPin(CryptoService cryptoService) throws KuraException {
        if (!this.pin.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(cryptoService.decryptAes(this.pin.get().toCharArray()));
    }

    public String getOwnPid() {
        return this.ownPid;
    }

    public Optional<Integer> getSlot() {
        return this.slot;
    }

    public Optional<Integer> getSlotListIndex() {
        return this.slotListIndex;
    }

    public Optional<String> getEnabledMechanisms() {
        return this.enabledMechanisms;
    }

    public Optional<String> getDisabledMechanisms() {
        return this.disabledMechanisms;
    }

    public Optional<String> getAttributes() {
        return this.attributes;
    }

    public Optional<String> getCrlStorePath() {
        return this.crlStorePath;
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.crlStorePath, this.disabledMechanisms, this.enabledMechanisms, this.libraryPath, this.ownPid, this.pin, this.slot, this.slotListIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PKCS11KeystoreServiceOptions)) {
            return false;
        }
        PKCS11KeystoreServiceOptions other = (PKCS11KeystoreServiceOptions)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.crlStorePath, other.crlStorePath) && Objects.equals(this.disabledMechanisms, other.disabledMechanisms) && Objects.equals(this.enabledMechanisms, other.enabledMechanisms) && Objects.equals(this.libraryPath, other.libraryPath) && Objects.equals(this.ownPid, other.ownPid) && Objects.equals(this.pin, other.pin) && Objects.equals(this.slot, other.slot) && Objects.equals(this.slotListIndex, other.slotListIndex);
    }

    public Optional<String> buildSunPKCS11ProviderConfig() {
        if (!this.libraryPath.isPresent()) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("library = ").append(this.libraryPath.get()).append('\n');
        builder.append("name = kura.provider.").append(this.ownPid).append('\n');
        if (this.slot.isPresent()) {
            builder.append("slot = ").append(this.slot.get()).append('\n');
        }
        if (this.slotListIndex.isPresent()) {
            builder.append("slotListIndex = ").append(this.slotListIndex.get()).append('\n');
        }
        if (this.enabledMechanisms.isPresent()) {
            builder.append("enabledMechanisms = { ").append(this.enabledMechanisms.get()).append(" }\n");
        }
        if (this.disabledMechanisms.isPresent()) {
            builder.append("disabledMechanisms = { ").append(this.disabledMechanisms.get()).append(" }\n");
        }
        if (this.attributes.isPresent()) {
            builder.append(this.attributes.get());
        }
        return Optional.of(builder.toString());
    }
}

