/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.system;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Optional;
import org.eclipse.kura.core.inventory.resources.ContainerImage;
import org.eclipse.kura.core.inventory.resources.ContainerImages;

public class JsonJavaContainerImagesMapper {
    private static final String SYSTEM_IMAGES = "images";
    private static final String SYSTEM_IMAGES_IMAGE_NAME = "name";
    private static final String SYSTEM_IMAGES_IMAGE_VERSION = "version";
    private static final String SYSTEM_IMAGES_IMAGE_TYPE = "type";

    private JsonJavaContainerImagesMapper() {
    }

    public static ContainerImage unmarshal(String encoded) {
        JsonObject object = Json.parse((String)encoded).asObject();
        String name = JsonJavaContainerImagesMapper.getStringValue(object, SYSTEM_IMAGES_IMAGE_NAME);
        String version = JsonJavaContainerImagesMapper.getStringValue(object, SYSTEM_IMAGES_IMAGE_VERSION);
        return new ContainerImage(name, version);
    }

    public static String marshal(ContainerImages contianerImages) {
        JsonObject json = Json.object();
        JsonArray images = new JsonArray();
        contianerImages.getContainerImages().stream().forEach(p -> {
            JsonArray jsonArray2 = images.add((JsonValue)JsonJavaContainerImagesMapper.getJsonPackage(p));
        });
        json.add(SYSTEM_IMAGES, (JsonValue)images);
        return json.toString();
    }

    private static JsonObject getJsonPackage(ContainerImage p) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(SYSTEM_IMAGES_IMAGE_NAME, p.getName());
        jsonObject.add(SYSTEM_IMAGES_IMAGE_VERSION, p.getVersion());
        jsonObject.add(SYSTEM_IMAGES_IMAGE_TYPE, p.getTypeString());
        return jsonObject;
    }

    private static Optional<String> getOptionalStringValue(JsonObject object, String name) {
        return Optional.ofNullable(object.get(name)).map(s -> {
            if (s.isString()) {
                return s.asString();
            }
            throw new IllegalArgumentException(String.valueOf(name) + " must be a string");
        });
    }

    private static String getStringValue(JsonObject object, String name) {
        return JsonJavaContainerImagesMapper.getOptionalStringValue(object, name).orElseThrow(() -> new IllegalArgumentException(String.valueOf(name) + " is required"));
    }
}

