/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.system;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.util.Optional;
import org.eclipse.kura.core.inventory.resources.SystemBundleRef;

public class JsonJavaSystemBundleRefMapper {
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";

    private JsonJavaSystemBundleRefMapper() {
    }

    public static SystemBundleRef unmarshal(String encoded) {
        JsonObject object = Json.parse((String)encoded).asObject();
        String name = JsonJavaSystemBundleRefMapper.getStringValue(object, NAME_KEY);
        Optional<String> version = JsonJavaSystemBundleRefMapper.getOptionalStringValue(object, VERSION_KEY);
        return new SystemBundleRef(name, version);
    }

    private static Optional<String> getOptionalStringValue(JsonObject object, String name) {
        return Optional.ofNullable(object.get(name)).map(s -> {
            if (s.isString()) {
                return s.asString();
            }
            throw new IllegalArgumentException(String.valueOf(name) + " must be a string");
        });
    }

    private static String getStringValue(JsonObject object, String name) {
        return JsonJavaSystemBundleRefMapper.getOptionalStringValue(object, name).orElseThrow(() -> new IllegalArgumentException(String.valueOf(name) + " is required"));
    }
}

