/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import java.lang.reflect.Field;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerBridgeFix
implements ServiceTrackerCustomizer<Object, Thread> {
    private static final Logger logger = LoggerFactory.getLogger(ServletContainerBridgeFix.class);
    private final BundleContext bundleContext;

    public ServletContainerBridgeFix(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Thread addingService(ServiceReference<Object> reference) {
        Object service = this.bundleContext.getService(reference);
        logger.info("found service: {}", service.getClass());
        Worker worker = new Worker(service);
        worker.start();
        return worker;
    }

    public void modifiedService(ServiceReference<Object> reference, Thread worker) {
    }

    public void removedService(ServiceReference<Object> reference, Thread worker) {
        worker.interrupt();
        try {
            worker.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.bundleContext.ungetService(reference);
    }

    private static class Worker
    extends Thread {
        private final Object servlet;

        public Worker(Object servlet) {
            this.servlet = servlet;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("ServletContainerBridgeFixWorker");
            try {
                while (!this.isInterrupted()) {
                    Field servletField = this.servlet.getClass().getDeclaredField("servlet");
                    servletField.setAccessible(true);
                    Object bridge = servletField.get(this.servlet);
                    Field servletConfigField = bridge.getClass().getDeclaredField("servletConfig");
                    servletConfigField.setAccessible(true);
                    Object servletConfig = servletConfigField.get(bridge);
                    if (servletConfig == null) {
                        Worker.sleep(200L);
                        continue;
                    }
                    Field configField = bridge.getClass().getSuperclass().getSuperclass().getDeclaredField("config");
                    configField.setAccessible(true);
                    configField.set(bridge, servletConfig);
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
            catch (Exception e) {
                logger.warn("failed to fix ServletContainerHolder", (Throwable)e);
            }
        }
    }
}

