/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.session;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.session.SecurityHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSecurityHandler
implements SecurityHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseSecurityHandler.class);

    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!Console.getConsoleOptions().isPortAllowed(request.getLocalPort())) {
            response.sendError(404);
            return false;
        }
        response.setHeader("X-FRAME-OPTIONS", "SAMEORIGIN");
        response.setHeader("X-XSS-protection", "1; mode=block");
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setHeader("Pragma", "no-cache");
        BaseSecurityHandler.fixTrailingSlashes(request, response);
        return true;
    }

    private static void fixTrailingSlashes(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getRequestURI();
        if (!path.endsWith("/") || "/".contentEquals(path) || path.isEmpty()) {
            return;
        }
        int end = path.length() - 1;
        while (end > 1 && path.charAt(end) == '/') {
            --end;
        }
        try {
            response.sendRedirect(path.substring(0, end + 1));
        }
        catch (IOException e) {
            logger.warn("unexpected exception", (Throwable)e);
        }
    }
}

