/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.identity.provider;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.identity.AdditionalConfigurations;
import org.eclipse.kura.identity.AssignedPermissions;
import org.eclipse.kura.identity.IdentityConfiguration;
import org.eclipse.kura.identity.IdentityConfigurationComponent;
import org.eclipse.kura.identity.IdentityService;
import org.eclipse.kura.identity.PasswordConfiguration;
import org.eclipse.kura.identity.PasswordStrengthVerificationService;
import org.eclipse.kura.internal.rest.identity.provider.util.IdentityDTOUtils;
import org.eclipse.kura.internal.rest.identity.provider.util.StringUtils;
import org.eclipse.kura.internal.rest.identity.provider.v2.dto.IdentityConfigurationDTO;
import org.eclipse.kura.internal.rest.identity.provider.v2.dto.IdentityConfigurationRequestDTO;
import org.eclipse.kura.internal.rest.identity.provider.v2.dto.IdentityDTO;
import org.eclipse.kura.internal.rest.identity.provider.v2.dto.PasswordStrenghtRequirementsDTO;
import org.eclipse.kura.internal.rest.identity.provider.v2.dto.PermissionDTO;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.JaxRsRequestHandlerProxy;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="identity/v2")
public class IdentityRestServiceV2 {
    private static final String NAME_REQUEST_FIELD = "name";
    private static final Logger logger = LoggerFactory.getLogger(IdentityRestServiceV2.class);
    private static final String MQTT_APP_ID = "IDN-V2";
    private static final String DEBUG_MESSAGE = "Processing request for method '{}'";
    private static final String REST_ROLE_NAME = "identity";
    private static final String KURA_PERMISSION_REST_ROLE = "kura.permission.rest.identity";
    private final RequestHandler requestHandler = new JaxRsRequestHandlerProxy((Object)this);
    private IdentityService identityService;
    private PasswordStrengthVerificationService passwordStrengthVerificationService;

    public void bindUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole(KURA_PERMISSION_REST_ROLE, 2);
    }

    public void bindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.registerRequestHandler(MQTT_APP_ID, this.requestHandler);
        }
        catch (Exception e) {
            logger.warn("Failed to register {} request handler", (Object)MQTT_APP_ID, (Object)e);
        }
    }

    public void unbindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.unregister(MQTT_APP_ID);
        }
        catch (Exception e) {
            logger.warn("Failed to unregister {} request handler", (Object)MQTT_APP_ID, (Object)e);
        }
    }

    public void bindIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void bindPasswordStrengthVerificationService(PasswordStrengthVerificationService passwordStrengthVerificationService) {
        this.passwordStrengthVerificationService = passwordStrengthVerificationService;
    }

    @POST
    @RolesAllowed(value={"identity"})
    @Path(value="/identities")
    @Consumes(value={"application/json"})
    public Response createIdentity(IdentityDTO identity) {
        logger.debug(DEBUG_MESSAGE, (Object)"createIdentity");
        try {
            StringUtils.validateField(NAME_REQUEST_FIELD, identity.getName());
            boolean created = this.identityService.createIdentity(identity.getName());
            if (!created) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.CONFLICT, (String)"Identity already exists");
            }
        }
        catch (Exception e) {
            throw this.toWebApplicationException(e);
        }
        return Response.ok().build();
    }

    @PUT
    @RolesAllowed(value={"identity"})
    @Path(value="/identities")
    @Consumes(value={"application/json"})
    public Response updateIdentity(IdentityConfigurationDTO identityConfigurationDTO) {
        logger.debug(DEBUG_MESSAGE, (Object)"updateIdentity");
        try {
            StringUtils.validateField(NAME_REQUEST_FIELD, identityConfigurationDTO.getIdentity().getName());
            this.identityService.updateIdentityConfiguration(IdentityDTOUtils.toIdentityConfiguration(identityConfigurationDTO));
        }
        catch (Exception e) {
            throw this.toWebApplicationException(e);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"identity"})
    @Path(value="/identities/byName")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public IdentityConfigurationDTO getIdentityByName(IdentityConfigurationRequestDTO identityConfigurationRequestDTO) {
        logger.debug(DEBUG_MESSAGE, (Object)"getIdentityByName");
        try {
            StringUtils.validateField(NAME_REQUEST_FIELD, identityConfigurationRequestDTO.getIdentity().getName());
            String identityName = identityConfigurationRequestDTO.getIdentity().getName();
            Optional identityConfiguration = this.identityService.getIdentityConfiguration(identityName, IdentityDTOUtils.toIdentityConfigurationComponents(identityConfigurationRequestDTO.getConfigurationComponents()));
            if (!identityConfiguration.isPresent()) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.NOT_FOUND, (String)"Identity does not exist");
            }
            return IdentityDTOUtils.fromIdentityConfiguration((IdentityConfiguration)identityConfiguration.get());
        }
        catch (Exception e) {
            throw this.toWebApplicationException(e);
        }
    }

    @POST
    @RolesAllowed(value={"identity"})
    @Path(value="/identities/default/byName")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public IdentityConfigurationDTO getIdentityDefaultByName(IdentityConfigurationRequestDTO identityConfigurationRequestDTO) {
        logger.debug(DEBUG_MESSAGE, (Object)"getIdentityDefaultByName");
        String identityName = identityConfigurationRequestDTO.getIdentity().getName();
        try {
            StringUtils.validateField(NAME_REQUEST_FIELD, identityName);
            IdentityConfiguration identityConfiguration = this.identityService.getIdentityDefaultConfiguration(identityName, IdentityDTOUtils.toIdentityConfigurationComponents(identityConfigurationRequestDTO.getConfigurationComponents()));
            return IdentityDTOUtils.fromIdentityConfiguration(identityConfiguration);
        }
        catch (KuraException e) {
            throw this.toWebApplicationException((Exception)((Object)e));
        }
    }

    @DELETE
    @RolesAllowed(value={"identity"})
    @Path(value="/identities")
    @Consumes(value={"application/json"})
    public Response deleteIdentity(IdentityDTO identity) {
        logger.debug(DEBUG_MESSAGE, (Object)"deleteIdentity");
        try {
            StringUtils.validateField(NAME_REQUEST_FIELD, identity.getName());
            boolean deleted = this.identityService.deleteIdentity(identity.getName());
            if (!deleted) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.NOT_FOUND, (String)"Identity not found");
            }
        }
        catch (Exception e) {
            throw this.toWebApplicationException(e);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/definedPermissions")
    @Produces(value={"application/json"})
    public Set<PermissionDTO> getDefinedPermissions() {
        logger.debug(DEBUG_MESSAGE, (Object)"getDefinedPermissions");
        try {
            return this.identityService.getPermissions().stream().map(IdentityDTOUtils::fromPermission).collect(Collectors.toSet());
        }
        catch (Exception e) {
            throw this.toWebApplicationException(e);
        }
    }

    @GET
    @RolesAllowed(value={"identity"})
    @Path(value="/identities")
    @Produces(value={"application/json"})
    public List<IdentityConfigurationDTO> getIdentities() {
        logger.debug(DEBUG_MESSAGE, (Object)"getIdentities");
        try {
            return this.identityService.getIdentitiesConfiguration(IdentityRestServiceV2.allIdentitiesConfiguration()).stream().map(IdentityDTOUtils::fromIdentityConfiguration).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw this.toWebApplicationException(e);
        }
    }

    @GET
    @Path(value="/passwordStrenghtRequirements")
    @Produces(value={"application/json"})
    public PasswordStrenghtRequirementsDTO getPasswordStrenghtRequirements() {
        logger.debug(DEBUG_MESSAGE, (Object)"getPasswordStrenghtRequirements");
        try {
            return IdentityDTOUtils.fromPasswordStrengthRequirements(this.passwordStrengthVerificationService.getPasswordStrengthRequirements());
        }
        catch (Exception e) {
            throw this.toWebApplicationException(e);
        }
    }

    @POST
    @RolesAllowed(value={"identity"})
    @Path(value="/permissions")
    @Consumes(value={"application/json"})
    public Response createPermission(PermissionDTO permissionDTO) {
        logger.debug(DEBUG_MESSAGE, (Object)"createPermission");
        try {
            StringUtils.validateField(NAME_REQUEST_FIELD, permissionDTO.getName());
            boolean created = this.identityService.createPermission(IdentityDTOUtils.toPermission(permissionDTO));
            if (!created) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.CONFLICT, (String)"Permission already exists");
            }
        }
        catch (KuraException e) {
            throw this.toWebApplicationException((Exception)((Object)e));
        }
        return Response.ok().build();
    }

    @DELETE
    @RolesAllowed(value={"identity"})
    @Path(value="/permissions")
    @Consumes(value={"application/json"})
    public Response deletePermission(PermissionDTO permissionDTO) {
        logger.debug(DEBUG_MESSAGE, (Object)"deletePermission");
        StringUtils.validateField(NAME_REQUEST_FIELD, permissionDTO.getName());
        boolean deleted = false;
        try {
            deleted = this.identityService.deletePermission(IdentityDTOUtils.toPermission(permissionDTO));
            if (!deleted) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.NOT_FOUND, (String)"Permission not found");
            }
        }
        catch (KuraException e) {
            throw this.toWebApplicationException((Exception)((Object)e));
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"identity"})
    @Path(value="/identities/validate")
    @Consumes(value={"application/json"})
    public Response validateIdentityConfiguration(IdentityConfigurationDTO identityConfigurationDTO) {
        try {
            StringUtils.validateField(NAME_REQUEST_FIELD, identityConfigurationDTO.getIdentity().getName());
            this.identityService.validateIdentityConfiguration(IdentityDTOUtils.toIdentityConfiguration(identityConfigurationDTO));
        }
        catch (KuraException e) {
            throw this.toWebApplicationException((Exception)((Object)e));
        }
        return Response.ok().build();
    }

    private static Set<Class<? extends IdentityConfigurationComponent>> allIdentitiesConfiguration() {
        return new HashSet<Class<? extends IdentityConfigurationComponent>>(Arrays.asList(AdditionalConfigurations.class, AssignedPermissions.class, PasswordConfiguration.class));
    }

    private WebApplicationException toWebApplicationException(Exception e) {
        if (e instanceof KuraException && ((KuraException)((Object)e)).getCode() == KuraErrorCode.INVALID_PARAMETER) {
            return DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)e.getMessage());
        }
        return DefaultExceptionHandler.toWebApplicationException((Throwable)e);
    }
}

