/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.cloudconnection.provider.util;

import java.util.Iterator;

public class PidUtils {
    private PidUtils() {
    }

    public static String getPidFilter(Iterator<String> pids) {
        if (!pids.hasNext()) {
            throw new IllegalArgumentException("pids list must be non empty");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(|");
        while (pids.hasNext()) {
            String pid = pids.next();
            builder.append("(kura.service.pid=");
            builder.append(pid);
            builder.append(")");
        }
        builder.append(")");
        return builder.toString();
    }

    public static String stripPidPrefix(String pid) {
        int start = pid.lastIndexOf(46);
        if (start < 0) {
            return pid;
        }
        int begin = start + 1;
        if (begin < pid.length()) {
            return pid.substring(begin);
        }
        return pid;
    }
}

