/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;

public class MQTTUtil {
    public static final int DEFAULT_SERVER_MESSAGE_BUFFER_SIZE = 512;
    public static final boolean DURABLE_MESSAGES = true;
    public static final boolean SESSION_AUTO_COMMIT_SENDS = true;
    public static final boolean SESSION_AUTO_COMMIT_ACKS = true;
    public static final boolean SESSION_PREACKNOWLEDGE = false;
    public static final boolean SESSION_XA = false;
    public static final boolean SESSION_AUTO_CREATE_QUEUE = false;
    public static final int MAX_MESSAGE_SIZE = 0xFFFFFFF;
    public static final String MQTT_RETAIN_ADDRESS_PREFIX = "$sys.mqtt.retain.";
    public static final SimpleString MQTT_QOS_LEVEL_KEY = SimpleString.toSimpleString((String)"mqtt.qos.level");
    public static final SimpleString MQTT_MESSAGE_ID_KEY = SimpleString.toSimpleString((String)"mqtt.message.id");
    public static final SimpleString MQTT_MESSAGE_TYPE_KEY = SimpleString.toSimpleString((String)"mqtt.message.type");
    public static final SimpleString MQTT_MESSAGE_RETAIN_KEY = SimpleString.toSimpleString((String)"mqtt.message.retain");
    public static final String MANAGEMENT_QUEUE_PREFIX = "$sys.mqtt.queue.qos2.";
    public static final int DEFAULT_KEEP_ALIVE_FREQUENCY = 5000;
    public static final WildcardConfiguration MQTT_WILDCARD = new MQTTWildcardConfiguration();
    private static final MQTTLogger logger = MQTTLogger.LOGGER;

    public static String convertMQTTAddressFilterToCore(String filter, WildcardConfiguration wildcardConfiguration) {
        return MQTT_WILDCARD.convert(filter, wildcardConfiguration);
    }

    public static String convertCoreAddressFilterToMQTT(String filter, WildcardConfiguration wildcardConfiguration) {
        if (filter == null) {
            return "";
        }
        if (filter.startsWith(MQTT_RETAIN_ADDRESS_PREFIX)) {
            filter = filter.substring(MQTT_RETAIN_ADDRESS_PREFIX.length(), filter.length());
        }
        return wildcardConfiguration.convert(filter, MQTT_WILDCARD);
    }

    public static String convertMQTTAddressFilterToCoreRetain(String filter, WildcardConfiguration wildcardConfiguration) {
        return MQTT_RETAIN_ADDRESS_PREFIX + MQTT_WILDCARD.convert(filter, wildcardConfiguration);
    }

    private static ICoreMessage createServerMessage(MQTTSession session, SimpleString address, boolean retain, int qos) {
        long id = session.getServer().getStorageManager().generateID();
        CoreMessage message = new CoreMessage(id, 512, session.getCoreMessageObjectPools());
        message.setAddress(address);
        message.putBooleanProperty(MQTT_MESSAGE_RETAIN_KEY, retain);
        message.putIntProperty(MQTT_QOS_LEVEL_KEY, qos);
        message.setType((byte)4);
        return message;
    }

    public static Message createServerMessageFromByteBuf(MQTTSession session, String topic, boolean retain, int qos, ByteBuf payload) {
        String coreAddress = MQTTUtil.convertMQTTAddressFilterToCore(topic, session.getWildcardConfiguration());
        SimpleString address = SimpleString.toSimpleString((String)coreAddress, (SimpleString.StringSimpleStringPool)session.getCoreMessageObjectPools().getAddressStringSimpleStringPool());
        ICoreMessage message = MQTTUtil.createServerMessage(session, address, retain, qos);
        message.getBodyBuffer().writeBytes(payload, 0, payload.readableBytes());
        return message;
    }

    public static Message createPubRelMessage(MQTTSession session, SimpleString address, int messageId) {
        ICoreMessage message = MQTTUtil.createServerMessage(session, address, false, 1);
        message.putIntProperty(MQTT_MESSAGE_ID_KEY, messageId);
        message.putIntProperty(MQTT_MESSAGE_TYPE_KEY, MqttMessageType.PUBREL.value());
        return message;
    }

    public static void logMessage(MQTTSessionState state, MqttMessage message, boolean inbound) {
        if (logger.isTraceEnabled()) {
            MQTTUtil.traceMessage(state, message, inbound);
        }
    }

    public static void traceMessage(MQTTSessionState state, MqttMessage message, boolean inbound) {
        StringBuilder log = new StringBuilder("MQTT(");
        if (state != null) {
            log.append(state.getClientId());
        }
        if (inbound) {
            log.append("): IN << ");
        } else {
            log.append("): OUT >> ");
        }
        if (message.fixedHeader() != null) {
            log.append(message.fixedHeader().messageType().toString());
            if (message.variableHeader() instanceof MqttMessageIdVariableHeader) {
                log.append("(" + ((MqttMessageIdVariableHeader)message.variableHeader()).messageId() + ")");
            }
            switch (message.fixedHeader().messageType()) {
                case PUBLISH: {
                    MqttPublishVariableHeader publishHeader = (MqttPublishVariableHeader)message.variableHeader();
                    String publishPayload = ((MqttPublishMessage)message).payload().toString(StandardCharsets.UTF_8);
                    int maxPayloadLogSize = 256;
                    log.append("(" + publishHeader.packetId() + ")").append(" topic=" + publishHeader.topicName()).append(", qos=" + message.fixedHeader().qosLevel()).append(", retain=" + message.fixedHeader().isRetain()).append(", dup=" + message.fixedHeader().isDup()).append(", payload=" + (publishPayload.length() > 256 ? publishPayload.substring(0, 256) : publishPayload));
                    break;
                }
                case CONNECT: {
                    MqttConnectVariableHeader connectHeader = (MqttConnectVariableHeader)message.variableHeader();
                    MqttConnectPayload payload = ((MqttConnectMessage)message).payload();
                    log.append(" protocol=(").append(connectHeader.name()).append(", ").append(connectHeader.version()).append(")").append(", hasPassword=").append(connectHeader.hasPassword()).append(", isCleanSession=").append(connectHeader.isCleanSession()).append(", keepAliveTimeSeconds=").append(connectHeader.keepAliveTimeSeconds()).append(", clientIdentifier=").append(payload.clientIdentifier()).append(", hasUserName=").append(connectHeader.hasUserName());
                    if (connectHeader.hasUserName()) {
                        log.append(", userName=").append(payload.userName());
                    }
                    log.append(", isWillFlag=").append(connectHeader.isWillFlag());
                    if (!connectHeader.isWillFlag()) break;
                    log.append(", willQos=").append(connectHeader.willQos()).append(", isWillRetain=").append(connectHeader.isWillRetain()).append(", willTopic=").append(payload.willTopic());
                    break;
                }
                case CONNACK: {
                    MqttConnAckVariableHeader connackHeader = (MqttConnAckVariableHeader)message.variableHeader();
                    log.append(" connectReturnCode=").append(connackHeader.connectReturnCode().byteValue()).append(", sessionPresent=").append(connackHeader.isSessionPresent());
                    break;
                }
                case SUBSCRIBE: {
                    for (MqttTopicSubscription sub : ((MqttSubscribeMessage)message).payload().topicSubscriptions()) {
                        log.append("\n\t" + sub.topicName() + " : " + sub.qualityOfService());
                    }
                    break;
                }
                case SUBACK: {
                    for (Integer qos : ((MqttSubAckMessage)message).payload().grantedQoSLevels()) {
                        log.append("\n\t" + qos);
                    }
                    break;
                }
                case UNSUBSCRIBE: {
                    for (String topic : ((MqttUnsubscribeMessage)message).payload().topics()) {
                        log.append("\n\t" + topic);
                    }
                    break;
                }
            }
            logger.trace(log.toString());
        }
    }

    public static class MQTTWildcardConfiguration
    extends WildcardConfiguration {
        public MQTTWildcardConfiguration() {
            this.setDelimiter('/');
            this.setSingleWord('+');
            this.setAnyWords('#');
        }
    }
}

