/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.validator;

import org.eclipse.kura.web.shared.validator.PredicateValidator;

public class SinglePEMValidator
extends PredicateValidator {
    private static final String PEM_REGEX = "^-{5}BEGIN CERTIFICATE-{5}\n[\\W\\w]*?-{5}END CERTIFICATE-{5}";

    public SinglePEMValidator(String message) {
        super(v -> {
            if (v == null) {
                return false;
            }
            boolean match = v.matches(PEM_REGEX);
            String occurrences = v.replaceFirst(PEM_REGEX, "");
            return match && occurrences.isEmpty();
        }, message);
    }
}

