/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.conditional;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.conditional.ConditionalOptions;
import org.eclipse.kura.internal.wire.conditional.WireEnvelopeWrapper;
import org.eclipse.kura.internal.wire.conditional.WireRecordListWrapper;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.graph.EmitterPort;
import org.eclipse.kura.wire.graph.MultiportWireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.wireadmin.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class Conditional
implements WireReceiver,
WireEmitter,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(Conditional.class);
    private volatile WireHelperService wireHelperService;
    private MultiportWireSupport wireSupport;
    private EmitterPort thenPort;
    private EmitterPort elsePort;
    private ScriptEngine scriptEngine;
    private Bindings bindings;
    private ConditionalOptions conditionalOptions;
    private Optional<CompiledScript> script = Optional.empty();

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.info("Activating Conditional component...");
        this.conditionalOptions = new ConditionalOptions(properties);
        this.wireSupport = (MultiportWireSupport)this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        List emitterPorts = this.wireSupport.getEmitterPorts();
        this.thenPort = (EmitterPort)emitterPorts.get(0);
        this.elsePort = (EmitterPort)emitterPorts.get(1);
        this.scriptEngine = this.createEngine();
        this.bindings = this.createBindings();
        if (this.scriptEngine == null) {
            throw new ComponentException("Error Getting Conditional Script Engine");
        }
        this.updated(properties);
        logger.info("Activating Conditional component...done");
    }

    public synchronized void updated(Map<String, Object> properties) {
        logger.info("Updating Conditional component...");
        this.conditionalOptions = new ConditionalOptions(properties);
        try {
            this.script = Optional.of(this.tryCompileScript(this.conditionalOptions.getBooleanExpression()));
        }
        catch (Exception e) {
            logger.warn("Failed to compile boolean expression", (Throwable)e);
            this.script = Optional.empty();
        }
        logger.info("Updating Conditional component...done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("Deactivating Conditional component...");
        logger.info("Deactivating Conditional component...done");
    }

    public synchronized void onWireReceive(WireEnvelope wireEnvelope) {
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        try {
            if (!this.script.isPresent()) {
                logger.warn("The script compilation failed during component configuration update, please review the script.");
                return;
            }
            List inputRecords = wireEnvelope.getRecords();
            WireRecordListWrapper wireRecordList = new WireRecordListWrapper(inputRecords);
            String emitterPid = wireEnvelope.getEmitterPid();
            this.bindings.put("input", (Object)new WireEnvelopeWrapper(wireRecordList, emitterPid));
            this.bindings.put("records", (Object)wireRecordList);
            this.bindings.put("emitterPid", (Object)emitterPid);
            Object decision = this.script.get().eval(this.bindings);
            if (!(decision instanceof Boolean)) {
                logger.warn("Expression result is not a boolean: {}", decision);
                return;
            }
            WireEnvelope outputEnvelope = this.wireSupport.createWireEnvelope(inputRecords);
            if (((Boolean)decision).booleanValue()) {
                this.thenPort.emit(outputEnvelope);
            } else {
                this.elsePort.emit(outputEnvelope);
            }
        }
        catch (Exception e) {
            logger.warn("Exception while performing decision.", (Throwable)e);
        }
    }

    private CompiledScript tryCompileScript(String script) throws ScriptException {
        Compilable engine = (Compilable)((Object)this.scriptEngine);
        return engine.compile(script);
    }

    private ScriptEngine createEngine() {
        Bindings globalScopeBindings;
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        ScriptEngine scriptEngineInstance = factory.getScriptEngine(className -> false);
        if (scriptEngineInstance == null) {
            throw new IllegalStateException("Failed to create script engine");
        }
        Bindings engineScopeBindings = scriptEngineInstance.getBindings(100);
        if (engineScopeBindings != null) {
            engineScopeBindings.remove("exit");
            engineScopeBindings.remove("quit");
        }
        if ((globalScopeBindings = scriptEngineInstance.getBindings(200)) != null) {
            globalScopeBindings.remove("exit");
            globalScopeBindings.remove("quit");
        }
        return scriptEngineInstance;
    }

    private Bindings createBindings() {
        Bindings newBindings = this.scriptEngine.createBindings();
        newBindings.put("logger", (Object)logger);
        newBindings.remove("exit");
        newBindings.remove("quit");
        return newBindings;
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }
}

