/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.status;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.status.NetworkInterfaceIpAddress;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NetworkInterfaceIpAddressStatus<T extends IPAddress> {
    private final List<NetworkInterfaceIpAddress<T>> addresses;
    private final Optional<T> gateway;
    private final List<T> dnsServerAddresses;

    private NetworkInterfaceIpAddressStatus(Builder<T> builder) {
        this.addresses = ((Builder)builder).addresses;
        this.gateway = ((Builder)builder).gateway;
        this.dnsServerAddresses = ((Builder)builder).dnsServerAddresses;
    }

    public List<NetworkInterfaceIpAddress<T>> getAddresses() {
        return this.addresses;
    }

    public Optional<T> getGateway() {
        return this.gateway;
    }

    public List<T> getDnsServerAddresses() {
        return this.dnsServerAddresses;
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.dnsServerAddresses, this.gateway);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkInterfaceIpAddressStatus other = (NetworkInterfaceIpAddressStatus)obj;
        return Objects.equals(this.addresses, other.addresses) && Objects.equals(this.dnsServerAddresses, other.dnsServerAddresses) && Objects.equals(this.gateway, other.gateway);
    }

    public static <U extends IPAddress> Builder<U> builder() {
        return new Builder();
    }

    /* synthetic */ NetworkInterfaceIpAddressStatus(Builder builder, NetworkInterfaceIpAddressStatus networkInterfaceIpAddressStatus) {
        this(builder);
    }

    public static final class Builder<U extends IPAddress> {
        private List<NetworkInterfaceIpAddress<U>> addresses = Collections.emptyList();
        private Optional<U> gateway = Optional.empty();
        private List<U> dnsServerAddresses = Collections.emptyList();

        private Builder() {
        }

        public Builder<U> withAddresses(List<NetworkInterfaceIpAddress<U>> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder<U> withGateway(Optional<U> gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder<U> withDnsServerAddresses(List<U> dnsServerAddresses) {
            this.dnsServerAddresses = dnsServerAddresses;
            return this;
        }

        public NetworkInterfaceIpAddressStatus<U> build() {
            return new NetworkInterfaceIpAddressStatus(this, null);
        }
    }
}

