/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ProcessConfig;

final class ImmutableProcessConfig
implements ProcessConfig {
    private final Boolean privileged;
    @Nullable
    private final String user;
    private final Boolean tty;
    private final String entrypoint;
    private final List<String> arguments;

    private ImmutableProcessConfig(Boolean privileged, @Nullable String user, Boolean tty, String entrypoint, List<String> arguments) {
        this.privileged = privileged;
        this.user = user;
        this.tty = tty;
        this.entrypoint = entrypoint;
        this.arguments = arguments;
    }

    @Override
    @JsonProperty(value="privileged")
    public Boolean privileged() {
        return this.privileged;
    }

    @Override
    @JsonProperty(value="user")
    @Nullable
    public String user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="tty")
    public Boolean tty() {
        return this.tty;
    }

    @Override
    @JsonProperty(value="entrypoint")
    public String entrypoint() {
        return this.entrypoint;
    }

    @Override
    @JsonProperty(value="arguments")
    public List<String> arguments() {
        return this.arguments;
    }

    public final ImmutableProcessConfig withPrivileged(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "privileged");
        if (this.privileged.equals(newValue)) {
            return this;
        }
        return new ImmutableProcessConfig(newValue, this.user, this.tty, this.entrypoint, this.arguments);
    }

    public final ImmutableProcessConfig withUser(@Nullable String value) {
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return new ImmutableProcessConfig(this.privileged, value, this.tty, this.entrypoint, this.arguments);
    }

    public final ImmutableProcessConfig withTty(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "tty");
        if (this.tty.equals(newValue)) {
            return this;
        }
        return new ImmutableProcessConfig(this.privileged, this.user, newValue, this.entrypoint, this.arguments);
    }

    public final ImmutableProcessConfig withEntrypoint(String value) {
        String newValue = Objects.requireNonNull(value, "entrypoint");
        if (this.entrypoint.equals(newValue)) {
            return this;
        }
        return new ImmutableProcessConfig(this.privileged, this.user, this.tty, newValue, this.arguments);
    }

    public final ImmutableProcessConfig withArguments(String ... elements) {
        List<String> newValue = ImmutableProcessConfig.createUnmodifiableList(false, ImmutableProcessConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableProcessConfig(this.privileged, this.user, this.tty, this.entrypoint, newValue);
    }

    public final ImmutableProcessConfig withArguments(Iterable<String> elements) {
        if (this.arguments == elements) {
            return this;
        }
        List<String> newValue = ImmutableProcessConfig.createUnmodifiableList(false, ImmutableProcessConfig.createSafeList(elements, true, false));
        return new ImmutableProcessConfig(this.privileged, this.user, this.tty, this.entrypoint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessConfig && this.equalTo(0, (ImmutableProcessConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessConfig another) {
        return this.privileged.equals(another.privileged) && Objects.equals(this.user, another.user) && this.tty.equals(another.tty) && this.entrypoint.equals(another.entrypoint) && this.arguments.equals(another.arguments);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.privileged.hashCode();
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + this.tty.hashCode();
        h += (h << 5) + this.entrypoint.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        return h;
    }

    public String toString() {
        return "ProcessConfig{privileged=" + this.privileged + ", user=" + this.user + ", tty=" + this.tty + ", entrypoint=" + this.entrypoint + ", arguments=" + String.valueOf(this.arguments) + "}";
    }

    public static ImmutableProcessConfig copyOf(ProcessConfig instance) {
        if (instance instanceof ImmutableProcessConfig) {
            return (ImmutableProcessConfig)instance;
        }
        return ImmutableProcessConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_PRIVILEGED = 1L;
        private static final long INIT_BIT_TTY = 2L;
        private static final long INIT_BIT_ENTRYPOINT = 4L;
        private long initBits = 7L;
        private Boolean privileged;
        private String user;
        private Boolean tty;
        private String entrypoint;
        private List<String> arguments = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(ProcessConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.privileged(instance.privileged());
            String userValue = instance.user();
            if (userValue != null) {
                this.user(userValue);
            }
            this.tty(instance.tty());
            this.entrypoint(instance.entrypoint());
            this.addAllArguments(instance.arguments());
            return this;
        }

        @JsonProperty(value="privileged")
        public final Builder privileged(Boolean privileged) {
            this.privileged = Objects.requireNonNull(privileged, "privileged");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="tty")
        public final Builder tty(Boolean tty) {
            this.tty = Objects.requireNonNull(tty, "tty");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="entrypoint")
        public final Builder entrypoint(String entrypoint) {
            this.entrypoint = Objects.requireNonNull(entrypoint, "entrypoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder argument(String element) {
            this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            return this;
        }

        public final Builder arguments(String ... elements) {
            for (String element : elements) {
                this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            }
            return this;
        }

        @JsonProperty(value="arguments")
        public final Builder arguments(Iterable<String> elements) {
            this.arguments.clear();
            return this.addAllArguments(elements);
        }

        public final Builder addAllArguments(Iterable<String> elements) {
            for (String element : elements) {
                this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            }
            return this;
        }

        public ImmutableProcessConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcessConfig(this.privileged, this.user, this.tty, this.entrypoint, ImmutableProcessConfig.createUnmodifiableList(true, this.arguments));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("privileged");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tty");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("entrypoint");
            }
            return "Cannot build ProcessConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

