/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ImmutableNodeSpec;

@JsonDeserialize(builder=ImmutableNodeSpec.Builder.class)
@Value.Immutable
public interface NodeSpec {
    @JsonProperty(value="Name")
    @Nullable
    public String name();

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();

    @JsonProperty(value="Role")
    public String role();

    @JsonProperty(value="Availability")
    public String availability();

    public static Builder builder() {
        return ImmutableNodeSpec.builder();
    }

    public static Builder builder(NodeSpec source) {
        return ImmutableNodeSpec.builder().from(source);
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder addLabel(String var1, String var2);

        public Builder labels(Map<String, ? extends String> var1);

        public Builder role(String var1);

        public Builder availability(String var1);

        public NodeSpec build();
    }
}

