/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class SpecfileDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    final char lTerminator = System.getProperty("line.separator").charAt(0);

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos < 0) {
            return;
        }
        this.fText = part;
        if (!this.selectComment(pos)) {
            this.selectWord(pos);
        }
    }

    protected boolean selectComment(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            int pos = caretPos;
            char c = ' ';
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (c == '\\') {
                    pos -= 2;
                    continue;
                }
                if (c == this.lTerminator || c == '\"') break;
                --pos;
            }
            if (c != '\"') {
                return false;
            }
            int startPos = pos;
            int length = doc.getLength();
            c = ' ';
            for (pos = caretPos; pos < length && (c = (char)doc.getChar(pos)) != this.lTerminator && c != '\"'; ++pos) {
            }
            if (c != '\"') {
                return false;
            }
            int endPos = pos;
            int offset = startPos + 1;
            int len = endPos - offset;
            this.fText.setSelectedRange(offset, len);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean selectWord(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos;
            for (pos = caretPos; pos >= 0 && Character.isJavaIdentifierPart(c = doc.getChar(pos)); --pos) {
            }
            int startPos = pos;
            int length = doc.getLength();
            for (pos = caretPos; pos < length && Character.isJavaIdentifierPart(c = doc.getChar(pos)); ++pos) {
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.fText.setSelectedRange(offset, length);
    }
}

