/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.ssl.SSLContexts;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.mandas.docker.client.DockerCertificatesStore;
import org.mandas.docker.client.exceptions.DockerCertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCertificates
implements DockerCertificatesStore {
    public static final String DEFAULT_CA_CERT_NAME = "ca.pem";
    public static final String DEFAULT_CLIENT_CERT_NAME = "cert.pem";
    public static final String DEFAULT_CLIENT_KEY_NAME = "key.pem";
    private static final char[] KEY_STORE_PASSWORD = "docker!!11!!one!".toCharArray();
    private static final Set<String> PRIVATE_KEY_ALGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("RSA", "EC")));
    private static final Logger log = LoggerFactory.getLogger(DockerCertificates.class);
    private final SSLContext sslContext;

    public DockerCertificates(Path dockerCertPath) throws DockerCertificateException {
        this(new Builder().dockerCertPath(dockerCertPath));
    }

    private DockerCertificates(Builder builder) throws DockerCertificateException {
        if (builder.caCertPath == null || builder.clientCertPath == null || builder.clientKeyPath == null) {
            throw new DockerCertificateException("caCertPath, clientCertPath, and clientKeyPath must all be specified");
        }
        try {
            PrivateKey clientKey = this.readPrivateKey(builder.clientKeyPath);
            List<Certificate> clientCerts = this.readCertificates(builder.clientCertPath);
            KeyStore keyStore = this.newKeyStore();
            keyStore.setKeyEntry("key", clientKey, KEY_STORE_PASSWORD, clientCerts.toArray(new Certificate[clientCerts.size()]));
            List<Certificate> caCerts = this.readCertificates(builder.caCertPath);
            KeyStore trustStore = this.newKeyStore();
            for (Certificate caCert : caCerts) {
                X509Certificate crt = (X509Certificate)caCert;
                String alias = crt.getSubjectX500Principal().getName();
                trustStore.setCertificateEntry(alias, caCert);
            }
            this.sslContext = builder.sslContextFactory.newSslContext(keyStore, KEY_STORE_PASSWORD, trustStore);
        }
        catch (DockerCertificateException e) {
            throw e;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new DockerCertificateException(e);
        }
    }

    private KeyStore newKeyStore() throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        return keyStore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PrivateKey readPrivateKey(Path file) throws IOException, InvalidKeySpecException, DockerCertificateException {
        try (BufferedReader reader = Files.newBufferedReader(file, Charset.defaultCharset());){
            PEMParser pemParser = new PEMParser((Reader)reader);
            Object readObject = pemParser.readObject();
            if (readObject instanceof PEMKeyPair) {
                PEMKeyPair clientKeyPair = (PEMKeyPair)readObject;
                PrivateKey privateKey = DockerCertificates.generatePrivateKey(clientKeyPair.getPrivateKeyInfo());
                return privateKey;
            }
            if (!(readObject instanceof PrivateKeyInfo)) throw new DockerCertificateException("Can not generate private key from file: " + file.toString());
            PrivateKey privateKey = DockerCertificates.generatePrivateKey((PrivateKeyInfo)readObject);
            return privateKey;
            finally {
                pemParser.close();
            }
        }
    }

    private static PrivateKey generatePrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException, InvalidKeySpecException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
        return DockerCertificates.tryGeneratePrivateKey(spec, PRIVATE_KEY_ALGS);
    }

    private static PrivateKey tryGeneratePrivateKey(PKCS8EncodedKeySpec spec, Set<String> algorithms) throws InvalidKeySpecException {
        for (String algorithm : algorithms) {
            try {
                KeyFactory kf = KeyFactory.getInstance(algorithm);
                PrivateKey key = kf.generatePrivate(spec);
                log.debug("Generated private key from spec using the '{}' algorithm", (Object)algorithm);
                return key;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                log.debug("Tried generating private key from spec using the '{}' algorithm", (Object)algorithm, (Object)e);
            }
        }
        String error = String.format("Could not generate private key from spec. Tried using %s", algorithms.stream().collect(Collectors.joining(", ")));
        throw new InvalidKeySpecException(error);
    }

    private List<Certificate> readCertificates(Path file) throws CertificateException, IOException {
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>(cf.generateCertificates(inputStream));
            return arrayList;
        }
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public HostnameVerifier hostnameVerifier() {
        return NoopHostnameVerifier.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SslContextFactory sslContextFactory = new DefaultSslContextFactory();
        private Path caCertPath;
        private Path clientKeyPath;
        private Path clientCertPath;

        public Builder dockerCertPath(Path dockerCertPath) {
            this.caCertPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CA_CERT_NAME);
            this.clientKeyPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CLIENT_KEY_NAME);
            this.clientCertPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CLIENT_CERT_NAME);
            return this;
        }

        public Builder caCertPath(Path caCertPath) {
            this.caCertPath = caCertPath;
            return this;
        }

        public Builder clientKeyPath(Path clientKeyPath) {
            this.clientKeyPath = clientKeyPath;
            return this;
        }

        public Builder clientCertPath(Path clientCertPath) {
            this.clientCertPath = clientCertPath;
            return this;
        }

        public Builder sslFactory(SslContextFactory sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
            return this;
        }

        public Optional<DockerCertificatesStore> build() throws DockerCertificateException {
            if (this.caCertPath == null || this.clientKeyPath == null || this.clientCertPath == null) {
                log.debug("caCertPath, clientKeyPath or clientCertPath not specified, not using SSL");
                return Optional.empty();
            }
            if (Files.exists(this.caCertPath, new LinkOption[0]) && Files.exists(this.clientKeyPath, new LinkOption[0]) && Files.exists(this.clientCertPath, new LinkOption[0])) {
                return Optional.of(new DockerCertificates(this));
            }
            log.debug("{}, {} or {} does not exist, not using SSL", new Object[]{this.caCertPath, this.clientKeyPath, this.clientCertPath});
            return Optional.empty();
        }
    }

    public static interface SslContextFactory {
        public SSLContext newSslContext(KeyStore var1, char[] var2, KeyStore var3) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException;
    }

    private static class DefaultSslContextFactory
    implements SslContextFactory {
        private DefaultSslContextFactory() {
        }

        @Override
        public SSLContext newSslContext(KeyStore keyStore, char[] keyPassword, KeyStore trustStore) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
            return SSLContexts.custom().loadTrustMaterial(trustStore, null).loadKeyMaterial(keyStore, keyPassword).build();
        }
    }
}

