/*
 * Decompiled with CFR 0.152.
 */
package machine.impl;

import java.util.Map;
import machine.ActionType;
import machine.Axis;
import machine.BidirectionalPath;
import machine.Distance;
import machine.FullMeshPath;
import machine.Import;
import machine.Machine;
import machine.MachineFactory;
import machine.MachinePackage;
import machine.PathAnnotation;
import machine.PathTargetReference;
import machine.Peripheral;
import machine.PeripheralType;
import machine.Position;
import machine.Profile;
import machine.Resource;
import machine.ResourceItem;
import machine.SetPoint;
import machine.SymbolicPosition;
import machine.UnidirectionalPath;
import machine.impl.ActionTypeImpl;
import machine.impl.AxisImpl;
import machine.impl.AxisPositionMapEntryImpl;
import machine.impl.AxisPositionsMapEntryImpl;
import machine.impl.BidirectionalPathImpl;
import machine.impl.DistanceImpl;
import machine.impl.FullMeshPathImpl;
import machine.impl.ImportImpl;
import machine.impl.MachineImpl;
import machine.impl.PathAnnotationImpl;
import machine.impl.PathTargetReferenceImpl;
import machine.impl.PeripheralImpl;
import machine.impl.PeripheralTypeImpl;
import machine.impl.PositionImpl;
import machine.impl.ProfileImpl;
import machine.impl.ResourceImpl;
import machine.impl.ResourceItemImpl;
import machine.impl.SetPointImpl;
import machine.impl.SymbolicPositionImpl;
import machine.impl.UnidirectionalPathImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class MachineFactoryImpl
extends EFactoryImpl
implements MachineFactory {
    public static MachineFactory init() {
        try {
            MachineFactory theMachineFactory = (MachineFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/lsat/machine");
            if (theMachineFactory != null) {
                return theMachineFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MachineFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createPeripheralType();
            }
            case 2: {
                return this.createSymbolicPosition();
            }
            case 3: {
                return this.createResource();
            }
            case 4: {
                return this.createActionType();
            }
            case 5: {
                return this.createPeripheral();
            }
            case 6: {
                return this.createMachine();
            }
            case 8: {
                return this.createImport();
            }
            case 9: {
                return this.createProfile();
            }
            case 10: {
                return this.createAxis();
            }
            case 11: {
                return this.createPosition();
            }
            case 12: {
                return this.createSetPoint();
            }
            case 13: {
                return (EObject)this.createAxisPositionMapEntry();
            }
            case 14: {
                return (EObject)this.createAxisPositionsMapEntry();
            }
            case 15: {
                return this.createPathTargetReference();
            }
            case 16: {
                return this.createUnidirectionalPath();
            }
            case 17: {
                return this.createBidirectionalPath();
            }
            case 18: {
                return this.createFullMeshPath();
            }
            case 19: {
                return this.createPathAnnotation();
            }
            case 20: {
                return this.createResourceItem();
            }
            case 22: {
                return this.createDistance();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public PeripheralType createPeripheralType() {
        PeripheralTypeImpl peripheralType = new PeripheralTypeImpl();
        return peripheralType;
    }

    @Override
    public SymbolicPosition createSymbolicPosition() {
        SymbolicPositionImpl symbolicPosition = new SymbolicPositionImpl();
        return symbolicPosition;
    }

    @Override
    public Resource createResource() {
        ResourceImpl resource = new ResourceImpl();
        return resource;
    }

    @Override
    public ActionType createActionType() {
        ActionTypeImpl actionType = new ActionTypeImpl();
        return actionType;
    }

    @Override
    public Peripheral createPeripheral() {
        PeripheralImpl peripheral = new PeripheralImpl();
        return peripheral;
    }

    @Override
    public Machine createMachine() {
        MachineImpl machine = new MachineImpl();
        return machine;
    }

    @Override
    public Import createImport() {
        ImportImpl import_ = new ImportImpl();
        return import_;
    }

    @Override
    public Profile createProfile() {
        ProfileImpl profile = new ProfileImpl();
        return profile;
    }

    @Override
    public Axis createAxis() {
        AxisImpl axis = new AxisImpl();
        return axis;
    }

    @Override
    public Position createPosition() {
        PositionImpl position = new PositionImpl();
        return position;
    }

    @Override
    public SetPoint createSetPoint() {
        SetPointImpl setPoint = new SetPointImpl();
        return setPoint;
    }

    public Map.Entry<Axis, Position> createAxisPositionMapEntry() {
        AxisPositionMapEntryImpl axisPositionMapEntry = new AxisPositionMapEntryImpl();
        return axisPositionMapEntry;
    }

    public Map.Entry<Axis, EList<Position>> createAxisPositionsMapEntry() {
        AxisPositionsMapEntryImpl axisPositionsMapEntry = new AxisPositionsMapEntryImpl();
        return axisPositionsMapEntry;
    }

    @Override
    public PathTargetReference createPathTargetReference() {
        PathTargetReferenceImpl pathTargetReference = new PathTargetReferenceImpl();
        return pathTargetReference;
    }

    @Override
    public UnidirectionalPath createUnidirectionalPath() {
        UnidirectionalPathImpl unidirectionalPath = new UnidirectionalPathImpl();
        return unidirectionalPath;
    }

    @Override
    public BidirectionalPath createBidirectionalPath() {
        BidirectionalPathImpl bidirectionalPath = new BidirectionalPathImpl();
        return bidirectionalPath;
    }

    @Override
    public FullMeshPath createFullMeshPath() {
        FullMeshPathImpl fullMeshPath = new FullMeshPathImpl();
        return fullMeshPath;
    }

    @Override
    public PathAnnotation createPathAnnotation() {
        PathAnnotationImpl pathAnnotation = new PathAnnotationImpl();
        return pathAnnotation;
    }

    @Override
    public ResourceItem createResourceItem() {
        ResourceItemImpl resourceItem = new ResourceItemImpl();
        return resourceItem;
    }

    @Override
    public Distance createDistance() {
        DistanceImpl distance = new DistanceImpl();
        return distance;
    }

    @Override
    public MachinePackage getMachinePackage() {
        return (MachinePackage)this.getEPackage();
    }

    @Deprecated
    public static MachinePackage getPackage() {
        return MachinePackage.eINSTANCE;
    }
}

