/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timinganalysis.ui.launch;

import activity.ActivitySet;
import activity.util.Event2Resource;
import dispatching.ActivityDispatching;
import dispatching.util.DispatchingUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import machine.Import;
import machine.ImportContainer;
import machine.Machine;
import machine.util.ImportsFlattener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;
import org.eclipse.lsat.common.emf.ecore.resource.PersistorFactory;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceSetUtil;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.common.scheduler.algorithm.AsapScheduler;
import org.eclipse.lsat.common.scheduler.algorithm.CycleFoundException;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.common.scheduler.resources.ResourceModel;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.scheduler.ALAPScheduler;
import org.eclipse.lsat.scheduler.AddExecutionTimes;
import org.eclipse.lsat.scheduler.AnnotateClaimRelease;
import org.eclipse.lsat.scheduler.CleanupGraph;
import org.eclipse.lsat.scheduler.CleanupSchedule;
import org.eclipse.lsat.scheduler.ConcatenatedMoveAnalysis;
import org.eclipse.lsat.scheduler.CriticalPathAnalysis;
import org.eclipse.lsat.scheduler.Dispatching2Graph;
import org.eclipse.lsat.scheduler.Dispatching2GraphOutput;
import org.eclipse.lsat.scheduler.Graph2GraphML;
import org.eclipse.lsat.scheduler.MergeClaimedBy;
import org.eclipse.lsat.scheduler.Schedule2GraphML;
import org.eclipse.lsat.scheduler.StochasticImpactAnalysis;
import org.eclipse.lsat.scheduler.StochasticImpactAnalysisInput;
import org.eclipse.lsat.scheduler.VisualizeClaimedBy;
import org.eclipse.lsat.scheduler.VisualizeEvents;
import org.eclipse.lsat.scheduler.etfgen.GenerateAll;
import org.eclipse.lsat.scheduler.simulator.main.GenerateMachineTemplate;
import org.eclipse.lsat.scheduler.simulator.main.GenerateScheduleTemplate;
import org.eclipse.lsat.scheduler.simulator.main.GenerateSettingsTemplate;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.lsat.timing.util.TimingCalculator;
import org.eclipse.lsat.timinganalysis.ui.AnimationView;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import setting.SettingUtil;
import setting.Settings;

public class TimingAnalysisLaunchDelegate
extends LaunchConfigurationDelegate
implements TimingAnalysisLaunchAttributes {
    private static final String BULLET = "\u2022";
    private IProgressMonitor monitor;
    private boolean runningInDebugMode;
    private PersistorFactory persistorFactory;
    private IFile dispatchingIFile;
    private IFolder saveIFolder;
    private URI saveBaseURI;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.monitor = monitor;
        this.runningInDebugMode = mode.equals("debug");
        this.persistorFactory = new PersistorFactory();
        this.dispatchingIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(configuration.getAttribute(MODEL_IFILE, "")));
        this.saveIFolder = this.dispatchingIFile.getProject().getFolder("analysis").getFolder("scheduled");
        this.saveBaseURI = URIHelper.asURI((IResource)this.saveIFolder).appendSegment(URIHelper.baseName((IResource)this.dispatchingIFile));
        URI intermediateURI = URIHelper.asURI((IResource)this.saveIFolder).appendSegment(".intermediate").appendSegment(URIHelper.baseName((IResource)this.dispatchingIFile));
        boolean criticalPath = configuration.getAttribute(CRITICAL_PATH, false);
        boolean stochasticImpact = configuration.getAttribute(STOCHASTIC_IMPACT, false);
        boolean ganttChart = criticalPath || stochasticImpact || configuration.getAttribute(GANTT_CHART, true);
        boolean paperscriptAnimation = configuration.getAttribute(PAPERSCRIPT_ANIMATION, false);
        boolean removeClaimReleaseDependencies = configuration.getAttribute(REMOVE_CLAIMS_RELEASES_DEPENDENCIES, false);
        int prepareSchedulingTicks = 10;
        int generateGraphFromActivityDispatchingTicks = 30;
        int shortcutClaimReleaseTicks = 2;
        int refineGraphWithExecutionTimesTicks = 18;
        int scheduleGraphOnResourcesTicks = 10;
        int visualizeResourceClaimsTicks = 20;
        int generateGanttChartTicks = 10;
        int generateAnimationsTicks = 20;
        int stochasticImpactTicks = 50;
        int totalTicks = prepareSchedulingTicks + generateGraphFromActivityDispatchingTicks + refineGraphWithExecutionTimesTicks + scheduleGraphOnResourcesTicks + visualizeResourceClaimsTicks;
        if (ganttChart) {
            totalTicks += generateGanttChartTicks;
        }
        if (paperscriptAnimation) {
            totalTicks += generateAnimationsTicks;
        }
        if (stochasticImpact) {
            totalTicks += stochasticImpactTicks;
        }
        monitor.beginTask("Timing Analysis", totalTicks);
        try {
            if (URIHelper.asFile((IResource)this.saveIFolder).mkdirs()) {
                this.dispatchingIFile.getProject().refreshLocal(2, monitor);
            }
            monitor.subTask("Preparing specification for scheduling");
            Persistor dispatchingPersistor = this.persistorFactory.getPersistor(ActivityDispatching.class);
            ActivityDispatching activityDispatching = (ActivityDispatching)dispatchingPersistor.loadOne(URIHelper.asURI((IResource)this.dispatchingIFile));
            monitor.subTask("Validating dispatching file");
            this.validate((EObject)activityDispatching, this.dispatchingIFile.getName());
            String settingFilePath = configuration.getAttribute(SETTING_IFILE, "");
            IFile settingsIFile = !"".equals(settingFilePath) ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(settingFilePath)) : null;
            Settings settings = SettingUtil.getSettings((Resource)activityDispatching.eResource(), settingsIFile);
            monitor.subTask("Validating settings file");
            this.validate((EObject)settings, settings.eResource().getURI().lastSegment());
            EcoreUtil.resolveAll((ResourceSet)this.persistorFactory.getResourceSet());
            ResourceSet resourceSet = ImportsFlattener.flatten((URI)intermediateURI, (ImportContainer[])new ImportContainer[]{activityDispatching, settings});
            activityDispatching = (ActivityDispatching)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, ActivityDispatching.class);
            settings = (Settings)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, Settings.class);
            this.expandAndProcess((ActivitySet)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, ActivitySet.class));
            this.expandAndProcess(activityDispatching);
            if (this.runningInDebugMode) {
                ResourceSetUtil.saveResources((ResourceSet)resourceSet, Collections.emptyMap());
                IFolder intermediateFolder = this.saveIFolder.getFolder(".intermediate");
                intermediateFolder.setHidden(true);
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(prepareSchedulingTicks);
            monitor.subTask("Generating graph from activity dispatching");
            TaskDependencyGraph<Task> graph = this.generateGraphFromActivityDispatching(activityDispatching);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(generateGraphFromActivityDispatchingTicks);
            monitor.subTask("Shortcut claim release");
            graph = this.annotateClaimRelease(graph);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(shortcutClaimReleaseTicks);
            monitor.subTask("Refining graph with execution times");
            graph = this.refineGraphWithExecutionTimes(graph, settings);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(refineGraphWithExecutionTimesTicks);
            monitor.subTask("Scheduling graph on resources");
            Schedule<Task> schedule = this.scheduleGraphOnResources(graph, removeClaimReleaseDependencies);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(scheduleGraphOnResourcesTicks);
            if (criticalPath) {
                monitor.subTask("Performing critical path analysis");
                schedule = this.criticalPathAnalysis(schedule);
            }
            if (stochasticImpact) {
                monitor.subTask("Stochastic impact analysis");
                schedule = this.stochasticImpactAnalysis(schedule, settings);
            }
            monitor.subTask("Analyzing concatenated moves");
            schedule = this.analyzeConcatenatedMoves(schedule);
            monitor.subTask("Visualizing resource claims");
            schedule = this.visualizeResourceClaims(schedule);
            monitor.subTask("Visualizing events ");
            schedule = this.visualizeEvents(schedule);
            monitor.subTask("Visualizing resource claims");
            schedule = this.mergeClaims(schedule);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                monitor.worked(visualizeResourceClaimsTicks);
                OpenEditor<TraceView> traceEditor = null;
                if (ganttChart) {
                    monitor.subTask("Generating gantt chart");
                    traceEditor = this.generateGanttChart(schedule, criticalPath, stochasticImpact);
                    if (!traceEditor.getStatus().isOK()) {
                        throw new CoreException(traceEditor.getStatus());
                    }
                    monitor.worked(generateGanttChartTicks);
                }
                OpenEditor<AnimationView> animationEditor = null;
                if (paperscriptAnimation) {
                    monitor.subTask("Generating Animations");
                    animationEditor = this.generateAnimations(schedule);
                    if (!animationEditor.getStatus().isOK()) {
                        throw new CoreException(animationEditor.getStatus());
                    }
                    monitor.worked(generateAnimationsTicks);
                }
                if (ganttChart && paperscriptAnimation) {
                    this.linkTraceAndAnimations(traceEditor, animationEditor);
                }
            }
            catch (CoreException ce) {
                throw new CoreException((IStatus)new Status(ce.getStatus().getSeverity(), "org.eclipse.lsat.timinganalysis.ui", ce.getMessage(), (Throwable)ce));
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.lsat.timinganalysis.ui", e.getMessage(), (Throwable)e));
            }
        }
        finally {
            this.dispatchingIFile.getProject().refreshLocal(2, monitor);
            monitor.done();
        }
    }

    private TaskDependencyGraph<Task> generateGraphFromActivityDispatching(ActivityDispatching activityDispatching) throws QvtoTransformationException, CoreException, IOException {
        Dispatching2Graph d2g = new Dispatching2Graph();
        Dispatching2GraphOutput d2gResult = (Dispatching2GraphOutput)d2g.transformModel((Object)activityDispatching, this.monitor);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(d2gResult.getResourceModel(), (TaskDependencyGraph<Task>)d2gResult.getTaskDependencyGraph(), null);
        }
        CleanupGraph cleanupGraph = new CleanupGraph(false, CleanupGraph.RemoveClaimReleaseStrategy.KeepAll);
        TaskDependencyGraph graph = (TaskDependencyGraph)cleanupGraph.transformModel((Object)d2gResult.getTaskDependencyGraph(), this.monitor);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(graph.getResourceModel(), (TaskDependencyGraph<Task>)graph, null);
        }
        return graph;
    }

    private void expandAndProcess(ActivityDispatching activityDispatching) {
        DispatchingUtil.expand((ActivityDispatching)activityDispatching);
        DispatchingUtil.removeUnusedActivities((ActivityDispatching)activityDispatching);
    }

    private void expandAndProcess(ActivitySet activitySet) {
        Event2Resource.surroundEventsWithClaimRelease((ActivitySet)activitySet);
    }

    private TaskDependencyGraph<Task> annotateClaimRelease(TaskDependencyGraph<Task> graph) throws IOException, MotionException, CoreException, SpecificationException {
        graph = AnnotateClaimRelease.transformModel(graph);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(graph.getResourceModel(), (TaskDependencyGraph<Task>)graph, null);
        }
        return graph;
    }

    private TaskDependencyGraph<Task> refineGraphWithExecutionTimes(TaskDependencyGraph<Task> graph, Settings settings) throws IOException, MotionException, CoreException, SpecificationException {
        MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
        AddExecutionTimes addExecutionTimes = new AddExecutionTimes((ITimingCalculator)new TimingCalculator(settings, motionCalculator));
        graph = addExecutionTimes.transformModel(graph);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(graph.getResourceModel(), (TaskDependencyGraph<Task>)graph, null);
        }
        return graph;
    }

    private Schedule<Task> scheduleGraphOnResources(TaskDependencyGraph<Task> graph, boolean performCriticalPathAnalysisNoClaims) throws Exception {
        Schedule schedule;
        AsapScheduler scheduler = new AsapScheduler();
        try {
            schedule = scheduler.createSchedule(graph);
        }
        catch (CycleFoundException e) {
            throw new Exception("One or more activities contain cycles.", e);
        }
        schedule.setName(this.saveBaseURI.lastSegment());
        schedule = ALAPScheduler.applyALAPScheduling((Schedule)schedule);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(schedule.getResourceModel(), graph, (Schedule<Task>)schedule);
        }
        CleanupSchedule cleanupSchedule = new CleanupSchedule(performCriticalPathAnalysisNoClaims ? CleanupSchedule.ClaimReleaseStrategy.RemoveDependencies : CleanupSchedule.ClaimReleaseStrategy.Keep);
        schedule = (Schedule)cleanupSchedule.transformModel((Object)schedule, this.monitor);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(schedule.getResourceModel(), null, (Schedule<Task>)schedule);
        }
        return schedule;
    }

    private Schedule<Task> criticalPathAnalysis(Schedule<Task> schedule) throws QvtoTransformationException, CoreException, IOException {
        CriticalPathAnalysis criticalPathAnalysis = new CriticalPathAnalysis();
        criticalPathAnalysis.transformModel(schedule, this.monitor);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(null, null, schedule);
        }
        return schedule;
    }

    private Schedule<Task> stochasticImpactAnalysis(Schedule<Task> schedule, Settings settings) throws QvtoTransformationException, CoreException, IOException {
        StochasticImpactAnalysis stochasticImpactAnalysis = new StochasticImpactAnalysis();
        stochasticImpactAnalysis.transformModel((Object)new StochasticImpactAnalysisInput(schedule, settings), this.monitor);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(null, null, schedule);
        }
        return schedule;
    }

    private Schedule<Task> analyzeConcatenatedMoves(Schedule<Task> schedule) throws QvtoTransformationException, CoreException, IOException {
        ConcatenatedMoveAnalysis concatenatedMoveAnalysis = new ConcatenatedMoveAnalysis();
        Collection erroneousMoves = concatenatedMoveAnalysis.getErroneousPassingMoves(schedule);
        if (!erroneousMoves.isEmpty()) {
            ArrayList confirmed = new ArrayList();
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> confirmed.add(MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)("Parallel actions interrupt concatenated move [" + erroneousMoves.stream().map(c -> c.stream().map(Node::getName).collect(Collectors.joining("->"))).distinct().collect(Collectors.joining(",")) + "]"), (String)"Would you like to analyse the erroneous moves by coloring them orange in the Gantt chart?")));
            if (((Boolean)confirmed.get(0)).booleanValue()) {
                concatenatedMoveAnalysis.annotateErroneousPassingMoves(schedule);
            }
        }
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(null, null, schedule);
        }
        return schedule;
    }

    private Schedule<Task> visualizeResourceClaims(Schedule<Task> schedule) throws QvtoTransformationException, CoreException, IOException {
        VisualizeClaimedBy visualizeClaimedBy = new VisualizeClaimedBy();
        visualizeClaimedBy.transformModel(schedule, this.monitor);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(null, null, schedule);
        }
        return schedule;
    }

    private Schedule<Task> visualizeEvents(Schedule<Task> schedule) throws QvtoTransformationException, CoreException, IOException {
        VisualizeEvents visualizeClaimedBy = new VisualizeEvents();
        visualizeClaimedBy.transformModel(schedule, this.monitor);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(null, null, schedule);
        }
        return schedule;
    }

    private Schedule<Task> mergeClaims(Schedule<Task> schedule) throws QvtoTransformationException, CoreException, IOException {
        MergeClaimedBy mergeClaimedBy = new MergeClaimedBy();
        mergeClaimedBy.transformModel(schedule, this.monitor);
        if (this.runningInDebugMode) {
            this.persistorSaveResourcesGraphSchedule(schedule.getResourceModel(), null, schedule);
        }
        return schedule;
    }

    private OpenEditor<TraceView> generateGanttChart(Schedule<Task> schedule, boolean criticalPath, boolean stochasticImpact) throws IOException, CoreException {
        String traceFileName = this.saveBaseURI.lastSegment();
        if (criticalPath) {
            traceFileName = String.valueOf(traceFileName) + "-critical";
        }
        if (stochasticImpact) {
            traceFileName = String.valueOf(traceFileName) + "-stochastic";
        }
        GenerateAll etfGenerator = new GenerateAll(schedule, (IContainer)this.saveIFolder, criticalPath, stochasticImpact, new String[]{traceFileName});
        IFile traceFile = etfGenerator.generate(this.monitor);
        this.saveIFolder.refreshLocal(1, this.monitor);
        return this.openTrace(traceFile);
    }

    private OpenEditor<AnimationView> generateAnimations(Schedule<Task> schedule) throws IOException, CoreException {
        IFile scheduleJs;
        IFolder animatedIFolder = this.saveIFolder.getFolder("animated");
        File animatedFolder = URIHelper.asFile((IResource)animatedIFolder);
        if (animatedFolder.mkdirs()) {
            this.saveIFolder.refreshLocal(1, this.monitor);
            Machine machine = this.getMachine();
            IFile machineJsFile = animatedIFolder.getFile("machine.js");
            this.createIFile(machineJsFile, GenerateMachineTemplate.generateMachineJavaScript((Machine)machine), this.monitor);
            IFile scheduleHTML = animatedIFolder.getFile("schedule.html");
            this.createIFile(scheduleHTML, GenerateScheduleTemplate.generateScheduleHtml((Machine)machine), this.monitor);
            Settings settings = SettingUtil.getSettings((Resource)machine.eResource());
            IFile settingsJsFile = animatedIFolder.getFile("settings.js");
            this.createIFile(settingsJsFile, GenerateSettingsTemplate.generateSettingsJavaScript((Settings)settings), this.monitor);
        }
        if ((scheduleJs = animatedIFolder.getFile("schedule.js")).exists()) {
            scheduleJs.delete(true, this.monitor);
        }
        this.createIFile(scheduleJs, GenerateScheduleTemplate.generateScheduleJavaScript(schedule), this.monitor);
        animatedIFolder.refreshLocal(1, this.monitor);
        return this.openAnimation(animatedIFolder.getFile("schedule.html"));
    }

    private void createIFile(IFile file, CharSequence content, IProgressMonitor monitor) throws UnsupportedEncodingException, CoreException {
        byte[] bytes = content.toString().getBytes(file.getCharset(true));
        file.create((InputStream)new ByteArrayInputStream(bytes), true, monitor);
    }

    private Machine getMachine() throws CoreException {
        for (Resource resource : this.persistorFactory.getResourceSet().getResources()) {
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof Machine)) continue;
                return (Machine)eObject;
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.lsat.timinganalysis.ui", "Dispatching does not refer to any machine"));
    }

    private void linkTraceAndAnimations(OpenEditor<TraceView> traceEditor, OpenEditor<AnimationView> animationEditor) {
        animationEditor.getEditor().linkTraceEditor(traceEditor.getEditor());
    }

    private void persistorSaveResourcesGraphSchedule(ResourceModel resourceModel, TaskDependencyGraph<Task> graph, Schedule<Task> schedule) throws CoreException, IOException {
        Persistor savePersistor = this.persistorFactory.getPersistor(EObject.class);
        if (resourceModel != null) {
            savePersistor.save(this.saveBaseURI.appendFileExtension("resources"), new EObject[]{resourceModel});
        }
        if (graph != null) {
            savePersistor.save(this.saveBaseURI.appendFileExtension("graph"), new EObject[]{graph});
            Graph2GraphML.transform((URI)this.saveBaseURI.appendFileExtension("graph"), (URI)this.saveBaseURI.appendFileExtension("graphml"));
        }
        if (schedule != null) {
            savePersistor.save(this.saveBaseURI.appendFileExtension("schedule"), new EObject[]{schedule});
            Schedule2GraphML.transform((URI)this.saveBaseURI.appendFileExtension("schedule"), (URI)this.saveBaseURI.appendFileExtension("schedule.graphml"));
        }
    }

    private void validate(EObject object, String fileName) throws IOException {
        IResourceValidator validator;
        List issues;
        if (object.eResource() instanceof XtextResource && !(issues = (validator = ((XtextResource)object.eResource()).getResourceServiceProvider().getResourceValidator()).validate(object.eResource(), CheckMode.ALL, CancelIndicator.NullImpl).stream().filter(i -> i.getSeverity() == Severity.ERROR).collect(Collectors.toList())).isEmpty()) {
            String msg = "\n'" + fileName + "' file is invalid:\n\n" + issues.stream().map(i -> "  \u2022 " + i.getMessage()).collect(Collectors.joining("\n"));
            throw new IllegalArgumentException(msg);
        }
        if (object instanceof ImportContainer) {
            ImportContainer container = (ImportContainer)object;
            for (Import i2 : container.getImports()) {
                for (EObject o : i2.load()) {
                    this.validate(o, i2.getImportURI());
                }
            }
        }
    }

    private OpenEditor<TraceView> openTrace(IFile trace) {
        OpenEditor<TraceView> openEditor = new OpenEditor<TraceView>(trace, "org.eclipse.trace4cps.ui.TraceView", true);
        Display.getDefault().syncExec(openEditor);
        return openEditor;
    }

    private OpenEditor<AnimationView> openAnimation(IFile animation) {
        OpenEditor<AnimationView> openEditor = new OpenEditor<AnimationView>(animation, AnimationView.class.getName());
        Display.getDefault().syncExec(openEditor);
        return openEditor;
    }

    private static final class OpenEditor<T extends IEditorPart>
    implements Runnable {
        private final IFile file;
        private final String editorId;
        private final boolean reOpen;
        private T editor;
        private IStatus status;

        private OpenEditor(IFile file, String editorId) {
            this(file, editorId, false);
        }

        private OpenEditor(IFile file, String editorId, boolean reOpen) {
            this.file = file;
            this.editorId = editorId;
            this.reOpen = reOpen;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public T getEditor() {
            return this.editor;
        }

        @Override
        public void run() {
            try {
                IEditorPart editorToClose;
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                FileEditorInput input = new FileEditorInput(this.file);
                if (this.reOpen && (editorToClose = activePage.findEditor((IEditorInput)input)) != null) {
                    activePage.closeEditor(editorToClose, false);
                }
                this.editor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)this.editorId);
                this.status = Status.OK_STATUS;
            }
            catch (CoreException e) {
                this.status = new Status(e.getStatus().getSeverity(), "org.eclipse.lsat.timinganalysis.ui", e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.status = new Status(4, "org.eclipse.lsat.timinganalysis.ui", e.getMessage(), (Throwable)e);
            }
        }
    }
}

